/*
 * Decompiled with CFR 0.152.
 */
package org.cubewhy.celestial.utils;

import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u001a/\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00012\u0016\u0010\u0004\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u0005\"\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001\u001a\u000e\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"format", "", "Ljava/util/ResourceBundle;", "key", "args", "", "", "(Ljava/util/ResourceBundle;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "safeConvertStringToUuid", "Ljava/util/UUID;", "str", "randomDigitString", "length", "", "celestial"})
public final class TextUtilsKt {
    @NotNull
    public static final String format(@NotNull ResourceBundle $this$format, @NotNull String key, Object ... args) {
        Intrinsics.checkNotNullParameter($this$format, "<this>");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(args, "args");
        String string = $this$format.getString(key);
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        String string2 = string;
        Object[] objectArray = Arrays.copyOf(args, args.length);
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
        return string3;
    }

    @Nullable
    public static final UUID safeConvertStringToUuid(@Nullable String str) {
        Object object = str;
        if (object == null || object.length() == 0) {
            return null;
        }
        try {
            object = UUID.fromString(str);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object = null;
        }
        return object;
    }

    @NotNull
    public static final String randomDigitString(int length) {
        StringBuilder sb = new StringBuilder(length);
        int n = 0;
        while (n < length) {
            int it = n++;
            boolean bl = false;
            sb.append(Random.Default.nextInt(0, 10));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }
}

