/*
 * Decompiled with CFR 0.152.
 */
package org.cubewhy.celestial.utils;

import java.net.InetAddress;
import java.net.URL;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.Json;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.Dns;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.dnsoverhttps.DnsOverHttps;
import org.cubewhy.celestial.CelestialKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fJ\u001e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\u0012\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/cubewhy/celestial/utils/RequestUtils;", "", "<init>", "()V", "appCache", "Lokhttp3/Cache;", "bootstrapClient", "Lokhttp3/OkHttpClient;", "httpClient", "get", "Lokhttp3/Call;", "url", "", "Ljava/net/URL;", "request", "Lokhttp3/Request;", "post", "json", "map", "", "celestial"})
@SourceDebugExtension(value={"SMAP\nRequestUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestUtils.kt\norg/cubewhy/celestial/utils/RequestUtils\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,90:1\n205#2:91\n*S KotlinDebug\n*F\n+ 1 RequestUtils.kt\norg/cubewhy/celestial/utils/RequestUtils\n*L\n72#1:91\n*E\n"})
public final class RequestUtils {
    @NotNull
    public static final RequestUtils INSTANCE;
    @NotNull
    private static final Cache appCache;
    @NotNull
    private static final OkHttpClient bootstrapClient;
    @NotNull
    private static final OkHttpClient httpClient;

    private RequestUtils() {
    }

    @NotNull
    public final Call get(@NotNull String url) {
        Intrinsics.checkNotNullParameter(url, "url");
        return this.get(new URL(url));
    }

    @NotNull
    public final Call get(@NotNull URL url) {
        Intrinsics.checkNotNullParameter(url, "url");
        Request request = new Request.Builder().url(CelestialKt.getConfig().getProxy().useMirror(url)).build();
        return httpClient.newCall(request);
    }

    @NotNull
    public final Call request(@NotNull Request request) {
        Intrinsics.checkNotNullParameter(request, "request");
        return httpClient.newCall(request);
    }

    @NotNull
    public final Call post(@NotNull String url, @NotNull String json) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(json, "json");
        RequestBody body = RequestBody.Companion.create(json, MediaType.Companion.get("application/json"));
        Request request = new Request.Builder().url(url).post(body).build();
        return httpClient.newCall(request);
    }

    @NotNull
    public final Call post(@NotNull String url, @NotNull Map<?, ?> map2) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(map2, "map");
        RequestUtils requestUtils = this;
        String string = url;
        Json this_$iv = CelestialKt.getJSON();
        boolean $i$f$encodeToString = false;
        Json json = this_$iv;
        this_$iv.getSerializersModule();
        throw (Throwable)new IllegalArgumentException("Star projections in type arguments are not allowed, but had kotlin.collections.Map<*, *>");
    }

    static {
        Dns dns;
        INSTANCE = new RequestUtils();
        appCache = new Cache(FilesKt.resolve(FilesKt.resolve(CelestialKt.getConfigDir(), "cache"), "okhttp"), 0xA00000L);
        bootstrapClient = new OkHttpClient.Builder().cache(appCache).build();
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (CelestialKt.getConfig().getProxy().getDoh()) {
            InetAddress[] inetAddressArray = new InetAddress[]{InetAddress.getByName("8.8.4.4"), InetAddress.getByName("8.8.8.8")};
            dns = new DnsOverHttps.Builder().client(bootstrapClient).url(HttpUrl.Companion.get(CelestialKt.getConfig().getProxy().getDohServer())).bootstrapDnsHosts(inetAddressArray).build();
        } else {
            dns = Dns.SYSTEM;
        }
        httpClient = builder.dns(dns).proxy(CelestialKt.getConfig().getProxy().toProxy()).build();
    }
}

