/*
 * Decompiled with CFR 0.152.
 */
package org.cubewhy.celestial.gui.pages;

import cn.hutool.crypto.SecureUtil;
import java.awt.Color;
import java.awt.GridLayout;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.cubewhy.celestial.CelestialKt;
import org.cubewhy.celestial.event.EventManager;
import org.cubewhy.celestial.event.EventTarget;
import org.cubewhy.celestial.event.impl.APIReadyEvent;
import org.cubewhy.celestial.files.DownloadManager;
import org.cubewhy.celestial.gui.LauncherAlert;
import org.cubewhy.celestial.gui.LauncherBirthday;
import org.cubewhy.celestial.gui.LauncherNews;
import org.cubewhy.celestial.utils.GuiUtilsKt;
import org.cubewhy.celestial.utils.lunar.Alert;
import org.cubewhy.celestial.utils.lunar.Blogpost;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\nH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/cubewhy/celestial/gui/pages/NewsPanel;", "Ljavax/swing/JScrollPane;", "<init>", "()V", "blogPosts", "", "Lorg/cubewhy/celestial/utils/lunar/Blogpost;", "calcBirthday", "", "onAPIReady", "", "event", "Lorg/cubewhy/celestial/event/impl/APIReadyEvent;", "initGui", "Companion", "celestial"})
public final class NewsPanel
extends JScrollPane {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private List<Blogpost> blogPosts;
    @NotNull
    private static final JPanel panel = new JPanel();
    @NotNull
    private static final Logger log;

    public NewsPanel() {
        super(panel, 20, 30);
        EventManager.INSTANCE.register(this);
        this.setBorder(new TitledBorder(null, CelestialKt.getT().getString("gui.news.title"), 0, 0, null, Color.orange));
        panel.setLayout(new GridLayout(0, 2, 10, 10));
        this.getVerticalScrollBar().setUnitIncrement(30);
    }

    private final int calcBirthday() {
        LocalDate birthday = LocalDate.of(LocalDate.now().getYear(), 7, 29);
        LocalDate today = LocalDate.now();
        return (int)ChronoUnit.DAYS.between(today, birthday);
    }

    @EventTarget
    public final void onAPIReady(@NotNull APIReadyEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.blogPosts = CelestialKt.getMetadata().getBlogposts();
        panel.removeAll();
        this.initGui();
    }

    private final void initGui() {
        List<Blogpost> list;
        try {
            Alert alert = CelestialKt.getMetadata().getAlert();
            if (alert != null) {
                String title = alert.getName();
                String message = alert.getText();
                log.info(title + ": " + message);
                panel.add(new LauncherAlert(alert));
            }
        }
        catch (Exception e) {
            log.warn("Warning: Load alert failed");
            log.error(ExceptionsKt.stackTraceToString(e));
        }
        log.info("Loading blogPosts (gui)");
        int birthday = this.calcBirthday();
        if (Math.abs(birthday) <= 10) {
            panel.add(new LauncherBirthday(birthday));
        }
        if ((list = this.blogPosts) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("blogPosts");
            list = null;
        }
        if (list.isEmpty()) {
            log.error("Failed to load blog posts");
            panel.add(GuiUtilsKt.toJLabel("Failed to load news (blogPosts is empty)"));
        } else {
            List<Blogpost> list2 = this.blogPosts;
            if (list2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("blogPosts");
                list2 = null;
            }
            for (Blogpost blogPost : list2) {
                Object object;
                String imageURL = blogPost.getImage();
                String title = blogPost.getTitle();
                try {
                    object = BuildersKt.launch$default(CoroutineScopeKt.CoroutineScope(Dispatchers.getIO()), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(imageURL, title, blogPost, null){
                        int label;
                        final /* synthetic */ String $imageURL;
                        final /* synthetic */ String $title;
                        final /* synthetic */ Blogpost $blogPost;
                        {
                            this.$imageURL = $imageURL;
                            this.$title = $title;
                            this.$blogPost = $blogPost;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public final Object invokeSuspend(Object var1_1) {
                            var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure(var1_1);
                                    this.label = 1;
                                    v0 = DownloadManager.INSTANCE.cache(new URL(this.$imageURL), "news/" + SecureUtil.sha1(this.$title), false, this);
                                    if (v0 == var2_2) {
                                        return var2_2;
                                    }
                                    ** GOTO lbl13
                                }
                                case 1: {
                                    ResultKt.throwOnFailure($result);
                                    v0 = $result;
lbl13:
                                    // 2 sources

                                    if (((Boolean)v0).booleanValue()) {
                                        NewsPanel.access$getPanel$cp().add(new LauncherNews(this.$blogPost));
                                    }
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, 3, null);
                }
                catch (IOException e) {
                    log.warn("Failed to cache " + imageURL);
                    log.error(ExceptionsKt.stackTraceToString(e));
                    object = Unit.INSTANCE;
                }
                catch (NullPointerException e) {
                    panel.add(new JLabel(CelestialKt.getT().getString("gui.news.official")));
                    log.warn("Failed to load news " + imageURL);
                    log.error(ExceptionsKt.stackTraceToString(e));
                    object = Unit.INSTANCE;
                }
            }
        }
    }

    public static final /* synthetic */ JPanel access$getPanel$cp() {
        return panel;
    }

    static {
        Logger logger = LoggerFactory.getLogger(NewsPanel.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        log = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/cubewhy/celestial/gui/pages/NewsPanel$Companion;", "", "<init>", "()V", "panel", "Ljavax/swing/JPanel;", "log", "Lorg/slf4j/Logger;", "celestial"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

