/*
 * Decompiled with CFR 0.152.
 */
package org.cubewhy.celestial.gui.elements;

import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.cubewhy.celestial.CelestialKt;
import org.cubewhy.celestial.gui.layouts.VerticalFlowLayout;
import org.cubewhy.celestial.utils.FileUtilsKt;
import org.cubewhy.celestial.utils.GuiUtilsKt;
import org.cubewhy.celestial.utils.SystemUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/cubewhy/celestial/gui/elements/PatchDialog;", "Ljavax/swing/JDialog;", "panel", "Ljavax/swing/JPanel;", "patch", "Ljava/io/File;", "<init>", "(Ljavax/swing/JPanel;Ljava/io/File;)V", "initGui", "", "doPatch", "Ljava/lang/ProcessBuilder;", "lunar", "celestial"})
public final class PatchDialog
extends JDialog {
    @NotNull
    private final File patch;

    public PatchDialog(@NotNull JPanel panel, @NotNull File patch) {
        Intrinsics.checkNotNullParameter(panel, "panel");
        Intrinsics.checkNotNullParameter(patch, "patch");
        Window window = SwingUtilities.getWindowAncestor(panel);
        Intrinsics.checkNotNull(window, "null cannot be cast to non-null type javax.swing.JFrame");
        super((JFrame)window);
        this.patch = patch;
        this.setTitle(CelestialKt.getT().getString("gui.addons.patch.title"));
        this.setLayout(new VerticalFlowLayout(0, 0, 0, 0, 0, 0, false, false, 255, null));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setLocationByPlatform(true);
        this.setSize(600, 600);
        this.initGui();
    }

    /*
     * WARNING - void declaration
     */
    public final void initGui() {
        void $this$initGui_u24lambda_u242;
        JButton jButton;
        File gameDir = new File(CelestialKt.getConfig().getInstallationDir());
        String string = this.patch.getPath();
        Intrinsics.checkNotNullExpressionValue(string, "getPath(...)");
        this.add(GuiUtilsKt.readOnly(GuiUtilsKt.toJTextArea(string)));
        String string2 = CelestialKt.getT().getString("gui.addons.patch.warn");
        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
        this.add(GuiUtilsKt.readOnly(GuiUtilsKt.toJTextArea(string2)));
        File lunarJar = FilesKt.resolve(gameDir, "lunar.jar");
        if (!gameDir.exists() && !lunarJar.exists()) {
            String string3 = CelestialKt.getT().getString("gui.addons.patch.not-installed");
            Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
            this.add(GuiUtilsKt.toJLabel(string3));
            return;
        }
        if (!FileUtilsKt.isZipFile(this.patch)) {
            String string4 = CelestialKt.getT().getString("gui.addons.patch.not-zip");
            Intrinsics.checkNotNullExpressionValue(string4, "getString(...)");
            this.add(GuiUtilsKt.toJLabel(string4));
        }
        JButton jButton2 = jButton = new JButton(CelestialKt.getT().getString("gui.addons.patch.confirm"));
        PatchDialog patchDialog = this;
        boolean bl = false;
        $this$initGui_u24lambda_u242.addActionListener(arg_0 -> PatchDialog.initGui$lambda$2$lambda$1(this, lunarJar, arg_0));
        patchDialog.add(jButton);
    }

    private final ProcessBuilder doPatch(File lunar) {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        String[] stringArray = new String[]{SystemUtilsKt.getCurrentJavaExec().getPath(), "-jar", this.patch.getPath(), lunar.getPath(), lunar.getPath()};
        builder.command(stringArray);
        return builder;
    }

    private static final void initGui$lambda$2$lambda$1$lambda$0(PatchDialog this$0, File $lunarJar, JButton $source) {
        int code = this$0.doPatch($lunarJar).start().waitFor();
        $source.setText(code == 0 ? CelestialKt.getT().getString("gui.addons.patch.done") : CelestialKt.getT().getString("gui.addons.patch.fail"));
    }

    private static final void initGui$lambda$2$lambda$1(PatchDialog this$0, File $lunarJar, ActionEvent e) {
        Intrinsics.checkNotNull(e);
        JButton source2 = (JButton)GuiUtilsKt.source(e);
        source2.setEnabled(false);
        new Thread(() -> PatchDialog.initGui$lambda$2$lambda$1$lambda$0(this$0, $lunarJar, source2)).start();
    }
}

