/*
 * Decompiled with CFR 0.152.
 */
package org.cubewhy.celestial.gui.elements;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.filechooser.FileNameExtensionFilter;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.cubewhy.celestial.CelestialKt;
import org.cubewhy.celestial.event.impl.AddonAddEvent;
import org.cubewhy.celestial.files.DownloadManager;
import org.cubewhy.celestial.game.AddonType;
import org.cubewhy.celestial.game.BaseAddon;
import org.cubewhy.celestial.game.addon.FabricMod;
import org.cubewhy.celestial.game.addon.JavaAgent;
import org.cubewhy.celestial.game.addon.LunarCNMod;
import org.cubewhy.celestial.game.addon.WeaveMod;
import org.cubewhy.celestial.gui.LauncherMainWindow;
import org.cubewhy.celestial.gui.elements.PatchDialog;
import org.cubewhy.celestial.gui.elements.SearchableList;
import org.cubewhy.celestial.gui.elements.StatusBar;
import org.cubewhy.celestial.gui.elements.StatusBarKt;
import org.cubewhy.celestial.utils.FileUtilsKt;
import org.cubewhy.celestial.utils.GuiUtilsKt;
import org.cubewhy.celestial.utils.TextUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001%B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0001H\u0002J\b\u0010\u001b\u001a\u00020\u0018H\u0002J\b\u0010\u001c\u001a\u00020\u0018H\u0002J \u0010\u001d\u001a\u00020\u00182\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\u0018H\u0002J\b\u0010$\u001a\u00020\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/cubewhy/celestial/gui/elements/GuiAddonManager;", "Ljavax/swing/JPanel;", "<init>", "()V", "tab", "Ljavax/swing/JTabbedPane;", "lunarcnList", "Ljavax/swing/DefaultListModel;", "Lorg/cubewhy/celestial/game/addon/LunarCNMod;", "weaveList", "Lorg/cubewhy/celestial/game/addon/WeaveMod;", "agentList", "Lorg/cubewhy/celestial/game/addon/JavaAgent;", "fabricList", "Lorg/cubewhy/celestial/game/addon/FabricMod;", "toggleWeave", "Ljavax/swing/JMenuItem;", "toggleCN", "toggleAgent", "toggleAgentClasspath", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "initGui", "", "autoRefresh", "panel", "loadFabricMods", "loadLunarCNMods", "bindMenu", "list", "Ljavax/swing/JList;", "Lorg/cubewhy/celestial/game/BaseAddon;", "menu", "Ljavax/swing/JPopupMenu;", "loadWeaveMods", "loadAgents", "PatchTransferHandler", "celestial"})
public final class GuiAddonManager
extends JPanel {
    @NotNull
    private final JTabbedPane tab = new JTabbedPane();
    @NotNull
    private final DefaultListModel<LunarCNMod> lunarcnList = new DefaultListModel();
    @NotNull
    private final DefaultListModel<WeaveMod> weaveList = new DefaultListModel();
    @NotNull
    private final DefaultListModel<JavaAgent> agentList = new DefaultListModel();
    @NotNull
    private final DefaultListModel<FabricMod> fabricList = new DefaultListModel();
    @NotNull
    private final JMenuItem toggleWeave = new JMenuItem("toggle");
    @NotNull
    private final JMenuItem toggleCN = new JMenuItem("toggle");
    @NotNull
    private final JMenuItem toggleAgent = new JMenuItem("toggle");
    @NotNull
    private final JMenuItem toggleAgentClasspath = new JMenuItem("toggle-classpath");
    private final Logger log = LoggerFactory.getLogger(DownloadManager.class);

    public GuiAddonManager() {
        this.setBorder(new TitledBorder(null, CelestialKt.getT().getString("gui.addons.title"), 0, 0, null, Color.orange));
        this.setLayout(new BoxLayout(this, 1));
        this.initGui();
    }

    private final void initGui() {
        this.loadAgents();
        this.loadWeaveMods();
        this.loadLunarCNMods();
        this.loadFabricMods();
        JList jListLunarCN = new JList(this.lunarcnList);
        JList jListWeave = new JList(this.weaveList);
        JList jListAgents = new JList(this.agentList);
        JList jListFabric = new JList(this.fabricList);
        this.toggleWeave.addActionListener(arg_0 -> GuiAddonManager.initGui$lambda$0(jListWeave, this, arg_0));
        this.toggleCN.addActionListener(arg_0 -> GuiAddonManager.initGui$lambda$1(jListLunarCN, this, arg_0));
        this.toggleAgent.addActionListener(arg_0 -> GuiAddonManager.initGui$lambda$2(jListAgents, this, arg_0));
        this.toggleAgentClasspath.addActionListener(arg_0 -> GuiAddonManager.initGui$lambda$3(jListAgents, this, arg_0));
        JPopupMenu agentMenu = new JPopupMenu();
        agentMenu.add(this.toggleAgent);
        agentMenu.add(this.toggleAgentClasspath);
        JMenuItem manageArg = new JMenuItem(CelestialKt.getT().getString("gui.addon.agents.arg"));
        JMenuItem removeAgent = new JMenuItem(CelestialKt.getT().getString("gui.addon.agents.remove"));
        JMenuItem renameAgent = new JMenuItem(CelestialKt.getT().getString("gui.addon.rename"));
        JMenuItem openAgentConfigUi = new JMenuItem(CelestialKt.getT().getString("gui.addon.extra-ui"));
        agentMenu.add(openAgentConfigUi);
        agentMenu.add(manageArg);
        agentMenu.add(renameAgent);
        agentMenu.addSeparator();
        agentMenu.add(removeAgent);
        manageArg.addActionListener(arg_0 -> GuiAddonManager.initGui$lambda$4(jListAgents, this, arg_0));
        removeAgent.addActionListener(arg_0 -> GuiAddonManager.initGui$lambda$5(jListAgents, this, arg_0));
        renameAgent.addActionListener(arg_0 -> GuiAddonManager.initGui$lambda$6(jListAgents, this, arg_0));
        openAgentConfigUi.addActionListener(arg_0 -> GuiAddonManager.initGui$lambda$7(jListAgents, this, arg_0));
        JPopupMenu weaveMenu = new JPopupMenu();
        weaveMenu.add(this.toggleWeave);
        JMenuItem renameWeaveMod = new JMenuItem(CelestialKt.getT().getString("gui.addon.rename"));
        JMenuItem removeWeaveMod = new JMenuItem(CelestialKt.getT().getString("gui.addon.mods.weave.remove"));
        weaveMenu.add(renameWeaveMod);
        weaveMenu.addSeparator();
        weaveMenu.add(removeWeaveMod);
        renameWeaveMod.addActionListener(arg_0 -> GuiAddonManager.initGui$lambda$8(jListWeave, this, arg_0));
        removeWeaveMod.addActionListener(arg_0 -> GuiAddonManager.initGui$lambda$9(jListWeave, this, arg_0));
        JPopupMenu lunarCNMenu = new JPopupMenu();
        lunarCNMenu.add(this.toggleCN);
        JMenuItem renameLunarCNMod = new JMenuItem(CelestialKt.getT().getString("gui.addon.rename"));
        JMenuItem removeLunarCNMod = new JMenuItem(CelestialKt.getT().getString("gui.addon.mods.cn.remove"));
        lunarCNMenu.add(renameLunarCNMod);
        lunarCNMenu.addSeparator();
        lunarCNMenu.add(removeLunarCNMod);
        renameLunarCNMod.addActionListener(arg_0 -> GuiAddonManager.initGui$lambda$10(jListLunarCN, this, arg_0));
        removeLunarCNMod.addActionListener(arg_0 -> GuiAddonManager.initGui$lambda$11(jListLunarCN, this, arg_0));
        JPopupMenu fabricMenu = new JPopupMenu();
        JMenuItem renameFabricMod = new JMenuItem(CelestialKt.getT().getString("gui.addon.rename"));
        JMenuItem removeFabricMod = new JMenuItem(CelestialKt.getT().getString("gui.addon.mods.fabric.remove"));
        renameFabricMod.addActionListener(arg_0 -> GuiAddonManager.initGui$lambda$12(jListFabric, this, arg_0));
        removeFabricMod.addActionListener(arg_0 -> GuiAddonManager.initGui$lambda$13(jListFabric, this, arg_0));
        fabricMenu.add(renameFabricMod);
        fabricMenu.addSeparator();
        fabricMenu.add(removeFabricMod);
        this.bindMenu(jListLunarCN, lunarCNMenu);
        this.bindMenu(jListWeave, weaveMenu);
        this.bindMenu(jListFabric, fabricMenu);
        this.bindMenu(jListAgents, agentMenu);
        JButton btnAddLunarCNMod = new JButton(CelestialKt.getT().getString("gui.addon.mods.add"));
        JButton btnAddWeaveMod = new JButton(CelestialKt.getT().getString("gui.addon.mods.add"));
        JButton btnAddFabric = new JButton(CelestialKt.getT().getString("gui.addon.mods.add"));
        JButton btnAddAgent = new JButton(CelestialKt.getT().getString("gui.addon.agents.add"));
        btnAddAgent.addActionListener(arg_0 -> GuiAddonManager.initGui$lambda$14(this, arg_0));
        btnAddWeaveMod.addActionListener(arg_0 -> GuiAddonManager.initGui$lambda$15(this, arg_0));
        btnAddLunarCNMod.addActionListener(arg_0 -> GuiAddonManager.initGui$lambda$16(this, arg_0));
        btnAddFabric.addActionListener(arg_0 -> GuiAddonManager.initGui$lambda$17(this, arg_0));
        JPanel panelLunarCN = new JPanel();
        panelLunarCN.setName("cn");
        panelLunarCN.setLayout(new BoxLayout(panelLunarCN, 1));
        panelLunarCN.add(new SearchableList<LunarCNMod>(this.lunarcnList, jListLunarCN));
        JPanel btnPanel1 = new JPanel();
        btnPanel1.setLayout(new BoxLayout(btnPanel1, 0));
        btnPanel1.add(btnAddLunarCNMod);
        btnPanel1.add(GuiUtilsKt.createButtonOpenFolder(CelestialKt.getT().getString("gui.addon.folder"), LunarCNMod.Companion.getModFolder()));
        panelLunarCN.add(btnPanel1);
        JPanel panelWeave = new JPanel();
        panelWeave.setName("weave");
        panelWeave.setLayout(new BoxLayout(panelWeave, 1));
        panelWeave.add(new SearchableList<WeaveMod>(this.weaveList, jListWeave));
        JPanel btnPanel2 = new JPanel();
        btnPanel2.setLayout(new BoxLayout(btnPanel2, 0));
        btnPanel2.add(btnAddWeaveMod);
        btnPanel2.add(GuiUtilsKt.createButtonOpenFolder(CelestialKt.getT().getString("gui.addon.folder"), WeaveMod.Companion.getModFolder()));
        panelWeave.add(btnPanel2);
        JPanel panelAgents = new JPanel();
        panelAgents.setName("agents");
        panelAgents.setLayout(new BoxLayout(panelAgents, 1));
        panelAgents.add(new SearchableList<JavaAgent>(this.agentList, jListAgents));
        JPanel btnPanel3 = new JPanel();
        btnPanel3.setLayout(new BoxLayout(btnPanel3, 0));
        btnPanel3.add(btnAddAgent);
        btnPanel3.add(GuiUtilsKt.createButtonOpenFolder(CelestialKt.getT().getString("gui.addon.folder"), JavaAgent.Companion.getJavaAgentFolder()));
        panelAgents.add(btnPanel3);
        JPanel panelFabric = new JPanel();
        panelFabric.setName("fabric");
        panelFabric.setLayout(new BoxLayout(panelFabric, 1));
        panelFabric.add(GuiUtilsKt.toJLabel("Not fully support Fabric yet, please add mods by your self"));
        JPanel btnPanel4 = new JPanel();
        btnPanel4.setLayout(new BoxLayout(btnPanel4, 0));
        btnPanel4.add(GuiUtilsKt.createButtonOpenFolder(CelestialKt.getT().getString("gui.addon.folder"), FabricMod.Companion.getModFolder()));
        panelFabric.add(btnPanel4);
        JPanel panelCelePatch = new JPanel();
        panelCelePatch.setName("celepatch");
        panelCelePatch.setLayout(new GridBagLayout());
        panelCelePatch.setTransferHandler(new PatchTransferHandler());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 10;
        String string = CelestialKt.getT().getString("gui.addons.patch.drag");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        panelCelePatch.add((Component)GuiUtilsKt.toJButton(string, arg_0 -> GuiAddonManager.initGui$lambda$19(panelCelePatch, arg_0)), gbc);
        this.tab.addTab(CelestialKt.getT().getString("gui.addons.agents"), panelAgents);
        this.tab.addTab(CelestialKt.getT().getString("gui.addons.mods.cn"), panelLunarCN);
        this.tab.addTab(CelestialKt.getT().getString("gui.addons.mods.weave"), panelWeave);
        this.tab.addTab(CelestialKt.getT().getString("gui.addons.mods.fabric"), panelFabric);
        this.tab.addTab(CelestialKt.getT().getString("gui.addons.patch"), panelCelePatch);
        this.add(this.tab);
        this.tab.addChangeListener(arg_0 -> GuiAddonManager.initGui$lambda$20(this, arg_0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void autoRefresh(JPanel panel) {
        block8: {
            block9: {
                String name = panel.getName();
                this.log.debug("Refreshing mod list " + name + " (Focus changed)");
                String string = name;
                if (string == null) return;
                switch (string.hashCode()) {
                    case -1282179931: {
                        if (!string.equals("fabric")) {
                            return;
                        }
                        break block8;
                    }
                    case 3179: {
                        if (!string.equals("cn")) {
                            return;
                        }
                        break block9;
                    }
                    case 113004866: {
                        if (string.equals("weave")) break;
                        return;
                    }
                    case -1419698674: {
                        if (!string.equals("agents")) return;
                        this.agentList.clear();
                        this.loadAgents();
                        return;
                    }
                }
                this.weaveList.clear();
                this.loadWeaveMods();
                return;
            }
            this.lunarcnList.clear();
            this.loadLunarCNMods();
            return;
        }
        this.fabricList.clear();
        this.loadFabricMods();
    }

    private final void loadFabricMods() {
        for (FabricMod mod : FabricMod.Companion.findAll()) {
            this.fabricList.addElement(mod);
        }
    }

    private final void loadLunarCNMods() {
        for (LunarCNMod lunarCNMod : LunarCNMod.Companion.findAll()) {
            this.lunarcnList.addElement(lunarCNMod);
        }
    }

    private final void bindMenu(JList<? extends BaseAddon> list, JPopupMenu menu) {
        list.addMouseListener(new MouseAdapter(list, this, menu){
            final /* synthetic */ JList<? extends BaseAddon> $list;
            final /* synthetic */ GuiAddonManager this$0;
            final /* synthetic */ JPopupMenu $menu;
            {
                this.$list = $list;
                this.this$0 = $receiver;
                this.$menu = $menu;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter(e, "e");
                if (SwingUtilities.isRightMouseButton(e)) {
                    int index = this.$list.locationToIndex(e.getPoint());
                    this.$list.setSelectedIndex(index);
                    BaseAddon baseAddon = this.$list.getSelectedValue();
                    if (baseAddon == null) {
                        return;
                    }
                    BaseAddon current = baseAddon;
                    if (current.isEnabled()) {
                        GuiAddonManager.access$getToggleWeave$p(this.this$0).setText(CelestialKt.getT().getString("gui.addon.toggle.disable"));
                        GuiAddonManager.access$getToggleAgent$p(this.this$0).setText(CelestialKt.getT().getString("gui.addon.toggle.disable"));
                        GuiAddonManager.access$getToggleCN$p(this.this$0).setText(CelestialKt.getT().getString("gui.addon.toggle.disable"));
                    } else {
                        GuiAddonManager.access$getToggleWeave$p(this.this$0).setText(CelestialKt.getT().getString("gui.addon.toggle.enable"));
                        GuiAddonManager.access$getToggleAgent$p(this.this$0).setText(CelestialKt.getT().getString("gui.addon.toggle.enable"));
                        GuiAddonManager.access$getToggleCN$p(this.this$0).setText(CelestialKt.getT().getString("gui.addon.toggle.enable"));
                    }
                    if (current instanceof JavaAgent) {
                        if (((JavaAgent)current).getClasspath()) {
                            GuiAddonManager.access$getToggleAgentClasspath$p(this.this$0).setText(CelestialKt.getT().getString("gui.addon.agents.cp.disable"));
                        } else {
                            GuiAddonManager.access$getToggleAgentClasspath$p(this.this$0).setText(CelestialKt.getT().getString("gui.addon.agents.cp.enable"));
                        }
                    }
                    this.$menu.show(this.$list, e.getX(), e.getY());
                }
            }
        });
    }

    private final void loadWeaveMods() {
        for (WeaveMod weaveMod : WeaveMod.Companion.findAll()) {
            this.weaveList.addElement(weaveMod);
        }
    }

    private final void loadAgents() {
        for (JavaAgent javaAgent : JavaAgent.Companion.findAll()) {
            this.agentList.addElement(javaAgent);
        }
    }

    private static final void initGui$lambda$0(JList $jListWeave, GuiAddonManager this$0, ActionEvent it) {
        ((WeaveMod)$jListWeave.getSelectedValue()).toggle();
        this$0.weaveList.removeAllElements();
        this$0.loadWeaveMods();
    }

    private static final void initGui$lambda$1(JList $jListLunarCN, GuiAddonManager this$0, ActionEvent it) {
        ((LunarCNMod)$jListLunarCN.getSelectedValue()).toggle();
        this$0.lunarcnList.removeAllElements();
        this$0.loadLunarCNMods();
    }

    private static final void initGui$lambda$2(JList $jListAgents, GuiAddonManager this$0, ActionEvent it) {
        ((JavaAgent)$jListAgents.getSelectedValue()).toggle();
        this$0.agentList.removeAllElements();
        this$0.loadAgents();
    }

    private static final void initGui$lambda$3(JList $jListAgents, GuiAddonManager this$0, ActionEvent it) {
        ((JavaAgent)$jListAgents.getSelectedValue()).toggleClasspath();
        this$0.agentList.removeAllElements();
        this$0.loadAgents();
    }

    private static final void initGui$lambda$4(JList $jListAgents, GuiAddonManager this$0, ActionEvent it) {
        JavaAgent currentAgent = (JavaAgent)$jListAgents.getSelectedValue();
        String newArg = JOptionPane.showInputDialog(this$0, CelestialKt.getT().getString("gui.addon.agents.arg.message"), currentAgent.getArg());
        if (newArg != null && !Intrinsics.areEqual(currentAgent.getArg(), newArg)) {
            Intrinsics.checkNotNull(currentAgent);
            JavaAgent.Companion.setArgFor(currentAgent, newArg);
            if (StringsKt.isBlank(newArg)) {
                String string = CelestialKt.getT().getString("gui.addon.agents.arg.remove.success");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                String string2 = string;
                Object[] objectArray = new Object[]{currentAgent.getFile().getName()};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
                StatusBarKt.updateStatusText(string3);
            } else {
                Object[] objectArray = new Object[]{currentAgent.getFile().getName(), newArg};
                StatusBarKt.updateStatusText(TextUtilsKt.format(CelestialKt.getT(), "gui.addon.agents.arg.set.success", objectArray));
            }
            this$0.agentList.clear();
            this$0.loadAgents();
        }
    }

    private static final void initGui$lambda$5(JList $jListAgents, GuiAddonManager this$0, ActionEvent it) {
        JavaAgent currentAgent = (JavaAgent)$jListAgents.getSelectedValue();
        String name = currentAgent.getFile().getName();
        Object[] objectArray = new Object[]{name};
        if (JOptionPane.showConfirmDialog(this$0, TextUtilsKt.format(CelestialKt.getT(), "gui.addon.agents.remove.confirm.message", objectArray), CelestialKt.getT().getString("gui.addon.agents.remove.confirm.title"), 2) == 0 && currentAgent.getFile().delete()) {
            objectArray = new Object[]{name};
            StatusBarKt.updateStatusText(TextUtilsKt.format(CelestialKt.getT(), "gui.addon.agents.remove.success", objectArray));
            this$0.agentList.clear();
            this$0.loadAgents();
        }
    }

    private static final void initGui$lambda$6(JList $jListAgents, GuiAddonManager this$0, ActionEvent it) {
        JavaAgent currentAgent = (JavaAgent)$jListAgents.getSelectedValue();
        File file = currentAgent.getFile();
        String name = file.getName();
        Component component = this$0;
        String string = CelestialKt.getT().getString("gui.addon.rename.dialog.message");
        Intrinsics.checkNotNull(name);
        String string2 = name.substring(0, name.length() - 4);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        String newName = JOptionPane.showInputDialog(component, string, string2);
        if (newName != null && file.renameTo(new File(file.getParentFile(), newName + ".jar"))) {
            this$0.log.info("Rename agent " + name + " -> " + newName + ".jar");
            Object[] objectArray = new Object[]{newName};
            StatusBarKt.updateStatusText(TextUtilsKt.format(CelestialKt.getT(), "gui.addon.rename.success", objectArray));
            JavaAgent.Companion.migrate(name, newName + ".jar");
            this$0.agentList.clear();
            this$0.loadAgents();
        }
    }

    private static final void initGui$lambda$7(JList $jListAgents, GuiAddonManager this$0, ActionEvent it) {
        JavaAgent currentAgent = (JavaAgent)$jListAgents.getSelectedValue();
        if (currentAgent.getHasExtraUi()) {
            currentAgent.openConfigWindow();
        } else {
            JOptionPane.showMessageDialog(this$0, CelestialKt.getT().getString("gui.addon.extra-ui.unavailable.description"), CelestialKt.getT().getString("gui.addon.extra-ui.unavailable.title"), 0);
        }
    }

    private static final void initGui$lambda$8(JList $jListWeave, GuiAddonManager this$0, ActionEvent it) {
        WeaveMod currentMod = (WeaveMod)$jListWeave.getSelectedValue();
        File file = currentMod.getFile();
        String name = file.getName();
        Component component = this$0;
        String string = CelestialKt.getT().getString("gui.addon.rename.dialog.message");
        Intrinsics.checkNotNull(name);
        String string2 = name.substring(0, name.length() - 4);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        String newName = JOptionPane.showInputDialog(component, string, string2);
        if (newName != null && file.renameTo(new File(file.getParentFile(), newName + ".jar"))) {
            Logger logger = this$0.log;
            String string3 = "Rename weave mod %s -> %s";
            Object[] objectArray = new Object[]{name, newName + ".jar"};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string4, "format(...)");
            logger.info(string4);
            Object[] objectArray2 = new Object[]{newName};
            StatusBarKt.updateStatusText(TextUtilsKt.format(CelestialKt.getT(), "gui.addon.rename.success", objectArray2));
            this$0.weaveList.clear();
            this$0.loadWeaveMods();
        }
    }

    private static final void initGui$lambda$9(JList $jListWeave, GuiAddonManager this$0, ActionEvent it) {
        WeaveMod currentMod = (WeaveMod)$jListWeave.getSelectedValue();
        String name = currentMod.getFile().getName();
        Object[] objectArray = new Object[]{name};
        if (JOptionPane.showConfirmDialog(this$0, TextUtilsKt.format(CelestialKt.getT(), "gui.addon.mods.weave.remove.confirm.message", objectArray), CelestialKt.getT().getString("gui.addon.mods.weave.remove.confirm.title"), 2) == 0 && currentMod.getFile().delete()) {
            StatusBar statusBar = LauncherMainWindow.Companion.getStatusBar();
            String string = CelestialKt.getT().getString("gui.addon.mods.weave.remove.success");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            String string2 = string;
            Object[] objectArray2 = new Object[]{name};
            String string3 = String.format(string2, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
            statusBar.setText(string3);
            this$0.weaveList.clear();
            this$0.loadWeaveMods();
        }
    }

    private static final void initGui$lambda$10(JList $jListLunarCN, GuiAddonManager this$0, ActionEvent it) {
        LunarCNMod currentMod = (LunarCNMod)$jListLunarCN.getSelectedValue();
        File file = currentMod.getFile();
        String name = file.getName();
        Component component = this$0;
        String string = CelestialKt.getT().getString("gui.addon.rename.dialog.message");
        Intrinsics.checkNotNull(name);
        String string2 = name.substring(0, name.length() - 4);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        String newName = JOptionPane.showInputDialog(component, string, string2);
        if (newName != null && file.renameTo(new File(file.getParentFile(), newName + ".jar"))) {
            Logger logger = this$0.log;
            String string3 = "Rename LunarCN mod %s -> %s";
            Object[] objectArray = new Object[]{name, newName + ".jar"};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string4, "format(...)");
            logger.info(string4);
            String string5 = CelestialKt.getT().getString("gui.addon.rename.success");
            Intrinsics.checkNotNullExpressionValue(string5, "getString(...)");
            string3 = string5;
            objectArray = new Object[]{newName};
            String string6 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string6, "format(...)");
            StatusBarKt.updateStatusText(string6);
            this$0.lunarcnList.clear();
            this$0.loadLunarCNMods();
        }
    }

    private static final void initGui$lambda$11(JList $jListLunarCN, GuiAddonManager this$0, ActionEvent it) {
        LunarCNMod currentMod = (LunarCNMod)$jListLunarCN.getSelectedValue();
        String name = currentMod.getFile().getName();
        Component component = this$0;
        String string = CelestialKt.getT().getString("gui.addon.mods.cn.remove.confirm.message");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        String string2 = string;
        Object[] objectArray = new Object[]{name};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
        if (JOptionPane.showConfirmDialog(component, string3, CelestialKt.getT().getString("gui.addon.mods.cn.remove.confirm.title"), 2) == 0 && currentMod.getFile().delete()) {
            Object[] objectArray2 = new Object[]{name};
            StatusBarKt.updateStatusText(TextUtilsKt.format(CelestialKt.getT(), "gui.addon.mods.cn.remove.success", objectArray2));
            this$0.lunarcnList.clear();
            this$0.loadLunarCNMods();
        }
    }

    private static final void initGui$lambda$12(JList $jListFabric, GuiAddonManager this$0, ActionEvent it) {
        FabricMod currentMod = (FabricMod)$jListFabric.getSelectedValue();
        File file = currentMod.getFile();
        String name = file.getName();
        Component component = this$0;
        String string = CelestialKt.getT().getString("gui.addon.rename.dialog.message");
        Intrinsics.checkNotNull(name);
        String string2 = name.substring(0, name.length() - 4);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        String newName = JOptionPane.showInputDialog(component, string, string2);
        if (newName != null && file.renameTo(new File(file.getParentFile(), newName + ".jar"))) {
            Logger logger = this$0.log;
            String string3 = "Rename Fabric mod %s -> %s";
            Object[] objectArray = new Object[]{name, newName + ".jar"};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string4, "format(...)");
            logger.info(string4);
            String string5 = CelestialKt.getT().getString("gui.addon.rename.success");
            Intrinsics.checkNotNullExpressionValue(string5, "getString(...)");
            string3 = string5;
            objectArray = new Object[]{newName};
            String string6 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string6, "format(...)");
            StatusBarKt.updateStatusText(string6);
            this$0.fabricList.clear();
            this$0.loadFabricMods();
        }
    }

    private static final void initGui$lambda$13(JList $jListFabric, GuiAddonManager this$0, ActionEvent it) {
        FabricMod currentMod = (FabricMod)$jListFabric.getSelectedValue();
        String name = currentMod.getFile().getName();
        Object[] objectArray = new Object[]{name};
        if (JOptionPane.showConfirmDialog(this$0, TextUtilsKt.format(CelestialKt.getT(), "gui.addon.mods.fabric.remove.confirm.message", objectArray), CelestialKt.getT().getString("gui.addon.mods.fabric.remove.confirm.title"), 2) == 0 && currentMod.getFile().delete()) {
            objectArray = new Object[]{name};
            StatusBarKt.updateStatusText(TextUtilsKt.format(CelestialKt.getT(), "gui.addon.mods.fabric.remove.success", objectArray));
            this$0.fabricList.clear();
            this$0.loadFabricMods();
        }
    }

    private static final void initGui$lambda$14(GuiAddonManager this$0, ActionEvent it) {
        String[] stringArray = new String[]{"jar"};
        File file = GuiUtilsKt.chooseFile(new FileNameExtensionFilter("Agent", stringArray));
        if (file == null) {
            this$0.log.info("Cancel add agent because file == null");
            return;
        }
        String arg = JOptionPane.showInputDialog(this$0, (Object)CelestialKt.getT().getString("gui.addon.agents.add.arg"));
        try {
            JavaAgent agent = JavaAgent.Companion.add(file, arg);
            if (agent != null) {
                new AddonAddEvent(AddonType.JAVAAGENT, agent);
                String string = CelestialKt.getT().getString("gui.addon.agents.add.success");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                StatusBarKt.updateStatusText(string);
                this$0.agentList.clear();
                this$0.loadAgents();
            } else {
                JOptionPane.showMessageDialog(this$0, CelestialKt.getT().getString("gui.addon.agents.add.failure.exists"), "Error", 0);
            }
        }
        catch (IOException e) {
            String trace = ExceptionsKt.stackTraceToString(e);
            this$0.log.error(trace);
            Object[] objectArray = new Object[]{trace};
            JOptionPane.showMessageDialog(this$0, TextUtilsKt.format(CelestialKt.getT(), "gui.addon.agents.add.failure.io", objectArray), "Error", 0);
        }
    }

    private static final void initGui$lambda$15(GuiAddonManager this$0, ActionEvent it) {
        String[] stringArray = new String[]{"jar"};
        File file = GuiUtilsKt.chooseFile(new FileNameExtensionFilter("Weave Mod", stringArray));
        if (file == null) {
            return;
        }
        File file2 = file;
        try {
            WeaveMod mod;
            if (!FileUtilsKt.isMod(FileUtilsKt.openAsJar(file2), AddonType.WEAVE)) {
                Object[] objectArray = new Object[]{file2};
                JOptionPane.showMessageDialog(this$0, TextUtilsKt.format(CelestialKt.getT(), "gui.addon.mods.incorrect", objectArray), "Warning | Type incorrect", 2);
            }
            if ((mod = WeaveMod.Companion.add(file2)) != null) {
                new AddonAddEvent(AddonType.WEAVE, mod);
                String string = CelestialKt.getT().getString("gui.addon.mods.weave.add.success");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                StatusBarKt.updateStatusText(string);
                this$0.weaveList.clear();
                this$0.loadWeaveMods();
            } else {
                JOptionPane.showMessageDialog(this$0, CelestialKt.getT().getString("gui.addon.mods.weave.add.failure.exists"), "Error", 0);
            }
        }
        catch (IOException e) {
            String trace = ExceptionsKt.stackTraceToString(e);
            this$0.log.error(trace);
            Object[] objectArray = new Object[]{trace};
            JOptionPane.showMessageDialog(this$0, TextUtilsKt.format(CelestialKt.getT(), "gui.addon.mods.weave.add.failure.io", objectArray), "Error", 0);
        }
    }

    private static final void initGui$lambda$16(GuiAddonManager this$0, ActionEvent it) {
        String[] stringArray = new String[]{"jar"};
        File file = GuiUtilsKt.chooseFile(new FileNameExtensionFilter("LunarCN Mod", stringArray));
        if (file == null) {
            return;
        }
        File file2 = file;
        try {
            LunarCNMod mod;
            if (!FileUtilsKt.isMod(FileUtilsKt.openAsJar(file2), AddonType.LUNARCN)) {
                Object[] objectArray = new Object[]{file2};
                JOptionPane.showMessageDialog(this$0, TextUtilsKt.format(CelestialKt.getT(), "gui.addon.mods.incorrect", objectArray), "Warning | Type incorrect", 2);
            }
            if ((mod = LunarCNMod.Companion.add(file2)) != null) {
                new AddonAddEvent(AddonType.LUNARCN, mod);
                String string = CelestialKt.getT().getString("gui.addon.mods.cn.add.success");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                StatusBarKt.updateStatusText(string);
                this$0.weaveList.clear();
                this$0.loadWeaveMods();
            } else {
                JOptionPane.showMessageDialog(this$0, CelestialKt.getT().getString("gui.addon.mods.cn.add.failure.exists"), "Error", 0);
            }
        }
        catch (IOException e) {
            String trace = ExceptionsKt.stackTraceToString(e);
            this$0.log.error(trace);
            Object[] objectArray = new Object[]{trace};
            JOptionPane.showMessageDialog(this$0, TextUtilsKt.format(CelestialKt.getT(), "gui.addon.mods.cn.add.failure.io", objectArray), "Error", 0);
        }
    }

    private static final void initGui$lambda$17(GuiAddonManager this$0, ActionEvent it) {
        String[] stringArray = new String[]{"jar"};
        File file = GuiUtilsKt.chooseFile(new FileNameExtensionFilter("Fabric Mod", stringArray));
        if (file == null) {
            this$0.log.info("Cancel add fabric mod because file == null");
            return;
        }
        try {
            FabricMod mod = FabricMod.Companion.add(file);
            if (mod != null) {
                new AddonAddEvent(AddonType.FABRIC, mod);
                String string = CelestialKt.getT().getString("gui.addon.mods.fabric.add.success");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                StatusBarKt.updateStatusText(string);
                this$0.fabricList.clear();
                this$0.loadFabricMods();
            } else {
                JOptionPane.showMessageDialog(this$0, CelestialKt.getT().getString("gui.addon.mods.fabric.add.failure.exists"), "Error", 0);
            }
        }
        catch (IOException e) {
            String trace = ExceptionsKt.stackTraceToString(e);
            this$0.log.error(trace);
            Object[] objectArray = new Object[]{trace};
            JOptionPane.showMessageDialog(this$0, TextUtilsKt.format(CelestialKt.getT(), "gui.addon.mods.fabric.add.failure.io", objectArray), "Error", 0);
        }
    }

    private static final void initGui$lambda$19(JPanel $panelCelePatch, ActionEvent it) {
        block0: {
            String[] stringArray = new String[]{"jar"};
            File file = GuiUtilsKt.chooseFile(new FileNameExtensionFilter("Celestial Patch", stringArray));
            if (file == null) break block0;
            File it2 = file;
            boolean bl = false;
            new PatchDialog($panelCelePatch, it2).setVisible(true);
        }
    }

    private static final void initGui$lambda$20(GuiAddonManager this$0, ChangeEvent it) {
        Component component = this$0.tab.getSelectedComponent();
        Intrinsics.checkNotNull(component, "null cannot be cast to non-null type javax.swing.JPanel");
        this$0.autoRefresh((JPanel)component);
    }

    public static final /* synthetic */ JMenuItem access$getToggleWeave$p(GuiAddonManager $this) {
        return $this.toggleWeave;
    }

    public static final /* synthetic */ JMenuItem access$getToggleAgent$p(GuiAddonManager $this) {
        return $this.toggleAgent;
    }

    public static final /* synthetic */ JMenuItem access$getToggleCN$p(GuiAddonManager $this) {
        return $this.toggleCN;
    }

    public static final /* synthetic */ JMenuItem access$getToggleAgentClasspath$p(GuiAddonManager $this) {
        return $this.toggleAgentClasspath;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lorg/cubewhy/celestial/gui/elements/GuiAddonManager$PatchTransferHandler;", "Ljavax/swing/TransferHandler;", "<init>", "()V", "canImport", "", "support", "Ljavax/swing/TransferHandler$TransferSupport;", "importData", "Companion", "celestial"})
    private static final class PatchTransferHandler
    extends TransferHandler {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private static Logger log = LoggerFactory.getLogger(PatchTransferHandler.class);

        @Override
        public boolean canImport(@NotNull TransferHandler.TransferSupport support) {
            Intrinsics.checkNotNullParameter(support, "support");
            return support.isDataFlavorSupported(DataFlavor.stringFlavor);
        }

        @Override
        public boolean importData(@NotNull TransferHandler.TransferSupport support) {
            Intrinsics.checkNotNullParameter(support, "support");
            if (!this.canImport(support)) {
                return false;
            }
            Object object = support.getTransferable().getTransferData(DataFlavor.stringFlavor);
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.String");
            String data = (String)object;
            File patch = new File(URI.create(data));
            log.info("Dragged patch: " + patch);
            if (!patch.exists()) {
                return false;
            }
            Component component = support.getComponent();
            Intrinsics.checkNotNull(component, "null cannot be cast to non-null type javax.swing.JPanel");
            JPanel panel = (JPanel)component;
            SwingUtilities.invokeLater(() -> PatchTransferHandler.importData$lambda$0(panel, patch));
            return true;
        }

        private static final void importData$lambda$0(JPanel $panel, File $patch) {
            new PatchDialog($panel, $patch).setVisible(true);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/cubewhy/celestial/gui/elements/GuiAddonManager$PatchTransferHandler$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "celestial"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

