/*
 * Decompiled with CFR 0.152.
 */
package org.cubewhy.celestial.gui.dialogs;

import cn.hutool.core.util.NumberUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.cubewhy.celestial.CelestialKt;
import org.cubewhy.celestial.gui.elements.StatusBarKt;
import org.cubewhy.celestial.utils.GuiUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u0007H\u0002J$\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0010j\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t`\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/cubewhy/celestial/gui/dialogs/MirrorDialog;", "Ljavax/swing/JDialog;", "<init>", "()V", "input", "Ljavax/swing/JTextArea;", "initGui", "", "header", "", "getHeader", "()Ljava/lang/String;", "checkSyntax", "", "loadFromJson", "asMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "Companion", "celestial"})
@SourceDebugExtension(value={"SMAP\nMirrorDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MirrorDialog.kt\norg/cubewhy/celestial/gui/dialogs/MirrorDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,142:1\n739#2,9:143\n739#2,9:156\n739#2,9:169\n739#2,9:182\n739#2,9:195\n739#2,9:208\n37#3:152\n36#3,3:153\n37#3:165\n36#3,3:166\n37#3:178\n36#3,3:179\n37#3:191\n36#3,3:192\n37#3:204\n36#3,3:205\n37#3:217\n36#3,3:218\n*S KotlinDebug\n*F\n+ 1 MirrorDialog.kt\norg/cubewhy/celestial/gui/dialogs/MirrorDialog\n*L\n85#1:143,9\n95#1:156,9\n99#1:169,9\n105#1:182,9\n126#1:195,9\n130#1:208,9\n86#1:152\n86#1:153,3\n95#1:165\n95#1:166,3\n99#1:178\n99#1:179,3\n105#1:191\n105#1:192,3\n126#1:204\n126#1:205,3\n130#1:217\n130#1:218,3\n*E\n"})
public final class MirrorDialog
extends JDialog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private JTextArea input;
    @NotNull
    private static final Logger log;

    public MirrorDialog() {
        this.setTitle(CelestialKt.getT().getString("gui.mirror.title"));
        this.setSize(600, 600);
        this.setLayout(new BorderLayout());
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setLocationByPlatform(true);
        this.initGui();
    }

    private final void initGui() {
        this.input = new JTextArea(this.getHeader());
        JTextArea jTextArea = this.input;
        if (jTextArea == null) {
            Intrinsics.throwUninitializedPropertyAccessException("input");
            jTextArea = null;
        }
        this.add(GuiUtilsKt.withScroller$default(jTextArea, 0, 0, 3, null));
        JButton btnCheckSyntax = new JButton(CelestialKt.getT().getString("gui.mirror.syntax"));
        btnCheckSyntax.addActionListener(arg_0 -> MirrorDialog.initGui$lambda$0(this, arg_0));
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(1, 1));
        buttons.add(btnCheckSyntax);
        this.add((Component)buttons, "South");
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ MirrorDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public void windowClosing(WindowEvent e) {
                Intrinsics.checkNotNullParameter(e, "e");
                if (!MirrorDialog.access$checkSyntax(this.this$0)) {
                    this.this$0.dispose();
                    return;
                }
                HashMap json = MirrorDialog.access$asMap(this.this$0);
                CelestialKt.getConfig().getProxy().applyMirrors(json);
                String string = CelestialKt.getT().getString("giu.mirror.success");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                StatusBarKt.updateStatusText(string);
                this.this$0.dispose();
            }
        });
        this.loadFromJson();
    }

    private final String getHeader() {
        List list;
        String string = CelestialKt.getT().getString("gui.mirror.header");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        CharSequence charSequence = string;
        Regex regex = new Regex("\n");
        int n = 0;
        List<String> $this$dropLastWhile$iv = regex.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator<String> iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] lines = thisCollection$iv.toArray(new String[0]);
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append("# ").append(line).append("\n");
        }
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkSyntax() {
        List list;
        JTextArea jTextArea = this.input;
        if (jTextArea == null) {
            Intrinsics.throwUninitializedPropertyAccessException("input");
            jTextArea = null;
        }
        String string = jTextArea.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        CharSequence charSequence = string;
        Regex regex = new Regex("\n");
        int n = 0;
        List<String> $this$dropLastWhile$iv = regex.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator<String> iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        for (String s : thisCollection$iv.toArray(new String[0])) {
            void $this$toTypedArray$iv2;
            List list2;
            Collection $this$dropLastWhile$iv2;
            if (StringsKt.startsWith$default(s, "#", false, 2, null)) continue;
            Object bl = s;
            Regex regex2 = new Regex(" ");
            int n2 = 0;
            bl = regex2.split((CharSequence)bl, n2);
            boolean $i$f$dropLastWhile2 = false;
            if (!$this$dropLastWhile$iv2.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv2.listIterator($this$dropLastWhile$iv2.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl2 = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list2 = CollectionsKt.take($this$dropLastWhile$iv2, iterator$iv.nextIndex() + 1);
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv2 = list2;
            boolean $i$f$toTypedArray2 = false;
            void thisCollection$iv2 = $this$toTypedArray$iv2;
            String[] addresses = thisCollection$iv2.toArray(new String[0]);
            if (addresses.length != 2) {
                return false;
            }
            for (String address : addresses) {
                void $this$toTypedArray$iv3;
                List list3;
                Collection $this$dropLastWhile$iv3;
                Object bl2 = address;
                Regex regex3 = new Regex(":");
                int n3 = 0;
                bl2 = regex3.split((CharSequence)bl2, n3);
                boolean $i$f$dropLastWhile3 = false;
                if (!$this$dropLastWhile$iv3.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv3.listIterator($this$dropLastWhile$iv3.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl3 = false;
                        if (((CharSequence)it).length() == 0) continue;
                        list3 = CollectionsKt.take($this$dropLastWhile$iv3, iterator$iv.nextIndex() + 1);
                        break;
                    }
                } else {
                    list3 = CollectionsKt.emptyList();
                }
                $this$dropLastWhile$iv3 = list3;
                boolean $i$f$toTypedArray3 = false;
                void thisCollection$iv3 = $this$toTypedArray$iv3;
                String[] split = thisCollection$iv3.toArray(new String[0]);
                if (split.length != 2) {
                    return false;
                }
                String port = split[1];
                if (NumberUtil.isNumber(port)) continue;
                return false;
            }
        }
        return true;
    }

    private final void loadFromJson() {
        for (Map.Entry entry : ((Map)CelestialKt.getConfig().getProxy().getMirror()).entrySet()) {
            String source2 = (String)entry.getKey();
            String mirror = (String)entry.getValue();
            JTextArea jTextArea = this.input;
            if (jTextArea == null) {
                Intrinsics.throwUninitializedPropertyAccessException("input");
                jTextArea = null;
            }
            String string = "%s %s\n";
            Object[] objectArray = new Object[]{source2, mirror};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            jTextArea.append(string2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final HashMap<String, String> asMap() {
        List list;
        HashMap<String, String> json = new HashMap<String, String>();
        JTextArea jTextArea = this.input;
        if (jTextArea == null) {
            Intrinsics.throwUninitializedPropertyAccessException("input");
            jTextArea = null;
        }
        String string = jTextArea.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        CharSequence charSequence = string;
        Regex regex = new Regex("\n");
        int n = 0;
        List<String> $this$dropLastWhile$iv = regex.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator<String> iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        for (String s : thisCollection$iv.toArray(new String[0])) {
            void $this$toTypedArray$iv2;
            List list2;
            Collection $this$dropLastWhile$iv2;
            if (StringsKt.startsWith$default(s, "#", false, 2, null)) continue;
            Object bl = s;
            Regex regex2 = new Regex(" ");
            int n2 = 0;
            bl = regex2.split((CharSequence)bl, n2);
            boolean $i$f$dropLastWhile2 = false;
            if (!$this$dropLastWhile$iv2.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv2.listIterator($this$dropLastWhile$iv2.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl2 = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list2 = CollectionsKt.take($this$dropLastWhile$iv2, iterator$iv.nextIndex() + 1);
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv2 = list2;
            boolean $i$f$toTypedArray2 = false;
            void thisCollection$iv2 = $this$toTypedArray$iv2;
            String[] split = thisCollection$iv2.toArray(new String[0]);
            String source2 = split[0];
            String mirror = split[1];
            ((Map)json).put(source2, mirror);
        }
        return json;
    }

    private static final void initGui$lambda$0(MirrorDialog this$0, ActionEvent it) {
        log.info("Check syntax");
        boolean status = this$0.checkSyntax();
        if (status) {
            JOptionPane.showMessageDialog(this$0, CelestialKt.getT().getString("gui.mirror.syntax.pass"), "Syntax check", 1);
        } else {
            JOptionPane.showMessageDialog(this$0, CelestialKt.getT().getString("gui.mirror.syntax.incorrect"), "Syntax check", 0);
        }
    }

    public static final /* synthetic */ boolean access$checkSyntax(MirrorDialog $this) {
        return $this.checkSyntax();
    }

    public static final /* synthetic */ HashMap access$asMap(MirrorDialog $this) {
        return $this.asMap();
    }

    static {
        Logger logger = LoggerFactory.getLogger(MirrorDialog.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        log = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/cubewhy/celestial/gui/dialogs/MirrorDialog$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "celestial"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

