/*
 * Decompiled with CFR 0.152.
 */
package org.cubewhy.celestial.gui;

import cn.hutool.crypto.SecureUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.cubewhy.celestial.CelestialKt;
import org.cubewhy.celestial.files.DownloadManager;
import org.cubewhy.celestial.gui.LauncherNewsKt;
import org.cubewhy.celestial.utils.GuiUtilsKt;
import org.cubewhy.celestial.utils.LinkUtilsKt;
import org.cubewhy.celestial.utils.lunar.Blogpost;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/cubewhy/celestial/gui/LauncherNews;", "Ljavax/swing/JPanel;", "blogPost", "Lorg/cubewhy/celestial/utils/lunar/Blogpost;", "<init>", "(Lorg/cubewhy/celestial/utils/lunar/Blogpost;)V", "image", "Ljava/io/File;", "initGui", "", "celestial"})
public final class LauncherNews
extends JPanel {
    @NotNull
    private final Blogpost blogPost;
    @NotNull
    private final File image;

    public LauncherNews(@NotNull Blogpost blogPost) {
        Intrinsics.checkNotNullParameter(blogPost, "blogPost");
        this.blogPost = blogPost;
        this.image = new File(DownloadManager.INSTANCE.getCacheDir(), "news/" + SecureUtil.sha1(this.blogPost.getTitle()));
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new TitledBorder(null, this.blogPost.getTitle(), 0, 0, null, Color.orange));
        this.initGui();
    }

    private final void initGui() {
        String string;
        boolean isMoonsworth = this.blogPost.getExcerpt() == null;
        JLabel textLabel = isMoonsworth ? GuiUtilsKt.toJLabel(this.blogPost.getTitle()) : GuiUtilsKt.toJLabel(this.blogPost.getExcerpt() + " - " + this.blogPost.getAuthor());
        this.add(textLabel);
        ImageIcon image = new ImageIcon(this.image.getPath());
        JLabel imageLabel = new JLabel(new ImageIcon(image.getImage().getScaledInstance(400, 200, 1)), 0);
        this.add(imageLabel);
        if (isMoonsworth) {
            string = "View";
        } else {
            string = this.blogPost.getButtonText();
            if (string == null) {
                string = "View";
            }
        }
        String text = string;
        JButton button = new JButton(text);
        button.addActionListener(arg_0 -> LauncherNews.initGui$lambda$0(this, arg_0));
        this.add(button);
        textLabel.setLabelFor(imageLabel);
    }

    private static final void initGui$lambda$0(LauncherNews this$0, ActionEvent it) {
        Blogpost.ButtonType buttonType = this$0.blogPost.getType();
        switch (buttonType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[buttonType.ordinal()]) {
            case 1: {
                LinkUtilsKt.open(LinkUtilsKt.toURI(this$0.blogPost.getLink()));
                break;
            }
            case 2: {
                Component component = this$0;
                String string = CelestialKt.getT().getString("gui.news.api.confirm");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                String string2 = string;
                Object[] objectArray = new Object[]{this$0.blogPost.getLink()};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
                if (JOptionPane.showConfirmDialog(component, string3, "Confirm", 0) != 0) break;
                CelestialKt.getConfig().getApi().setAddress(this$0.blogPost.getLink());
                LauncherNewsKt.access$getLog$p().info("Change API into " + CelestialKt.getConfig().getApi());
                JOptionPane.showMessageDialog(this$0, CelestialKt.getT().getString("gui.news.api.reopen"), "Reopen needed", 1);
                break;
            }
            case -1: {
                JOptionPane.showMessageDialog(this$0, CelestialKt.getT().getString("gui.news.empty"), "A Joke", 1);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Blogpost.ButtonType.values().length];
            try {
                nArray[Blogpost.ButtonType.OPEN_LINK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Blogpost.ButtonType.CHANGE_API.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

