/*
 * Decompiled with CFR 0.152.
 */
package org.cubewhy.celestial.gui;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.cubewhy.celestial.CelestialKt;
import org.cubewhy.celestial.LauncherPage;
import org.cubewhy.celestial.event.EventManager;
import org.cubewhy.celestial.event.EventTarget;
import org.cubewhy.celestial.event.impl.AuthEvent;
import org.cubewhy.celestial.event.impl.GameStartEvent;
import org.cubewhy.celestial.event.impl.GameTerminateEvent;
import org.cubewhy.celestial.gui.dialogs.HelpDialog;
import org.cubewhy.celestial.gui.elements.StatusBar;
import org.cubewhy.celestial.utils.FileUtilsKt;
import org.cubewhy.celestial.utils.LinkUtilsKt;
import org.cubewhy.celestial.utils.SystemUtilsKt;
import org.cubewhy.celestial.utils.TextUtilsKt;
import org.cubewhy.celestial.utils.lunar.LunarApiClient;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0011H\u0002J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u001dH\u0007R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lorg/cubewhy/celestial/gui/LauncherMainWindow;", "Ljavax/swing/JFrame;", "<init>", "()V", "cardLayout", "Ljava/awt/CardLayout;", "getCardLayout", "()Ljava/awt/CardLayout;", "setCardLayout", "(Ljava/awt/CardLayout;)V", "mainPanel", "Ljavax/swing/JPanel;", "getMainPanel", "()Ljavax/swing/JPanel;", "setMainPanel", "(Ljavax/swing/JPanel;)V", "initGui", "", "findExistGame", "setIconImage", "name", "", "resetIcon", "onGameStart", "e", "Lorg/cubewhy/celestial/event/impl/GameStartEvent;", "onGameTerminate", "Lorg/cubewhy/celestial/event/impl/GameTerminateEvent;", "onAuth", "Lorg/cubewhy/celestial/event/impl/AuthEvent;", "Companion", "celestial"})
@SourceDebugExtension(value={"SMAP\nLauncherMainWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LauncherMainWindow.kt\norg/cubewhy/celestial/gui/LauncherMainWindow\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,201:1\n1869#2,2:202\n*S KotlinDebug\n*F\n+ 1 LauncherMainWindow.kt\norg/cubewhy/celestial/gui/LauncherMainWindow\n*L\n93#1:202,2\n*E\n"})
public final class LauncherMainWindow
extends JFrame {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public CardLayout cardLayout;
    public JPanel mainPanel;
    @NotNull
    private static final StatusBar statusBar = new StatusBar();
    @NotNull
    private static final Logger log;

    public LauncherMainWindow() {
        EventManager.INSTANCE.register(this);
        this.setBounds(100, 100, 1200, 700);
        this.setTitle(CelestialKt.getT().getString("gui.launcher.title"));
        this.resetIcon();
        this.initGui();
    }

    @NotNull
    public final CardLayout getCardLayout() {
        CardLayout cardLayout = this.cardLayout;
        if (cardLayout != null) {
            return cardLayout;
        }
        Intrinsics.throwUninitializedPropertyAccessException("cardLayout");
        return null;
    }

    public final void setCardLayout(@NotNull CardLayout cardLayout) {
        Intrinsics.checkNotNullParameter(cardLayout, "<set-?>");
        this.cardLayout = cardLayout;
    }

    @NotNull
    public final JPanel getMainPanel() {
        JPanel jPanel = this.mainPanel;
        if (jPanel != null) {
            return jPanel;
        }
        Intrinsics.throwUninitializedPropertyAccessException("mainPanel");
        return null;
    }

    public final void setMainPanel(@NotNull JPanel jPanel) {
        Intrinsics.checkNotNullParameter(jPanel, "<set-?>");
        this.mainPanel = jPanel;
    }

    private final void initGui() {
        this.add((Component)statusBar, "South");
        Panel menu = new Panel();
        JButton btnDonate = new JButton(CelestialKt.getT().getString("gui.donate"));
        JButton btnHelp = new JButton(CelestialKt.getT().getString("gui.help"));
        JButton btnDiscord = new JButton(CelestialKt.getT().getString("gui.discord"));
        btnDonate.addActionListener(LauncherMainWindow::initGui$lambda$0);
        btnHelp.addActionListener(LauncherMainWindow::initGui$lambda$1);
        btnDiscord.addActionListener(LauncherMainWindow::initGui$lambda$2);
        menu.setSize(100, 20);
        this.add((Component)menu, "North");
        this.setMainPanel(new JPanel());
        this.setCardLayout(new CardLayout());
        this.getMainPanel().setLayout(this.getCardLayout());
        Iterable $this$forEach$iv = CelestialKt.getConfig().getPages();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LauncherPage page = (LauncherPage)((Object)element$iv);
            boolean bl = false;
            this.getMainPanel().add(page.getPageName(), page.getClazz().getConstructor(new Class[0]).newInstance(new Object[0]));
            JButton navigateBtn = new JButton(CelestialKt.getT().getString(page.getTranslateKey()));
            menu.add(navigateBtn);
            navigateBtn.addActionListener(arg_0 -> LauncherMainWindow.initGui$lambda$4$lambda$3(this, page, arg_0));
        }
        menu.add(btnDonate);
        menu.add(btnHelp);
        menu.add(btnDiscord);
        this.add(this.getMainPanel());
        new Thread(() -> LauncherMainWindow.initGui$lambda$5(this)).start();
    }

    private final void findExistGame() {
        try {
            VirtualMachine java = SystemUtilsKt.findJava(LunarApiClient.Companion.getMainClass(null));
            if (java != null) {
                String pid = java.id();
                log.info("Exist game process found! Pid: " + pid);
                AtomicLong atomicLong = CelestialKt.getGamePid();
                Intrinsics.checkNotNull(pid);
                atomicLong.set(Long.parseLong(pid));
                new GameStartEvent(CelestialKt.getGamePid().get()).call();
                Object[] objectArray = new Object[]{pid};
                JOptionPane.showMessageDialog(this, TextUtilsKt.format(CelestialKt.getT(), "gui.launcher.game.exist.message", objectArray), CelestialKt.getT().getString("gui.launcher.game.exist.title"), 1);
                java.detach();
            }
        }
        catch (AttachNotSupportedException e) {
            log.error("Failed to find the game process, is launched with the official launcher? (attach not support)");
            log.error(ExceptionsKt.stackTraceToString(e));
        }
    }

    private final void setIconImage(String name) {
        InputStream inputStream2 = FileUtilsKt.getInputStream("/images/icons/" + name + ".png");
        Intrinsics.checkNotNull(inputStream2);
        this.setIconImage(new ImageIcon(inputStream2.readAllBytes()).getImage());
    }

    private final void resetIcon() {
        String string = CelestialKt.getConfig().getTheme();
        if (Intrinsics.areEqual(string, "light")) {
            this.setIconImage("icon-dark");
        } else if (Intrinsics.areEqual(string, "dark")) {
            this.setIconImage("icon-light");
        } else {
            this.setIconImage("icon-light");
        }
    }

    @EventTarget
    public final void onGameStart(@NotNull GameStartEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        this.setIconImage("running");
    }

    @EventTarget
    public final void onGameTerminate(@NotNull GameTerminateEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        this.resetIcon();
    }

    @EventTarget
    public final void onAuth(@NotNull AuthEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        log.info("Request for Minecraft login");
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(e.getAuthURL().toString()), null);
        String link = JOptionPane.showInputDialog(this, CelestialKt.getT().getString("gui.launcher.auth.message"), CelestialKt.getT().getString("gui.launcher.auth.title"), 3);
        e.put(link);
    }

    private static final void initGui$lambda$0(ActionEvent it) {
        try {
            URI uRI = URI.create("https://lunarclient.top/#/sponsor");
            Intrinsics.checkNotNullExpressionValue(uRI, "create(...)");
            LinkUtilsKt.open(uRI);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static final void initGui$lambda$1(ActionEvent it) {
        new HelpDialog().setVisible(true);
    }

    private static final void initGui$lambda$2(ActionEvent it) {
        try {
            Desktop.getDesktop().browse(new URI("https://discord.lunarclient.top"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static final void initGui$lambda$4$lambda$3(LauncherMainWindow this$0, LauncherPage $page, ActionEvent it) {
        this$0.getCardLayout().show(this$0.getMainPanel(), $page.getPageName());
    }

    private static final void initGui$lambda$5(LauncherMainWindow this$0) {
        try {
            this$0.findExistGame();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Logger logger = LoggerFactory.getLogger(LauncherMainWindow.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        log = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/cubewhy/celestial/gui/LauncherMainWindow$Companion;", "", "<init>", "()V", "statusBar", "Lorg/cubewhy/celestial/gui/elements/StatusBar;", "getStatusBar", "()Lorg/cubewhy/celestial/gui/elements/StatusBar;", "log", "Lorg/slf4j/Logger;", "celestial"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StatusBar getStatusBar() {
            return statusBar;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

