/*
 * Decompiled with CFR 0.152.
 */
package org.cubewhy.celestial.game;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessage;
import com.lunarclient.gameipc.auth.v1.OpenMicrosoftPopupResponse;
import com.lunarclient.gameipc.browser.v1.OpenUrlRequest;
import com.lunarclient.gameipc.promotion.v1.CheckPendingPromotionResponse;
import com.lunarclient.gameipc.protocol.v1.GameboundIPCMessage;
import com.lunarclient.gameipc.protocol.v1.IPCRpcResponse;
import com.lunarclient.gameipc.protocol.v1.LauncherboundIPCMessage;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.cubewhy.celestial.event.impl.AuthEvent;
import org.cubewhy.celestial.utils.LinkUtilsKt;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J,\u0010\f\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001c\u0010\u0011\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000eH\u0016J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\"\u0010\u0015\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u000e\u0010\n\u001a\n\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016J\u001e\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d\u00a8\u0006\u001f"}, d2={"Lorg/cubewhy/celestial/game/GameWebsocketServer;", "Lorg/java_websocket/server/WebSocketServer;", "serverPort", "", "<init>", "(I)V", "onOpen", "", "p0", "Lorg/java_websocket/WebSocket;", "p1", "Lorg/java_websocket/handshake/ClientHandshake;", "onClose", "p2", "", "p3", "", "onMessage", "conn", "message", "Ljava/nio/ByteBuffer;", "onError", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onStart", "responseIpcRpcResponse", "requestId", "Lcom/google/protobuf/ByteString;", "payload", "Lcom/google/protobuf/GeneratedMessage;", "Companion", "celestial"})
public final class GameWebsocketServer
extends WebSocketServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(GameWebsocketServer.class);

    public GameWebsocketServer(int serverPort) {
        super(new InetSocketAddress("127.0.0.1", serverPort));
    }

    public /* synthetic */ GameWebsocketServer(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 28190;
        }
        this(n);
    }

    @Override
    public void onOpen(@Nullable WebSocket p0, @Nullable ClientHandshake p1) {
        log.debug("Opened gameipc.");
    }

    @Override
    public void onClose(@Nullable WebSocket p0, int p1, @Nullable String p2, boolean p3) {
        log.debug("Closed gameipc.");
    }

    @Override
    public void onMessage(@Nullable WebSocket p0, @Nullable String p1) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onMessage(@NotNull WebSocket conn, @NotNull ByteBuffer message) {
        block14: {
            Intrinsics.checkNotNullParameter(conn, "conn");
            Intrinsics.checkNotNullParameter(message, "message");
            LauncherboundIPCMessage request = LauncherboundIPCMessage.parseFrom(message);
            log.info("Client send gameipc request " + request.getService() + ":" + request.getMethod());
            String string = request.getMethod();
            if (string == null) break block14;
            int n = -1;
            switch (string.hashCode()) {
                case 145332584: {
                    if (string.equals("OpenMicrosoftPopup")) {
                        n = 1;
                    }
                    break;
                }
                case 401449637: {
                    if (string.equals("OpenUrl")) {
                        n = 2;
                    }
                    break;
                }
                case 579392980: {
                    if (string.equals("CheckPendingPromotion")) {
                        n = 3;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    void $this$onMessage_u24lambda_u240;
                    OpenMicrosoftPopupResponse.Builder builder;
                    log.info("Client request login");
                    AuthEvent event = new AuthEvent(new URL("https://login.live.com/oauth20_authorize.srf?client_id=00000000402b5328&response_type=code&scope=service::user.auth.xboxlive.com::MBI_SSL&redirect_uri=https%3A%2F%2Flogin.live.com%2Foauth20_desktop.srf"));
                    if (event.call()) {
                        log.info("Login request canceled");
                        return;
                    }
                    String responseUrl = event.waitForAuth();
                    ByteString byteString = request.getRequestId();
                    Intrinsics.checkNotNullExpressionValue(byteString, "getRequestId(...)");
                    OpenMicrosoftPopupResponse.Builder builder2 = builder = OpenMicrosoftPopupResponse.newBuilder();
                    ByteString byteString2 = byteString;
                    WebSocket webSocket = conn;
                    GameWebsocketServer gameWebsocketServer = this;
                    boolean bl = false;
                    $this$onMessage_u24lambda_u240.setStatus(OpenMicrosoftPopupResponse.Status.STATUS_MATCHED_TARGET_URL);
                    $this$onMessage_u24lambda_u240.setUrl(responseUrl);
                    Unit unit = Unit.INSTANCE;
                    OpenMicrosoftPopupResponse openMicrosoftPopupResponse = builder.build();
                    Intrinsics.checkNotNullExpressionValue(openMicrosoftPopupResponse, "build(...)");
                    gameWebsocketServer.responseIpcRpcResponse(webSocket, byteString2, openMicrosoftPopupResponse);
                    break;
                }
                case 2: {
                    OpenUrlRequest openUrlRequest = OpenUrlRequest.parseFrom(request.getInput());
                    String url = openUrlRequest.getUrl();
                    log.info("Open URL: " + url);
                    Intrinsics.checkNotNull(url);
                    LinkUtilsKt.open(LinkUtilsKt.toURI(url));
                    break;
                }
                case 3: {
                    void $this$onMessage_u24lambda_u241;
                    CheckPendingPromotionResponse.Builder builder;
                    ByteString byteString = request.getRequestId();
                    Intrinsics.checkNotNullExpressionValue(byteString, "getRequestId(...)");
                    CheckPendingPromotionResponse.Builder builder3 = builder = CheckPendingPromotionResponse.newBuilder();
                    ByteString byteString3 = byteString;
                    WebSocket webSocket = conn;
                    GameWebsocketServer gameWebsocketServer = this;
                    boolean bl = false;
                    $this$onMessage_u24lambda_u241.setHasPendingPromotion(true);
                    $this$onMessage_u24lambda_u241.addPendingPromotions(721);
                    Unit unit = Unit.INSTANCE;
                    CheckPendingPromotionResponse checkPendingPromotionResponse = builder.build();
                    Intrinsics.checkNotNullExpressionValue(checkPendingPromotionResponse, "build(...)");
                    gameWebsocketServer.responseIpcRpcResponse(webSocket, byteString3, checkPendingPromotionResponse);
                }
            }
        }
    }

    @Override
    public void onError(@Nullable WebSocket p0, @Nullable Exception p1) {
        block0: {
            Exception exception = p1;
            if (exception == null) break block0;
            Exception it = exception;
            boolean bl = false;
            log.error(ExceptionsKt.stackTraceToString(it));
        }
    }

    @Override
    public void onStart() {
        log.info("Lunar auth server started at port " + this.getPort());
    }

    /*
     * WARNING - void declaration
     */
    public final void responseIpcRpcResponse(@NotNull WebSocket conn, @NotNull ByteString requestId, @NotNull GeneratedMessage payload) {
        void $this$responseIpcRpcResponse_u24lambda_u244_u24lambda_u243;
        void $this$responseIpcRpcResponse_u24lambda_u244;
        IPCRpcResponse.Builder builder;
        GameboundIPCMessage.Builder builder2;
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(requestId, "requestId");
        Intrinsics.checkNotNullParameter(payload, "payload");
        GameboundIPCMessage.Builder builder3 = builder2 = GameboundIPCMessage.newBuilder();
        WebSocket webSocket = conn;
        boolean bl = false;
        IPCRpcResponse.Builder builder4 = builder = IPCRpcResponse.newBuilder();
        void var9_10 = $this$responseIpcRpcResponse_u24lambda_u244;
        boolean bl2 = false;
        $this$responseIpcRpcResponse_u24lambda_u244_u24lambda_u243.setRequestId(requestId);
        $this$responseIpcRpcResponse_u24lambda_u244_u24lambda_u243.setOutput(payload.toByteString());
        var9_10.setRpcResponse(builder.build());
        webSocket.send(builder2.build().toByteArray());
    }

    public GameWebsocketServer() {
        this(0, 1, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/cubewhy/celestial/game/GameWebsocketServer$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "celestial"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

