/*
 * Decompiled with CFR 0.152.
 */
package co.gongzh.procbridge;

import co.gongzh.procbridge.ProtocolException;
import co.gongzh.procbridge.StatusCode;
import co.gongzh.procbridge.Versions;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00010\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u00072\u0006\u0010\n\u001a\u00020\u000bJ\"\u0010\u0014\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lco/gongzh/procbridge/Protocol;", "", "<init>", "()V", "FLAG", "", "read", "", "Lco/gongzh/procbridge/StatusCode;", "Lcom/google/gson/JsonObject;", "stream", "Ljava/io/InputStream;", "write", "", "Ljava/io/OutputStream;", "statusCode", "body", "readRequest", "", "readResponse", "writeRequest", "method", "payload", "writeGoodResponse", "writeBadResponse", "message", "celestial"})
@SourceDebugExtension(value={"SMAP\nProtocol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Protocol.kt\nco/gongzh/procbridge/Protocol\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n1#2:187\n*E\n"})
public final class Protocol {
    @NotNull
    public static final Protocol INSTANCE = new Protocol();
    @NotNull
    private static final byte[] FLAG;

    private Protocol() {
    }

    private final Map.Entry<StatusCode, JsonObject> read(InputStream stream) {
        int b = stream.read();
        if (b == -1 || b != FLAG[0]) {
            throw new ProtocolException("unrecognized protocol");
        }
        b = stream.read();
        if (b == -1 || b != FLAG[1]) {
            throw new ProtocolException("unrecognized protocol");
        }
        b = stream.read();
        if (b == -1) {
            throw new ProtocolException("incomplete data");
        }
        if (b != Versions.INSTANCE.getCURRENT()[0]) {
            throw new ProtocolException("incompatible protocol version");
        }
        b = stream.read();
        if (b == -1) {
            throw new ProtocolException("incomplete data");
        }
        if (b != Versions.INSTANCE.getCURRENT()[1]) {
            throw new ProtocolException("incompatible protocol version");
        }
        b = stream.read();
        if (b == -1) {
            throw new ProtocolException("incomplete data");
        }
        StatusCode statusCode = StatusCode.Companion.fromRawValue(b);
        if (statusCode == null) {
            throw new ProtocolException("invalid status code");
        }
        StatusCode statusCode2 = statusCode;
        b = stream.read();
        if (b == -1) {
            throw new ProtocolException("incomplete data");
        }
        b = stream.read();
        if (b == -1) {
            throw new ProtocolException("incomplete data");
        }
        b = stream.read();
        if (b == -1) {
            throw new ProtocolException("incomplete data");
        }
        int bodyLen = b;
        b = stream.read();
        if (b == -1) {
            throw new ProtocolException("incomplete data");
        }
        bodyLen |= b << 8;
        b = stream.read();
        if (b == -1) {
            throw new ProtocolException("incomplete data");
        }
        bodyLen |= b << 16;
        b = stream.read();
        if (b == -1) {
            throw new ProtocolException("incomplete data");
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        int readCount = 0;
        int restCount = bodyLen |= b << 24;
        byte[] buf = new byte[(int)Math.min((double)bodyLen, 1048576.0)];
        do {
            int n;
            int it = n = stream.read(buf, 0, (int)Math.min((double)buf.length, (double)restCount));
            boolean bl = false;
            readCount = it;
            if (n == -1) break;
            buffer.write(buf, 0, readCount);
        } while ((restCount -= readCount) != 0);
        if (buffer.size() != bodyLen) {
            throw new ProtocolException("incomplete data");
        }
        buffer.flush();
        byte[] byArray = buffer.toByteArray();
        Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
        buf = byArray;
        try {
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
            Charset it = charset;
            String jsonText = new String(buf, it);
            JsonObject body = JsonParser.parseString(jsonText).getAsJsonObject();
            return new AbstractMap.SimpleEntry<StatusCode, JsonObject>(statusCode2, body);
        }
        catch (Exception ex) {
            throw new ProtocolException("invalid body");
        }
    }

    private final void write(OutputStream stream, StatusCode statusCode, JsonObject body) {
        stream.write(FLAG);
        stream.write(Versions.INSTANCE.getCURRENT());
        stream.write(statusCode.getRawValue());
        stream.write(0);
        stream.write(0);
        String string = body.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String string2 = string;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        byte[] buf = byArray;
        int len = buf.length;
        int b0 = len & 0xFF;
        int b1 = (len & 0xFF00) >> 8;
        int b2 = (len & 0xFF0000) >> 16;
        int b3 = (len & 0xFF000000) >> 24;
        stream.write(b0);
        stream.write(b1);
        stream.write(b2);
        stream.write(b3);
        stream.write(buf);
        stream.flush();
    }

    @NotNull
    public final Map.Entry<String, Object> readRequest(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Map.Entry<StatusCode, JsonObject> entry = this.read(stream);
        StatusCode statusCode = entry.getKey();
        JsonObject body = entry.getValue();
        if (statusCode != StatusCode.REQUEST) {
            throw new ProtocolException("invalid status code");
        }
        String method = body.get("method").getAsString();
        JsonElement jsonElement = body.get("payload");
        Intrinsics.checkNotNullExpressionValue(jsonElement, "get(...)");
        JsonElement payload = jsonElement;
        return new AbstractMap.SimpleEntry<String, JsonElement>(method, payload);
    }

    @NotNull
    public final Map.Entry<StatusCode, Object> readResponse(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Map.Entry<StatusCode, JsonObject> entry = this.read(stream);
        StatusCode statusCode = entry.getKey();
        JsonObject body = entry.getValue();
        return switch (WhenMappings.$EnumSwitchMapping$0[statusCode.ordinal()]) {
            case 1 -> new AbstractMap.SimpleEntry<StatusCode, JsonElement>(StatusCode.GOOD_RESPONSE, body.get("payload"));
            case 2 -> new AbstractMap.SimpleEntry<StatusCode, String>(StatusCode.BAD_RESPONSE, body.get("message").getAsString());
            default -> throw new ProtocolException("invalid status code");
        };
    }

    public final void writeRequest(@NotNull OutputStream stream, @Nullable String method, @Nullable Object payload) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        JsonObject body = new JsonObject();
        if (method != null) {
            body.addProperty("method", method);
        }
        if (payload != null) {
            body.addProperty("payload", (String)payload);
        }
        this.write(stream, StatusCode.REQUEST, body);
    }

    public final void writeGoodResponse(@NotNull OutputStream stream, @Nullable Object payload) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        JsonObject body = new JsonObject();
        if (payload != null) {
            body.add("payload", new Gson().toJsonTree(payload, (Type)((Object)Map.class)));
        }
        this.write(stream, StatusCode.GOOD_RESPONSE, body);
    }

    public final void writeBadResponse(@NotNull OutputStream stream, @Nullable String message) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        JsonObject body = new JsonObject();
        if (message != null) {
            body.addProperty("message", message);
        }
        this.write(stream, StatusCode.BAD_RESPONSE, body);
    }

    static {
        byte[] byArray = new byte[]{112, 98};
        FLAG = byArray;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StatusCode.values().length];
            try {
                nArray[StatusCode.GOOD_RESPONSE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StatusCode.BAD_RESPONSE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

