/*
 * Decompiled with CFR 0.152.
 */
package org.cubewhy.celestial.utils;

import com.sun.management.OperatingSystemMXBean;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.cubewhy.celestial.gui.Language;
import org.cubewhy.celestial.utils.OSEnum;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0006\u0010\u000f\u001a\u00020\u0010\"\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"findJava", "Lcom/sun/tools/attach/VirtualMachine;", "mainClass", "", "currentJavaExec", "Ljava/io/File;", "getCurrentJavaExec", "()Ljava/io/File;", "totalMem", "", "getTotalMem", "()I", "arch", "getArch", "()Ljava/lang/String;", "getLanguage", "Lorg/cubewhy/celestial/gui/Language;", "celestial"})
public final class SystemUtilsKt {
    @NotNull
    private static final String arch;

    @Nullable
    public static final VirtualMachine findJava(@Nullable String mainClass) {
        for (VirtualMachineDescriptor descriptor : VirtualMachine.list()) {
            String string = descriptor.displayName();
            Intrinsics.checkNotNullExpressionValue(string, "displayName(...)");
            String string2 = mainClass;
            Intrinsics.checkNotNull(string2);
            if (!StringsKt.startsWith$default(string, string2, false, 2, null)) continue;
            return descriptor.provider().attachVirtualMachine(descriptor);
        }
        return null;
    }

    @NotNull
    public static final File getCurrentJavaExec() {
        String exec = System.getProperty("java.home") + "/bin/java";
        if (OSEnum.Windows.isCurrent()) {
            exec = exec + ".exe";
        }
        return new File(exec);
    }

    public static final int getTotalMem() {
        java.lang.management.OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        Intrinsics.checkNotNull(operatingSystemMXBean, "null cannot be cast to non-null type com.sun.management.OperatingSystemMXBean");
        OperatingSystemMXBean osBean = (OperatingSystemMXBean)operatingSystemMXBean;
        return (int)(osBean.getTotalMemorySize() / (long)0x100000);
    }

    @NotNull
    public static final String getArch() {
        return arch;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Language getLanguage() {
        Language language;
        Locale locale = Locale.getDefault();
        String string = locale.getLanguage();
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 3428: {
                    if (!string.equals("ko")) break;
                    n = 1;
                    break;
                }
                case 3383: {
                    if (!string.equals("ja")) break;
                    n = 2;
                    break;
                }
                case 3241: {
                    if (!string.equals("en")) break;
                    n = 3;
                    break;
                }
                case 3886: {
                    if (!string.equals("zh")) break;
                    n = 4;
                    break;
                }
                case 3246: {
                    if (!string.equals("es")) break;
                    n = 5;
                    break;
                }
            }
            switch (n) {
                case 3: {
                    language = Language.ENGLISH;
                    return language;
                }
                case 4: {
                    language = Language.CHINESE;
                    return language;
                }
                case 2: {
                    language = Language.JAPANESE;
                    return language;
                }
                case 1: {
                    language = Language.KOREAN;
                    return language;
                }
                case 5: {
                    language = Language.SPANISH;
                    return language;
                }
            }
        }
        language = Language.ENGLISH;
        return language;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block11: {
            block9: {
                block10: {
                    var0 = System.getProperty("os.arch", "unknown");
                    if (var0 == null) break block9;
                    switch (var0.hashCode()) {
                        case -1221096139: {
                            if (var0.equals("aarch64")) break;
                            ** break;
                        }
                        case -806050265: {
                            if (!var0.equals("x86_64")) {
                                ** break;
                            }
                            ** GOTO lbl20
                        }
                        case 93084186: {
                            if (var0.equals("arm64")) break;
                            ** break;
                        }
                        case 96860: {
                            if (!var0.equals("arm")) {
                                ** break;
                            }
                            break block10;
                        }
                        case 92926582: {
                            if (!var0.equals("amd64")) ** break;
lbl20:
                            // 2 sources

                            v0 = "x64";
                            break block11;
                        }
                    }
                    v0 = "arm64";
                    break block11;
                }
                v0 = "arm";
                break block11;
            }
            throw new IllegalStateException("Unsupported CPU Arch: " + System.getProperty("os.arch"));
        }
        SystemUtilsKt.arch = v0;
    }
}

