/*
 * Decompiled with CFR 0.152.
 */
package org.cubewhy.celestial.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0013\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000bR\u0011\u0010\u0015\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000bR\u0011\u0010\u0017\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000bR\u0011\u0010\u0019\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lorg/cubewhy/celestial/utils/GitUtils;", "", "<init>", "()V", "info", "Ljava/util/Properties;", "getInfo", "()Ljava/util/Properties;", "buildVersion", "", "getBuildVersion", "()Ljava/lang/String;", "branch", "getBranch", "remote", "getRemote", "getCommitId", "shortID", "", "buildUser", "getBuildUser", "buildUserEmail", "getBuildUserEmail", "commitMessage", "getCommitMessage", "commitTime", "getCommitTime", "celestial"})
public final class GitUtils {
    @NotNull
    public static final GitUtils INSTANCE = new GitUtils();
    @NotNull
    private static final Properties info = new Properties();

    private GitUtils() {
    }

    @NotNull
    public final Properties getInfo() {
        return info;
    }

    @NotNull
    public final String getBuildVersion() {
        String string = info.getProperty("git.build.version");
        Intrinsics.checkNotNullExpressionValue(string, "getProperty(...)");
        return string;
    }

    @NotNull
    public final String getBranch() {
        String string = info.getProperty("git.branch");
        Intrinsics.checkNotNullExpressionValue(string, "getProperty(...)");
        return string;
    }

    @NotNull
    public final String getRemote() {
        String string = info.getProperty("git.remote.origin.url");
        Intrinsics.checkNotNullExpressionValue(string, "getProperty(...)");
        return string;
    }

    @NotNull
    public final String getCommitId(boolean shortID) {
        String string;
        if (shortID) {
            String string2 = info.getProperty("git.commit.id.abbrev");
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "getProperty(...)");
        } else {
            String string3 = info.getProperty("git.commit.id");
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "getProperty(...)");
        }
        return string;
    }

    @NotNull
    public final String getBuildUser() {
        String string = info.getProperty("git.build.user.name");
        Intrinsics.checkNotNullExpressionValue(string, "getProperty(...)");
        return string;
    }

    @NotNull
    public final String getBuildUserEmail() {
        String string = info.getProperty("git.build.user.email");
        Intrinsics.checkNotNullExpressionValue(string, "getProperty(...)");
        return string;
    }

    @NotNull
    public final String getCommitMessage() {
        String string = info.getProperty("git.commit.message.full");
        Intrinsics.checkNotNullExpressionValue(string, "getProperty(...)");
        return string;
    }

    @NotNull
    public final String getCommitTime() {
        String string = info.getProperty("git.commit.time");
        Intrinsics.checkNotNullExpressionValue(string, "getProperty(...)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            Closeable closeable = GitUtils.class.getClassLoader().getResourceAsStream("git.properties");
            Throwable throwable = null;
            try {
                InputStream inputStream2 = (InputStream)closeable;
                boolean bl = false;
                if (inputStream2 != null) {
                    info.load(inputStream2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

