/*
 * Decompiled with CFR 0.152.
 */
package org.cubewhy.celestial.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.cubewhy.celestial.game.AddonType;
import org.cubewhy.celestial.gui.LauncherMainWindow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0001\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0001\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0001\u001a\u0012\u0010\f\u001a\u00020\r*\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f\u001a\n\u0010\u0010\u001a\u00020\r*\u00020\u0001\u001a\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"toFile", "Ljava/io/File;", "", "getInputStream", "Ljava/io/InputStream;", "openAsJar", "Ljava/util/jar/JarFile;", "openAsZip", "Ljava/util/zip/ZipFile;", "unzipTo", "", "targetDir", "isMod", "", "type", "Lorg/cubewhy/celestial/game/AddonType;", "isZipFile", "isZipSignature", "header", "", "celestial"})
public final class FileUtilsKt {
    @NotNull
    public static final File toFile(@NotNull String $this$toFile) {
        Intrinsics.checkNotNullParameter($this$toFile, "<this>");
        return new File($this$toFile);
    }

    @Nullable
    public static final InputStream getInputStream(@NotNull String $this$getInputStream) {
        Intrinsics.checkNotNullParameter($this$getInputStream, "<this>");
        return LauncherMainWindow.class.getResourceAsStream($this$getInputStream);
    }

    @NotNull
    public static final JarFile openAsJar(@NotNull File $this$openAsJar) {
        Intrinsics.checkNotNullParameter($this$openAsJar, "<this>");
        return new JarFile($this$openAsJar);
    }

    @NotNull
    public static final ZipFile openAsZip(@NotNull File $this$openAsZip) {
        Intrinsics.checkNotNullParameter($this$openAsZip, "<this>");
        return new ZipFile($this$openAsZip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void unzipTo(@NotNull ZipFile $this$unzipTo, @NotNull File targetDir) {
        Intrinsics.checkNotNullParameter($this$unzipTo, "<this>");
        Intrinsics.checkNotNullParameter(targetDir, "targetDir");
        Enumeration<? extends ZipEntry> enumeration = $this$unzipTo.entries();
        Intrinsics.checkNotNullExpressionValue(enumeration, "entries(...)");
        Iterator<? extends ZipEntry> iterator2 = CollectionsKt.iterator(enumeration);
        while (iterator2.hasNext()) {
            ZipEntry entry;
            ZipEntry zipEntry = entry = iterator2.next();
            Intrinsics.checkNotNull(zipEntry);
            File out = new File(targetDir, zipEntry.getName());
            if (entry.isDirectory()) {
                out.mkdirs();
                continue;
            }
            out.getParentFile().mkdirs();
            out.createNewFile();
            InputStream entryInputStream = $this$unzipTo.getInputStream(entry);
            Closeable closeable = new FileOutputStream(out);
            Throwable throwable = null;
            try {
                FileOutputStream fileOutPutStream = (FileOutputStream)closeable;
                boolean bl = false;
                fileOutPutStream.write(entryInputStream.readAllBytes());
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
    }

    public static final boolean isMod(@NotNull JarFile $this$isMod, @NotNull AddonType type) {
        Intrinsics.checkNotNullParameter($this$isMod, "<this>");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> {
                if ($this$isMod.getJarEntry("lunarcn.mod.json") != null) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if ($this$isMod.getJarEntry("weave.mod.json") != null) {
                    yield true;
                }
                yield false;
            }
            default -> throw new IllegalStateException(type.name() + " is not a type of Lunar mods!");
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isZipFile(@NotNull File $this$isZipFile) {
        Intrinsics.checkNotNullParameter($this$isZipFile, "<this>");
        try {
            Closeable closeable = new FileInputStream($this$isZipFile);
            Throwable throwable = null;
            try {
                FileInputStream fis = (FileInputStream)closeable;
                boolean bl = false;
                byte[] header = new byte[4];
                if (fis.read(header) != 4) {
                    boolean bl2 = false;
                    return bl2;
                }
                boolean bl3 = FileUtilsKt.isZipSignature(header);
                return bl3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    private static final boolean isZipSignature(byte[] header) {
        return header[0] == 80 && header[1] == 75 && header[2] == 3 && header[3] == 4;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AddonType.values().length];
            try {
                nArray[AddonType.LUNARCN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AddonType.WEAVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

