/*
 * Decompiled with CFR 0.152.
 */
package org.cubewhy.celestial.gui.elements;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.TransferHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.cubewhy.celestial.gui.elements.GuiDraggableList;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/cubewhy/celestial/gui/elements/ListDropHandler;", "T", "Ljavax/swing/TransferHandler;", "list", "Lorg/cubewhy/celestial/gui/elements/GuiDraggableList;", "<init>", "(Lorg/cubewhy/celestial/gui/elements/GuiDraggableList;)V", "getList", "()Lorg/cubewhy/celestial/gui/elements/GuiDraggableList;", "setList", "canImport", "", "support", "Ljavax/swing/TransferHandler$TransferSupport;", "importData", "celestial"})
public final class ListDropHandler<T>
extends TransferHandler {
    @NotNull
    private GuiDraggableList<T> list;

    public ListDropHandler(@NotNull GuiDraggableList<T> list) {
        Intrinsics.checkNotNullParameter(list, "list");
        this.list = list;
    }

    @NotNull
    public final GuiDraggableList<T> getList() {
        return this.list;
    }

    public final void setList(@NotNull GuiDraggableList<T> guiDraggableList) {
        Intrinsics.checkNotNullParameter(guiDraggableList, "<set-?>");
        this.list = guiDraggableList;
    }

    @Override
    public boolean canImport(@NotNull TransferHandler.TransferSupport support) {
        Intrinsics.checkNotNullParameter(support, "support");
        if (!support.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return false;
        }
        TransferHandler.DropLocation dropLocation = support.getDropLocation();
        Intrinsics.checkNotNull(dropLocation, "null cannot be cast to non-null type javax.swing.JList.DropLocation");
        JList.DropLocation dl = (JList.DropLocation)dropLocation;
        return dl.getIndex() != -1;
    }

    @Override
    public boolean importData(@NotNull TransferHandler.TransferSupport support) {
        Intrinsics.checkNotNullParameter(support, "support");
        if (!this.canImport(support)) {
            return false;
        }
        Transferable transferable = support.getTransferable();
        String indexString = null;
        try {
            Object object = transferable.getTransferData(DataFlavor.stringFlavor);
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.String");
            indexString = (String)object;
        }
        catch (Exception e) {
            return false;
        }
        int index = Integer.parseInt(indexString);
        TransferHandler.DropLocation dropLocation = support.getDropLocation();
        Intrinsics.checkNotNull(dropLocation, "null cannot be cast to non-null type javax.swing.JList.DropLocation");
        JList.DropLocation dl = (JList.DropLocation)dropLocation;
        int dropTargetIndex = dl.getIndex();
        Component component = support.getComponent();
        Intrinsics.checkNotNull(component, "null cannot be cast to non-null type javax.swing.JList<T of org.cubewhy.celestial.gui.elements.ListDropHandler>");
        JList jList = (JList)component;
        ListModel listModel = jList.getModel();
        Intrinsics.checkNotNull(listModel, "null cannot be cast to non-null type javax.swing.DefaultListModel<T of org.cubewhy.celestial.gui.elements.ListDropHandler>");
        DefaultListModel model = (DefaultListModel)listModel;
        Object element = model.get(index);
        model.remove(index);
        model.insertElementAt(element, dropTargetIndex);
        return true;
    }
}

