/*
 * Decompiled with CFR 0.152.
 */
package org.cubewhy.celestial.gui.dialogs;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URI;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.cubewhy.celestial.CelestialKt;
import org.cubewhy.celestial.files.Downloadable;
import org.cubewhy.celestial.game.AddonMeta;
import org.cubewhy.celestial.game.RemoteAddon;
import org.cubewhy.celestial.gui.dialogs.AddonInfoDialogKt;
import org.cubewhy.celestial.gui.layouts.VerticalFlowLayout;
import org.cubewhy.celestial.utils.ArrayUtilsKt;
import org.cubewhy.celestial.utils.GuiUtilsKt;
import org.cubewhy.celestial.utils.LinkUtilsKt;
import org.cubewhy.celestial.utils.TextUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/cubewhy/celestial/gui/dialogs/AddonInfoDialog;", "Ljavax/swing/JDialog;", "addon", "Lorg/cubewhy/celestial/game/RemoteAddon;", "file", "Ljava/io/File;", "<init>", "(Lorg/cubewhy/celestial/game/RemoteAddon;Ljava/io/File;)V", "getAddon", "()Lorg/cubewhy/celestial/game/RemoteAddon;", "getFile", "()Ljava/io/File;", "panel", "Ljavax/swing/JPanel;", "initGui", "", "createOpenWebsiteButton", "Ljavax/swing/JButton;", "text", "", "uri", "Ljava/net/URI;", "Companion", "celestial"})
public final class AddonInfoDialog
extends JDialog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RemoteAddon addon;
    @NotNull
    private final File file;
    @NotNull
    private final JPanel panel;
    @NotNull
    private static final Logger log;

    public AddonInfoDialog(@NotNull RemoteAddon addon, @NotNull File file) {
        Intrinsics.checkNotNullParameter(addon, "addon");
        Intrinsics.checkNotNullParameter(file, "file");
        this.addon = addon;
        this.file = file;
        this.panel = new JPanel();
        this.setTitle(CelestialKt.getT().getString("gui.plugins.info.title"));
        this.setSize(600, 600);
        this.panel.setLayout(new VerticalFlowLayout(0, 0, 0, 0, 0, 0, false, false, 255, null));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setLocationByPlatform(true);
        this.initGui();
    }

    @NotNull
    public final RemoteAddon getAddon() {
        return this.addon;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    private final void initGui() {
        Object[] objectArray = new Object[]{this.addon.getName()};
        this.panel.add(new JLabel(TextUtilsKt.format(CelestialKt.getT(), "gui.plugins.info.name", objectArray)));
        objectArray = new Object[]{this.addon.getCategory()};
        this.panel.add(new JLabel(TextUtilsKt.format(CelestialKt.getT(), "gui.plugins.info.category", objectArray)));
        JLabel exist = new JLabel(CelestialKt.getT().getString("gui.plugins.exist"));
        JButton btnDownload = new JButton(CelestialKt.getT().getString("gui.plugins.download"));
        btnDownload.addActionListener(arg_0 -> AddonInfoDialog.initGui$lambda$0(this, exist, arg_0));
        this.panel.add(exist);
        exist.setVisible(this.file.exists());
        this.panel.add(btnDownload);
        this.panel.add(new JSeparator());
        JPanel metaInfo = new JPanel();
        metaInfo.setLayout(new VerticalFlowLayout(3, 0, 0, 0, 0, 0, false, false, 254, null));
        metaInfo.setBorder(new TitledBorder(null, CelestialKt.getT().getString("gui.plugins.info.meta"), 0, 0, null, Color.orange));
        if (this.addon.getMeta() == null) {
            metaInfo.add(new JLabel(CelestialKt.getT().getString("gui.plugins.info.meta.notfound")));
        } else {
            AddonMeta meta = this.addon.getMeta();
            Object[] objectArray2 = new Object[]{meta.getName()};
            metaInfo.add(new JLabel(TextUtilsKt.format(CelestialKt.getT(), "gui.plugins.info.meta.name", objectArray2)));
            objectArray2 = new Object[]{meta.getVersion()};
            metaInfo.add(new JLabel(TextUtilsKt.format(CelestialKt.getT(), "gui.plugins.info.meta.version", objectArray2)));
            objectArray2 = new Object[]{meta.getDescription()};
            metaInfo.add(new JLabel(TextUtilsKt.format(CelestialKt.getT(), "gui.plugins.info.meta.description", objectArray2)));
            objectArray2 = new Object[]{AddonInfoDialogKt.access$getAuthorsString(meta.getAuthors())};
            metaInfo.add(new JLabel(TextUtilsKt.format(CelestialKt.getT(), "gui.plugins.info.meta.authors", objectArray2)));
            if (meta.getWebsite() != null) {
                String string = CelestialKt.getT().getString("gui.plugins.info.meta.website");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                metaInfo.add(this.createOpenWebsiteButton(string, LinkUtilsKt.toURI(meta.getWebsite())));
            }
            if (meta.getRepository() != null) {
                String string = CelestialKt.getT().getString("gui.plugins.info.meta.repo");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                metaInfo.add(this.createOpenWebsiteButton(string, LinkUtilsKt.toURI(meta.getRepository())));
            }
            if (!((objectArray2 = meta.getDependencies()) == null || objectArray2.length == 0)) {
                JTextArea dependencies = new JTextArea();
                dependencies.setBorder(new TitledBorder(null, CelestialKt.getT().getString("gui.plugins.info.meta.dependencies"), 0, 0, null, Color.orange));
                dependencies.setEditable(false);
                StringBuilder sb = new StringBuilder();
                ArrayUtilsKt.forEachIsEnd(meta.getDependencies(), (arg_0, arg_1) -> AddonInfoDialog.initGui$lambda$1(sb, arg_0, arg_1));
                metaInfo.add(GuiUtilsKt.withScroller$default(dependencies, 0, 0, 3, null));
            }
        }
        this.panel.add(metaInfo);
        this.add(GuiUtilsKt.withScroller$default(this.panel, 0, 0, 3, null));
    }

    private final JButton createOpenWebsiteButton(String text, URI uri) {
        JButton button = new JButton(text);
        button.addActionListener(arg_0 -> AddonInfoDialog.createOpenWebsiteButton$lambda$2(uri, arg_0));
        return button;
    }

    private static final void initGui$lambda$0(AddonInfoDialog this$0, JLabel $exist, ActionEvent it) {
        BuildersKt.launch$default(CoroutineScopeKt.CoroutineScope(Dispatchers.getIO()), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, $exist, null){
            int label;
            final /* synthetic */ AddonInfoDialog this$0;
            final /* synthetic */ JLabel $exist;
            {
                this.this$0 = $receiver;
                this.$exist = $exist;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        this.label = 1;
                        v0 = new Downloadable(this.this$0.getAddon().getDownloadURL(), this.this$0.getFile(), this.this$0.getAddon().getSha1(), null, 8, null).downloadAsync(this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.$exist.setVisible(this.this$0.getFile().exists());
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    private static final Unit initGui$lambda$1(StringBuilder $sb, String item, boolean isEnd) {
        Intrinsics.checkNotNullParameter(item, "item");
        $sb.append(item);
        if (!isEnd) {
            $sb.append("\n");
        }
        return Unit.INSTANCE;
    }

    private static final void createOpenWebsiteButton$lambda$2(URI $uri, ActionEvent it) {
        LinkUtilsKt.open($uri);
    }

    static {
        Logger logger = LoggerFactory.getLogger(AddonInfoDialog.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        log = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/cubewhy/celestial/gui/dialogs/AddonInfoDialog$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "celestial"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

