/*
 * Decompiled with CFR 0.152.
 */
package org.cubewhy.celestial.gui;

import java.awt.Color;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.cubewhy.celestial.CelestialKt;
import org.cubewhy.celestial.utils.GuiUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/cubewhy/celestial/gui/LauncherBirthday;", "Ljavax/swing/JPanel;", "birthday", "", "<init>", "(I)V", "celestial"})
public final class LauncherBirthday
extends JPanel {
    public LauncherBirthday(int birthday) {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new TitledBorder(null, CelestialKt.getT().getString("gui.news.birthday.title"), 0, 0, null, Color.orange));
        LocalDate today = LocalDate.now();
        LocalDate nextBirthday = LocalDate.of(today.getYear() + 1, 7, 29);
        int betweenNext = (int)ChronoUnit.DAYS.between(today, nextBirthday);
        if (birthday == 0) {
            String string = CelestialKt.getT().getString("gui.news.birthday.today");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            v1 = this.add(GuiUtilsKt.toJLabel(string));
        } else if (birthday == 1) {
            String string = CelestialKt.getT().getString("gui.news.birthday.tomorrow");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            v1 = this.add(GuiUtilsKt.toJLabel(string));
        } else if (birthday == -1) {
            String string = CelestialKt.getT().getString("gui.news.birthday.yesterday");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            String string2 = string;
            Object[] objectArray = new Object[]{betweenNext};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
            v1 = this.add(GuiUtilsKt.toJLabel(string3));
        } else if (birthday > 0) {
            String string = CelestialKt.getT().getString("gui.news.birthday.coming");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            String string4 = string;
            Object[] objectArray = new Object[]{birthday};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string5, "format(...)");
            v1 = this.add(GuiUtilsKt.toJLabel(string5));
        } else {
            String string = CelestialKt.getT().getString("gui.news.birthday.after");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            String string6 = string;
            Object[] objectArray = new Object[]{Math.abs(birthday), betweenNext};
            String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string7, "format(...)");
            v1 = this.add(GuiUtilsKt.toJLabel(string7));
        }
    }
}

