/*
 * Decompiled with CFR 0.152.
 */
package org.cubewhy.celestial.game.addon;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.cubewhy.celestial.CelestialKt;
import org.cubewhy.celestial.game.BaseAddon;
import org.cubewhy.celestial.utils.AddonUtilsKt;
import org.cubewhy.celestial.utils.FileUtilsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\u00a8\u0006\u000f"}, d2={"Lorg/cubewhy/celestial/game/addon/WeaveMod;", "Lorg/cubewhy/celestial/game/BaseAddon;", "file", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "toString", "", "isEnabled", "", "()Z", "toggle", "Companion", "celestial"})
public final class WeaveMod
extends BaseAddon {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File file;
    @NotNull
    private static final File modFolder = new File(System.getProperty("user.home"), ".weave/mods");
    @NotNull
    private static final Logger log;

    public WeaveMod(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        this.file = file;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public String toString() {
        String string = this.file.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        return string;
    }

    @Override
    public boolean isEnabled() {
        String string = this.file.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        return StringsKt.endsWith$default(string, ".jar", false, 2, null);
    }

    @Override
    public boolean toggle() {
        return this.toggle(this.file);
    }

    public static final /* synthetic */ File access$autoCopy$s159360463(File file, File folder) {
        return BaseAddon.autoCopy(file, folder);
    }

    static {
        Logger logger = LoggerFactory.getLogger(WeaveMod.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        log = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0007J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000eJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u0005J\u000e\u0010\u0014\u001a\u00020\u0015H\u0086@\u00a2\u0006\u0002\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00058G\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lorg/cubewhy/celestial/game/addon/WeaveMod$Companion;", "", "<init>", "()V", "modFolder", "Ljava/io/File;", "getModFolder", "()Ljava/io/File;", "log", "Lorg/slf4j/Logger;", "findEnabled", "", "Lorg/cubewhy/celestial/game/addon/WeaveMod;", "findDisabled", "", "findAll", "add", "file", "installation", "getInstallation", "checkUpdate", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "celestial"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final File getModFolder() {
            return modFolder;
        }

        @Contract(pure=true)
        @NotNull
        public final List<WeaveMod> findEnabled() {
            List list = new ArrayList();
            if (this.getModFolder().isDirectory()) {
                Iterator<Object> iterator2 = ArrayIteratorKt.iterator((Object[])Objects.requireNonNull(this.getModFolder().listFiles()));
                while (iterator2.hasNext()) {
                    File file = (File)iterator2.next();
                    String string = file.getName();
                    Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                    if (!StringsKt.endsWith$default(string, ".jar", false, 2, null) || !file.isFile()) continue;
                    list.add(new WeaveMod(file));
                }
            }
            return list;
        }

        @NotNull
        public final List<WeaveMod> findDisabled() {
            List list = new ArrayList();
            if (this.getModFolder().isDirectory()) {
                Iterator<Object> iterator2 = ArrayIteratorKt.iterator((Object[])Objects.requireNonNull(this.getModFolder().listFiles()));
                while (iterator2.hasNext()) {
                    File file = (File)iterator2.next();
                    String string = file.getName();
                    Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                    if (!StringsKt.endsWith$default(string, ".jar.disabled", false, 2, null) || !file.isFile()) continue;
                    list.add(new WeaveMod(file));
                }
            }
            return list;
        }

        @NotNull
        public final List<WeaveMod> findAll() {
            List<WeaveMod> list = this.findEnabled();
            list.addAll((Collection<WeaveMod>)this.findDisabled());
            List<WeaveMod> list2 = Collections.unmodifiableList(list);
            Intrinsics.checkNotNullExpressionValue(list2, "unmodifiableList(...)");
            return list2;
        }

        @Nullable
        public final WeaveMod add(@NotNull File file) {
            Intrinsics.checkNotNullParameter(file, "file");
            File target = WeaveMod.access$autoCopy$s159360463(file, this.getModFolder());
            return target == null ? null : new WeaveMod(target);
        }

        @Contract(value=" -> new")
        @NotNull
        public final File getInstallation() {
            return FileUtilsKt.toFile(CelestialKt.getConfig().getAddon().getWeave().getInstallationDir());
        }

        @Nullable
        public final Object checkUpdate(@NotNull Continuation<? super Boolean> $completion) {
            log.info("Updating Weave Loader");
            return AddonUtilsKt.downloadLoader("Weave-MC/Weave-Loader", FileUtilsKt.toFile(CelestialKt.getConfig().getAddon().getWeave().getInstallationDir()), $completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

