/*
 * Decompiled with CFR 0.152.
 */
package org.cubewhy.celestial.game.addon;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import org.cubewhy.celestial.CelestialKt;
import org.cubewhy.celestial.JavaagentConfiguration;
import org.cubewhy.celestial.game.BaseAddon;
import org.cubewhy.celestial.game.addon.JavaagentManifest;
import org.cubewhy.celestial.utils.GitUtils;
import org.cubewhy.celestial.utils.JavaUtilsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 &2\u00020\u0001:\u0001&B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB'\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\b\u0010\u001f\u001a\u00020\u0003H\u0016J\b\u0010!\u001a\u00020\u0006H\u0016J\b\u0010\"\u001a\u0004\u0018\u00010\u0016J\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020\u0006R\"\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\u0010\f\u001a\u0004\u0018\u00010\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0012R\u0011\u0010\u001d\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000eR\u0014\u0010 \u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0012\u00a8\u0006'"}, d2={"Lorg/cubewhy/celestial/game/addon/JavaAgent;", "Lorg/cubewhy/celestial/game/BaseAddon;", "path", "", "arg", "classpath", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Z)V", "file", "Ljava/io/File;", "(Ljava/io/File;Ljava/lang/String;Z)V", "value", "getArg", "()Ljava/lang/String;", "getFile", "()Ljava/io/File;", "getClasspath", "()Z", "setClasspath", "(Z)V", "agentManifest", "Lorg/cubewhy/celestial/game/addon/JavaagentManifest;", "getAgentManifest", "()Lorg/cubewhy/celestial/game/addon/JavaagentManifest;", "setAgentManifest", "(Lorg/cubewhy/celestial/game/addon/JavaagentManifest;)V", "hasExtraUi", "getHasExtraUi", "jvmArg", "getJvmArg", "toString", "isEnabled", "toggle", "parseManifest", "openConfigWindow", "", "toggleClasspath", "Companion", "celestial"})
@SourceDebugExtension(value={"SMAP\nJavaAgent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaAgent.kt\norg/cubewhy/celestial/game/addon/JavaAgent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,277:1\n1#2:278\n*E\n"})
public final class JavaAgent
extends BaseAddon {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String arg;
    @NotNull
    private final File file;
    private boolean classpath;
    @Nullable
    private JavaagentManifest agentManifest;
    @NotNull
    private static final File javaAgentFolder = new File(CelestialKt.getConfigDir(), "javaagents");
    @NotNull
    private static final Logger log;

    @Nullable
    public final String getArg() {
        return this.arg;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    public final boolean getClasspath() {
        return this.classpath;
    }

    public final void setClasspath(boolean bl) {
        this.classpath = bl;
    }

    @Nullable
    public final JavaagentManifest getAgentManifest() {
        return this.agentManifest;
    }

    public final void setAgentManifest(@Nullable JavaagentManifest javaagentManifest) {
        this.agentManifest = javaagentManifest;
    }

    public final boolean getHasExtraUi() {
        JavaagentManifest javaagentManifest = this.agentManifest;
        return (javaagentManifest != null ? javaagentManifest.getExtraConfigMain() : null) != null;
    }

    public JavaAgent(@NotNull String path, @Nullable String arg, boolean classpath) {
        Intrinsics.checkNotNullParameter(path, "path");
        this.arg = "";
        this.file = new File(path);
        this.arg = arg;
        this.classpath = classpath;
        this.agentManifest = this.parseManifest();
    }

    public /* synthetic */ JavaAgent(String string, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        this(string, string2, bl);
    }

    public JavaAgent(@NotNull File file, @Nullable String arg, boolean classpath) {
        Intrinsics.checkNotNullParameter(file, "file");
        this.arg = "";
        this.file = file;
        this.arg = arg;
        this.classpath = classpath;
        this.agentManifest = this.parseManifest();
    }

    public /* synthetic */ JavaAgent(File file, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        this(file, string, bl);
    }

    @NotNull
    public final String getJvmArg() {
        String jvmArgs = "-javaagent:" + this.file;
        String string = this.arg;
        boolean bl = string != null ? ((CharSequence)string).length() > 0 : false;
        if (bl) {
            jvmArgs = jvmArgs + "=" + this.arg;
        }
        return jvmArgs;
    }

    @NotNull
    public String toString() {
        String result2 = (this.classpath ? "" : "[*] ") + this.file.getName();
        String string = this.arg;
        boolean bl = string != null ? !StringsKt.isBlank(string) : false;
        if (bl) {
            result2 = result2 + "=" + this.arg;
        }
        return result2;
    }

    @Override
    public boolean isEnabled() {
        String string = this.file.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        return StringsKt.endsWith$default(string, ".jar", false, 2, null);
    }

    @Override
    public boolean toggle() {
        if (this.isEnabled()) {
            String string = this.file.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            Companion.migrate(string, this.file.getName() + ".disabled");
        } else {
            String string = this.file.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            String string2 = this.file.getName();
            Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
            String string3 = string2;
            int n = 0;
            int n2 = this.file.getName().length() - 9;
            String string4 = string3.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
            Companion.migrate(string, string4);
        }
        return this.toggle(this.file);
    }

    @Nullable
    public final JavaagentManifest parseManifest() {
        String string;
        try {
            JarFile jar = new JarFile(this.file);
            ZipEntry entry = jar.getEntry("celestial.manifest.json");
            byte[] byArray = jar.getInputStream(entry).readAllBytes();
            Intrinsics.checkNotNullExpressionValue(byArray, "readAllBytes(...)");
            byte[] byArray2 = byArray;
            Charset charset = Charsets.UTF_8;
            string = new String(byArray2, charset);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        String content = string;
        try {
            return (JavaagentManifest)CelestialKt.getJSON().decodeFromString((DeserializationStrategy)JavaagentManifest.Companion.serializer(), content);
        }
        catch (RuntimeException e) {
            log.error("Invalid manifest of javaagent " + this.file, e);
            return null;
        }
    }

    public final void openConfigWindow() {
        if (!this.getHasExtraUi() || this.agentManifest == null) {
            return;
        }
        File java = new File(JavaUtilsKt.getJavaExecUsedToLaunchGame());
        List commandList = new ArrayList();
        String string = java.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue(string, "getAbsolutePath(...)");
        commandList.add(string);
        commandList.add("-cp");
        String string2 = this.file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue(string2, "getAbsolutePath(...)");
        commandList.add(string2);
        commandList.add("-Dcelestial.version=" + GitUtils.INSTANCE.getBuildVersion());
        String string3 = this.arg;
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            commandList.add("-Dcelestial.agent.arg=" + it);
        }
        commandList.add("-Dcelestial.game.installation=" + CelestialKt.getConfig().getInstallationDir());
        JavaagentManifest javaagentManifest = this.agentManifest;
        Intrinsics.checkNotNull(javaagentManifest);
        String string4 = javaagentManifest.getExtraConfigMain();
        Intrinsics.checkNotNull(string4);
        commandList.add(string4);
        ProcessBuilder pb = new ProcessBuilder(commandList).redirectErrorStream(true);
        Process process = pb.start();
        log.info("Started extra config ui (pid = " + process.pid() + ")");
        new Thread(() -> JavaAgent.openConfigWindow$lambda$4(process)).start();
    }

    public final boolean toggleClasspath() {
        HashMap<String, JavaagentConfiguration> ja = CelestialKt.getConfig().getGame().getJavaagents();
        if (!ja.containsKey(this.file.getName())) {
            ((Map)ja).put(this.file.getName(), new JavaagentConfiguration(this.arg, !this.classpath));
        } else {
            JavaagentConfiguration javaagentConfiguration = ja.get(this.file.getName());
            if (javaagentConfiguration != null) {
                javaagentConfiguration.setClasspath(!this.classpath);
            }
        }
        JavaagentConfiguration javaagentConfiguration = ja.get(this.file.getName());
        return javaagentConfiguration != null ? javaagentConfiguration.getClasspath() : false;
    }

    private static final Unit openConfigWindow$lambda$4$lambda$3$lambda$1(String line) {
        log.info(line);
        return Unit.INSTANCE;
    }

    private static final void openConfigWindow$lambda$4$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void openConfigWindow$lambda$4(Process $process) {
        Closeable closeable = new BufferedReader(new InputStreamReader($process.getInputStream()));
        Throwable throwable = null;
        try {
            BufferedReader reader = (BufferedReader)closeable;
            boolean bl = false;
            reader.lines().forEach(arg_0 -> JavaAgent.openConfigWindow$lambda$4$lambda$3$lambda$2(JavaAgent::openConfigWindow$lambda$4$lambda$3$lambda$1, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    public static final /* synthetic */ File access$autoCopy$s159360463(File file, File folder) {
        return BaseAddon.autoCopy(file, folder);
    }

    static {
        Logger logger = LoggerFactory.getLogger(JavaAgent.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        log = logger;
        if (!javaAgentFolder.exists()) {
            log.info("Making javaagents folder");
            javaAgentFolder.mkdirs();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0007J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0002J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000eJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0019\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0016\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/cubewhy/celestial/game/addon/JavaAgent$Companion;", "", "<init>", "()V", "javaAgentFolder", "Ljava/io/File;", "getJavaAgentFolder", "()Ljava/io/File;", "log", "Lorg/slf4j/Logger;", "findEnabled", "", "Lorg/cubewhy/celestial/game/addon/JavaAgent;", "findDisabled", "", "findAll", "setArgFor", "", "agent", "arg", "", "name", "findAgentConfig", "Lorg/cubewhy/celestial/JavaagentConfiguration;", "add", "file", "migrate", "old", "n3w", "celestial"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final File getJavaAgentFolder() {
            return javaAgentFolder;
        }

        @Contract(pure=true)
        @NotNull
        public final List<JavaAgent> findEnabled() {
            List list = new ArrayList();
            if (this.getJavaAgentFolder().isDirectory()) {
                Iterator<Object> iterator2 = ArrayIteratorKt.iterator((Object[])Objects.requireNonNull(this.getJavaAgentFolder().listFiles()));
                while (iterator2.hasNext()) {
                    File file = (File)iterator2.next();
                    String string = file.getName();
                    Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                    if (!StringsKt.endsWith$default(string, ".jar", false, 2, null) || !file.isFile()) continue;
                    String string2 = file.getName();
                    Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                    JavaagentConfiguration javaagentConfiguration = this.findAgentConfig(string2);
                    list.add(new JavaAgent(file, javaagentConfiguration.getArg(), javaagentConfiguration.getClasspath()));
                }
            }
            return list;
        }

        private final List<JavaAgent> findDisabled() {
            List list = new ArrayList();
            if (this.getJavaAgentFolder().isDirectory()) {
                Iterator<Object> iterator2 = ArrayIteratorKt.iterator((Object[])Objects.requireNonNull(this.getJavaAgentFolder().listFiles()));
                while (iterator2.hasNext()) {
                    File file = (File)iterator2.next();
                    String string = file.getName();
                    Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                    if (!StringsKt.endsWith$default(string, ".jar.disabled", false, 2, null) || !file.isFile()) continue;
                    String string2 = file.getName();
                    Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                    JavaagentConfiguration jaConfig = this.findAgentConfig(string2);
                    list.add(new JavaAgent(file, jaConfig.getArg(), jaConfig.getClasspath()));
                }
            }
            return list;
        }

        @NotNull
        public final List<JavaAgent> findAll() {
            List<JavaAgent> list = this.findEnabled();
            list.addAll((Collection<JavaAgent>)this.findDisabled());
            List<JavaAgent> list2 = Collections.unmodifiableList(list);
            Intrinsics.checkNotNullExpressionValue(list2, "unmodifiableList(...)");
            return list2;
        }

        public final void setArgFor(@NotNull JavaAgent agent, @Nullable String arg) {
            Intrinsics.checkNotNullParameter(agent, "agent");
            String string = agent.getFile().getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            this.setArgFor(string, arg);
        }

        public final void setArgFor(@NotNull String name, @Nullable String arg) {
            block1: {
                HashMap<String, JavaagentConfiguration> ja;
                block0: {
                    Intrinsics.checkNotNullParameter(name, "name");
                    ja = CelestialKt.getConfig().getGame().getJavaagents();
                    if (ja.containsKey(name)) break block0;
                    ((Map)ja).put(name, new JavaagentConfiguration(arg, false, 2, null));
                    break block1;
                }
                JavaagentConfiguration javaagentConfiguration = ja.get(name);
                if (javaagentConfiguration == null) break block1;
                javaagentConfiguration.setArg(arg);
            }
        }

        private final JavaagentConfiguration findAgentConfig(String name) {
            JavaagentConfiguration javaagentConfiguration;
            HashMap<String, JavaagentConfiguration> ja = CelestialKt.getConfig().getGame().getJavaagents();
            if (!ja.containsKey(name)) {
                ((Map)ja).put(name, new JavaagentConfiguration(null, false, 3, null));
            }
            if ((javaagentConfiguration = ja.get(name)) == null) {
                javaagentConfiguration = new JavaagentConfiguration(null, false, 3, null);
            }
            return javaagentConfiguration;
        }

        @Nullable
        public final JavaAgent add(@NotNull File file, @Nullable String arg) {
            Intrinsics.checkNotNullParameter(file, "file");
            File target = JavaAgent.access$autoCopy$s159360463(file, this.getJavaAgentFolder());
            if (arg != null) {
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                this.setArgFor(string, arg);
            }
            return target == null ? null : new JavaAgent(target, arg, false, 4, null);
        }

        public final void migrate(@NotNull String old, @NotNull String n3w) {
            Intrinsics.checkNotNullParameter(old, "old");
            Intrinsics.checkNotNullParameter(n3w, "n3w");
            HashMap<String, JavaagentConfiguration> ja = CelestialKt.getConfig().getGame().getJavaagents();
            JavaagentConfiguration arg = ja.get(old) == null ? new JavaagentConfiguration(null, false, 3, null) : ja.get(old);
            ((Map)ja).put(n3w, arg);
            ja.remove(old);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

