/*
 * Decompiled with CFR 0.152.
 */
package org.cubewhy.celestial.files;

import cn.hutool.crypto.SecureUtil;
import java.io.Closeable;
import java.io.File;
import java.net.URL;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import okhttp3.coroutines.ExecuteAsyncKt;
import org.apache.commons.io.FileUtils;
import org.cubewhy.celestial.CelestialKt;
import org.cubewhy.celestial.event.impl.FileDownloadEvent;
import org.cubewhy.celestial.event.impl.UpdateStatusTextEvent;
import org.cubewhy.celestial.files.DownloadManager;
import org.cubewhy.celestial.files.Downloadable;
import org.cubewhy.celestial.utils.RequestUtils;
import org.cubewhy.celestial.utils.RequestUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0086@\u00a2\u0006\u0002\u0010\u0011J2\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0080@\u00a2\u0006\u0004\b\u0017\u0010\u0018J \u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u0016H\u0002J\u001e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0005H\u0082@\u00a2\u0006\u0002\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/cubewhy/celestial/files/DownloadManager;", "", "<init>", "()V", "cacheDir", "Ljava/io/File;", "getCacheDir", "()Ljava/io/File;", "log", "Lorg/slf4j/Logger;", "cache", "", "url", "Ljava/net/URL;", "name", "", "override", "(Ljava/net/URL;Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "download0", "file", "hash", "type", "Lorg/cubewhy/celestial/files/Downloadable$Type;", "download0$celestial", "(Ljava/net/URL;Ljava/io/File;Ljava/lang/String;Lorg/cubewhy/celestial/files/Downloadable$Type;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "compareHash", "hashString", "hashType", "(Ljava/net/URL;Ljava/io/File;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "celestial"})
public final class DownloadManager {
    @NotNull
    public static final DownloadManager INSTANCE = new DownloadManager();
    @NotNull
    private static final File cacheDir = new File(CelestialKt.getConfigDir(), "cache");
    @NotNull
    private static final Logger log;

    private DownloadManager() {
    }

    @NotNull
    public final File getCacheDir() {
        return cacheDir;
    }

    @Nullable
    public final Object cache(@NotNull URL url, @NotNull String name, boolean override, @NotNull Continuation<? super Boolean> $completion) {
        File file = new File(cacheDir, name);
        if (file.exists() && !override) {
            return Boxing.boxBoolean(true);
        }
        log.info("Caching " + name + " (from " + url + ")");
        return this.download0(url, file, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object download0$celestial(@NotNull URL var1_1, @NotNull File var2_2, @Nullable String var3_3, @NotNull Downloadable.Type var4_4, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof download0.1)) ** GOTO lbl-1000
        var13_6 = $completion;
        if ((var13_6.label & -2147483648) != 0) {
            var13_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ DownloadManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.download0$celestial(null, null, null, null, this);
                }
            };
        }
        $result = $continuation.result;
        var14_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                if (file.isFile() && hash != null && this.compareHash(file, hash, type)) {
                    return Boxing.boxBoolean(true);
                }
                new FileDownloadEvent(file, FileDownloadEvent.Type.START).call();
                DownloadManager.log.info("Downloading " + (URL)url + " to " + file);
                $continuation.L$0 = file;
                $continuation.L$1 = hash;
                $continuation.L$2 = type;
                $continuation.label = 1;
                v0 = ExecuteAsyncKt.executeAsync(RequestUtils.INSTANCE.get((URL)url), $continuation);
                if (v0 == var14_8) {
                    return var14_8;
                }
                ** GOTO lbl31
            }
            case 1: {
                type = (Downloadable.Type)$continuation.L$2;
                hash = (String)$continuation.L$1;
                file = (File)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl31:
                // 2 sources

                var6_9 = (Closeable)v0;
                var7_11 = null;
                response = (Response)var6_9;
                $i$a$-use-DownloadManager$download0$2 = false;
                if (response.isSuccessful()) ** GOTO lbl44
                new FileDownloadEvent(file, FileDownloadEvent.Type.FAILURE).call();
                var11_16 = Boxing.boxBoolean(false);
                CloseableKt.closeFinally(var6_9, var7_11);
                return var11_16;
lbl44:
                // 2 sources

                $continuation.L$0 = file;
                $continuation.L$1 = hash;
                $continuation.L$2 = type;
                $continuation.L$3 = var6_9;
                $continuation.label = 2;
                v1 = RequestUtilsKt.bytesAsync(response.body(), $continuation);
                ** if (v1 != var14_8) goto lbl52
lbl51:
                // 1 sources

                return var14_8;
lbl52:
                // 1 sources

                ** GOTO lbl64
            }
            case 2: {
                $i$a$-use-DownloadManager$download0$2 = false;
                var7_11 = null;
                var6_9 = (Closeable)$continuation.L$3;
                type = (Downloadable.Type)$continuation.L$2;
                hash = (String)$continuation.L$1;
                file = (File)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure($result);
                    v1 = $result;
lbl64:
                    // 2 sources

                    bytes = (byte[])v1;
                    FileUtils.writeByteArrayToFile(file, bytes);
                    var8_12 = Unit.INSTANCE;
                    ** GOTO lbl77
                }
                catch (Throwable var9_14) {
                    var7_11 = var9_14;
                    throw var9_14;
                }
            }
            catch (Throwable var9_15) {
                throw var9_15;
            }
            {
                finally {
                    CloseableKt.closeFinally(var6_9, var7_11);
                }
lbl77:
                // 1 sources

                new UpdateStatusTextEvent("Download " + file.getName() + " success.").call();
                if (hash != null) {
                    result = this.compareHash(file, hash, type);
                    if (!result) {
                        new FileDownloadEvent(file, FileDownloadEvent.Type.FAILURE).call();
                    }
                    return Boxing.boxBoolean(result != false);
                }
                new FileDownloadEvent(file, FileDownloadEvent.Type.SUCCESS).call();
                return Boxing.boxBoolean(true);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean compareHash(File file, String hashString, Downloadable.Type hashType) {
        return hashType == Downloadable.Type.SHA1 && Intrinsics.areEqual(SecureUtil.sha1(file), hashString) || hashType == Downloadable.Type.SHA256 && Intrinsics.areEqual(SecureUtil.sha256(file), hashString);
    }

    private final Object download0(URL url, File file, Continuation<? super Boolean> $completion) {
        return this.download0$celestial(url, file, null, Downloadable.Type.SHA1, $completion);
    }

    public static final /* synthetic */ Object access$download0(DownloadManager $this, URL url, File file, Continuation $completion) {
        return $this.download0(url, file, $completion);
    }

    static {
        Logger logger = LoggerFactory.getLogger(DownloadManager.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        log = logger;
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
    }
}

