/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.Objects;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.logging.log4j.core.appender.rolling.action.AbstractAction;

public final class CommonsCompressAction
extends AbstractAction {
    private static final int BUF_SIZE = 8192;
    private final String name;
    private final File source;
    private final File destination;
    private final boolean deleteSource;

    public CommonsCompressAction(String name, File source2, File destination, boolean deleteSource) {
        Objects.requireNonNull(source2, "source");
        Objects.requireNonNull(destination, "destination");
        this.name = name;
        this.source = source2;
        this.destination = destination;
        this.deleteSource = deleteSource;
    }

    @Override
    public boolean execute() throws IOException {
        return CommonsCompressAction.execute(this.name, this.source, this.destination, this.deleteSource);
    }

    public static boolean execute(String name, File source2, File destination, boolean deleteSource) throws IOException {
        if (!source2.exists()) {
            return false;
        }
        LOGGER.debug("Starting {} compression of {}", (Object)name, (Object)source2.getPath());
        try (FileInputStream input = new FileInputStream(source2);
             FileOutputStream fileOutput = new FileOutputStream(destination);
             BufferedOutputStream output = new BufferedOutputStream((OutputStream)new CompressorStreamFactory().createCompressorOutputStream(name, (OutputStream)fileOutput));){
            IOUtils.copy((InputStream)input, (OutputStream)output, (int)8192);
            LOGGER.debug("Finished {} compression of {}", (Object)name, (Object)source2.getPath());
        }
        catch (CompressorException e) {
            throw new IOException(e);
        }
        if (deleteSource) {
            try {
                if (Files.deleteIfExists(source2.toPath())) {
                    LOGGER.debug("Deleted {}", (Object)source2.toString());
                } else {
                    LOGGER.warn("Unable to delete {} after {} compression. File did not exist", (Object)source2.toString(), (Object)name);
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Unable to delete {} after {} compression, {}", (Object)source2.toString(), (Object)name, (Object)ex.getMessage());
            }
        }
        return true;
    }

    @Override
    protected void reportException(Exception ex) {
        LOGGER.warn("Exception during " + this.name + " compression of '" + this.source.toString() + "'.", (Throwable)ex);
    }

    public String toString() {
        return CommonsCompressAction.class.getSimpleName() + '[' + this.source + " to " + this.destination + ", deleteSource=" + this.deleteSource + ']';
    }

    public String getName() {
        return this.name;
    }

    public File getSource() {
        return this.source;
    }

    public File getDestination() {
        return this.destination;
    }

    public boolean isDeleteSource() {
        return this.deleteSource;
    }
}

