/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.websocket.screenshot.v1;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilder;
import com.google.protobuf.RuntimeVersion;
import com.google.protobuf.SingleFieldBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.lunarclient.common.v1.Uuid;
import com.lunarclient.common.v1.UuidAndUsername;
import com.lunarclient.common.v1.UuidAndUsernameOrBuilder;
import com.lunarclient.common.v1.UuidOrBuilder;
import com.lunarclient.common.v1.Vector3f;
import com.lunarclient.common.v1.Vector3fOrBuilder;
import com.lunarclient.websocket.screenshot.v1.CommonProto;
import com.lunarclient.websocket.screenshot.v1.Dimensions;
import com.lunarclient.websocket.screenshot.v1.DimensionsOrBuilder;
import com.lunarclient.websocket.screenshot.v1.Perspective;
import com.lunarclient.websocket.screenshot.v1.PlayerState;
import com.lunarclient.websocket.screenshot.v1.ScreenshotMessageOrBuilder;
import com.lunarclient.websocket.screenshot.v1.ScreenshotPlayer;
import com.lunarclient.websocket.screenshot.v1.ScreenshotPlayerOrBuilder;
import com.lunarclient.websocket.screenshot.v1.Weather;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ScreenshotMessage
extends GeneratedMessage
implements ScreenshotMessageOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int AUTHOR_FIELD_NUMBER = 1;
    private UuidAndUsername author_;
    public static final int STATES_FIELD_NUMBER = 2;
    private Internal.IntList states_;
    private static final Internal.IntListAdapter.IntConverter<PlayerState> states_converter_;
    private int statesMemoizedSerializedSize;
    public static final int PLAYERS_FIELD_NUMBER = 3;
    private List<ScreenshotPlayer> players_;
    public static final int DIMENSION_FIELD_NUMBER = 4;
    private volatile Object dimension_ = "";
    public static final int BIOME_FIELD_NUMBER = 5;
    private volatile Object biome_ = "";
    public static final int YAW_FIELD_NUMBER = 6;
    private float yaw_ = 0.0f;
    public static final int PITCH_FIELD_NUMBER = 7;
    private float pitch_ = 0.0f;
    public static final int POS_FIELD_NUMBER = 8;
    private Vector3f pos_;
    public static final int SIZE_FIELD_NUMBER = 9;
    private Dimensions size_;
    public static final int PERSPECTIVE_FIELD_NUMBER = 10;
    private int perspective_ = 0;
    public static final int HAS_HUD_FIELD_NUMBER = 11;
    private boolean hasHud_ = false;
    public static final int DAY_TIME_FIELD_NUMBER = 12;
    private long dayTime_ = 0L;
    public static final int WEATHER_FIELD_NUMBER = 13;
    private int weather_ = 0;
    public static final int HEALTH_FIELD_NUMBER = 14;
    private float health_ = 0.0f;
    public static final int MAX_HEALTH_FIELD_NUMBER = 15;
    private float maxHealth_ = 0.0f;
    public static final int FOOD_LEVEL_FIELD_NUMBER = 16;
    private float foodLevel_ = 0.0f;
    public static final int SATURATION_LEVEL_FIELD_NUMBER = 17;
    private float saturationLevel_ = 0.0f;
    public static final int LOCAL_ID_FIELD_NUMBER = 18;
    private Uuid localId_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final ScreenshotMessage DEFAULT_INSTANCE;
    private static final Parser<ScreenshotMessage> PARSER;

    private ScreenshotMessage(GeneratedMessage.Builder<?> builder) {
        super(builder);
    }

    private ScreenshotMessage() {
        this.states_ = ScreenshotMessage.emptyIntList();
        this.players_ = Collections.emptyList();
        this.dimension_ = "";
        this.biome_ = "";
        this.perspective_ = 0;
        this.weather_ = 0;
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return CommonProto.internal_static_lunarclient_websocket_screenshot_v1_ScreenshotMessage_descriptor;
    }

    @Override
    protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
        return CommonProto.internal_static_lunarclient_websocket_screenshot_v1_ScreenshotMessage_fieldAccessorTable.ensureFieldAccessorsInitialized(ScreenshotMessage.class, Builder.class);
    }

    @Override
    public boolean hasAuthor() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public UuidAndUsername getAuthor() {
        return this.author_ == null ? UuidAndUsername.getDefaultInstance() : this.author_;
    }

    @Override
    public UuidAndUsernameOrBuilder getAuthorOrBuilder() {
        return this.author_ == null ? UuidAndUsername.getDefaultInstance() : this.author_;
    }

    @Override
    public List<PlayerState> getStatesList() {
        return new Internal.IntListAdapter<PlayerState>(this.states_, states_converter_);
    }

    @Override
    public int getStatesCount() {
        return this.states_.size();
    }

    @Override
    public PlayerState getStates(int index) {
        return states_converter_.convert(this.states_.getInt(index));
    }

    @Override
    public List<Integer> getStatesValueList() {
        return this.states_;
    }

    @Override
    public int getStatesValue(int index) {
        return this.states_.getInt(index);
    }

    @Override
    public List<ScreenshotPlayer> getPlayersList() {
        return this.players_;
    }

    @Override
    public List<? extends ScreenshotPlayerOrBuilder> getPlayersOrBuilderList() {
        return this.players_;
    }

    @Override
    public int getPlayersCount() {
        return this.players_.size();
    }

    @Override
    public ScreenshotPlayer getPlayers(int index) {
        return this.players_.get(index);
    }

    @Override
    public ScreenshotPlayerOrBuilder getPlayersOrBuilder(int index) {
        return this.players_.get(index);
    }

    @Override
    public String getDimension() {
        Object ref = this.dimension_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.dimension_ = s;
        return s;
    }

    @Override
    public ByteString getDimensionBytes() {
        Object ref = this.dimension_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)ref);
            this.dimension_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getBiome() {
        Object ref = this.biome_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.biome_ = s;
        return s;
    }

    @Override
    public ByteString getBiomeBytes() {
        Object ref = this.biome_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)ref);
            this.biome_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public float getYaw() {
        return this.yaw_;
    }

    @Override
    public float getPitch() {
        return this.pitch_;
    }

    @Override
    public boolean hasPos() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public Vector3f getPos() {
        return this.pos_ == null ? Vector3f.getDefaultInstance() : this.pos_;
    }

    @Override
    public Vector3fOrBuilder getPosOrBuilder() {
        return this.pos_ == null ? Vector3f.getDefaultInstance() : this.pos_;
    }

    @Override
    public boolean hasSize() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public Dimensions getSize() {
        return this.size_ == null ? Dimensions.getDefaultInstance() : this.size_;
    }

    @Override
    public DimensionsOrBuilder getSizeOrBuilder() {
        return this.size_ == null ? Dimensions.getDefaultInstance() : this.size_;
    }

    @Override
    public int getPerspectiveValue() {
        return this.perspective_;
    }

    @Override
    public Perspective getPerspective() {
        Perspective result2 = Perspective.forNumber(this.perspective_);
        return result2 == null ? Perspective.UNRECOGNIZED : result2;
    }

    @Override
    public boolean getHasHud() {
        return this.hasHud_;
    }

    @Override
    public long getDayTime() {
        return this.dayTime_;
    }

    @Override
    public int getWeatherValue() {
        return this.weather_;
    }

    @Override
    public Weather getWeather() {
        Weather result2 = Weather.forNumber(this.weather_);
        return result2 == null ? Weather.UNRECOGNIZED : result2;
    }

    @Override
    public float getHealth() {
        return this.health_;
    }

    @Override
    public float getMaxHealth() {
        return this.maxHealth_;
    }

    @Override
    public float getFoodLevel() {
        return this.foodLevel_;
    }

    @Override
    public float getSaturationLevel() {
        return this.saturationLevel_;
    }

    @Override
    public boolean hasLocalId() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public Uuid getLocalId() {
        return this.localId_ == null ? Uuid.getDefaultInstance() : this.localId_;
    }

    @Override
    public UuidOrBuilder getLocalIdOrBuilder() {
        return this.localId_ == null ? Uuid.getDefaultInstance() : this.localId_;
    }

    @Override
    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    @Override
    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(1, this.getAuthor());
        }
        if (this.getStatesList().size() > 0) {
            output.writeUInt32NoTag(18);
            output.writeUInt32NoTag(this.statesMemoizedSerializedSize);
        }
        for (i = 0; i < this.states_.size(); ++i) {
            output.writeEnumNoTag(this.states_.getInt(i));
        }
        for (i = 0; i < this.players_.size(); ++i) {
            output.writeMessage(3, this.players_.get(i));
        }
        if (!GeneratedMessage.isStringEmpty(this.dimension_)) {
            GeneratedMessage.writeString(output, 4, this.dimension_);
        }
        if (!GeneratedMessage.isStringEmpty(this.biome_)) {
            GeneratedMessage.writeString(output, 5, this.biome_);
        }
        if (Float.floatToRawIntBits(this.yaw_) != 0) {
            output.writeFloat(6, this.yaw_);
        }
        if (Float.floatToRawIntBits(this.pitch_) != 0) {
            output.writeFloat(7, this.pitch_);
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(8, this.getPos());
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(9, this.getSize());
        }
        if (this.perspective_ != Perspective.PERSPECTIVE_UNSPECIFIED.getNumber()) {
            output.writeEnum(10, this.perspective_);
        }
        if (this.hasHud_) {
            output.writeBool(11, this.hasHud_);
        }
        if (this.dayTime_ != 0L) {
            output.writeInt64(12, this.dayTime_);
        }
        if (this.weather_ != Weather.WEATHER_UNSPECIFIED.getNumber()) {
            output.writeEnum(13, this.weather_);
        }
        if (Float.floatToRawIntBits(this.health_) != 0) {
            output.writeFloat(14, this.health_);
        }
        if (Float.floatToRawIntBits(this.maxHealth_) != 0) {
            output.writeFloat(15, this.maxHealth_);
        }
        if (Float.floatToRawIntBits(this.foodLevel_) != 0) {
            output.writeFloat(16, this.foodLevel_);
        }
        if (Float.floatToRawIntBits(this.saturationLevel_) != 0) {
            output.writeFloat(17, this.saturationLevel_);
        }
        if ((this.bitField0_ & 8) != 0) {
            output.writeMessage(18, this.getLocalId());
        }
        this.getUnknownFields().writeTo(output);
    }

    @Override
    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize(1, this.getAuthor());
        }
        int dataSize = 0;
        for (int i = 0; i < this.states_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag(this.states_.getInt(i));
        }
        size += dataSize;
        if (!this.getStatesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag(dataSize);
        }
        this.statesMemoizedSerializedSize = dataSize;
        for (int i = 0; i < this.players_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize(3, this.players_.get(i));
        }
        if (!GeneratedMessage.isStringEmpty(this.dimension_)) {
            size += GeneratedMessage.computeStringSize(4, this.dimension_);
        }
        if (!GeneratedMessage.isStringEmpty(this.biome_)) {
            size += GeneratedMessage.computeStringSize(5, this.biome_);
        }
        if (Float.floatToRawIntBits(this.yaw_) != 0) {
            size += CodedOutputStream.computeFloatSize(6, this.yaw_);
        }
        if (Float.floatToRawIntBits(this.pitch_) != 0) {
            size += CodedOutputStream.computeFloatSize(7, this.pitch_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize(8, this.getPos());
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize(9, this.getSize());
        }
        if (this.perspective_ != Perspective.PERSPECTIVE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize(10, this.perspective_);
        }
        if (this.hasHud_) {
            size += CodedOutputStream.computeBoolSize(11, this.hasHud_);
        }
        if (this.dayTime_ != 0L) {
            size += CodedOutputStream.computeInt64Size(12, this.dayTime_);
        }
        if (this.weather_ != Weather.WEATHER_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize(13, this.weather_);
        }
        if (Float.floatToRawIntBits(this.health_) != 0) {
            size += CodedOutputStream.computeFloatSize(14, this.health_);
        }
        if (Float.floatToRawIntBits(this.maxHealth_) != 0) {
            size += CodedOutputStream.computeFloatSize(15, this.maxHealth_);
        }
        if (Float.floatToRawIntBits(this.foodLevel_) != 0) {
            size += CodedOutputStream.computeFloatSize(16, this.foodLevel_);
        }
        if (Float.floatToRawIntBits(this.saturationLevel_) != 0) {
            size += CodedOutputStream.computeFloatSize(17, this.saturationLevel_);
        }
        if ((this.bitField0_ & 8) != 0) {
            size += CodedOutputStream.computeMessageSize(18, this.getLocalId());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ScreenshotMessage)) {
            return super.equals(obj);
        }
        ScreenshotMessage other = (ScreenshotMessage)obj;
        if (this.hasAuthor() != other.hasAuthor()) {
            return false;
        }
        if (this.hasAuthor() && !this.getAuthor().equals(other.getAuthor())) {
            return false;
        }
        if (!this.states_.equals(other.states_)) {
            return false;
        }
        if (!this.getPlayersList().equals(other.getPlayersList())) {
            return false;
        }
        if (!this.getDimension().equals(other.getDimension())) {
            return false;
        }
        if (!this.getBiome().equals(other.getBiome())) {
            return false;
        }
        if (Float.floatToIntBits(this.getYaw()) != Float.floatToIntBits(other.getYaw())) {
            return false;
        }
        if (Float.floatToIntBits(this.getPitch()) != Float.floatToIntBits(other.getPitch())) {
            return false;
        }
        if (this.hasPos() != other.hasPos()) {
            return false;
        }
        if (this.hasPos() && !this.getPos().equals(other.getPos())) {
            return false;
        }
        if (this.hasSize() != other.hasSize()) {
            return false;
        }
        if (this.hasSize() && !this.getSize().equals(other.getSize())) {
            return false;
        }
        if (this.perspective_ != other.perspective_) {
            return false;
        }
        if (this.getHasHud() != other.getHasHud()) {
            return false;
        }
        if (this.getDayTime() != other.getDayTime()) {
            return false;
        }
        if (this.weather_ != other.weather_) {
            return false;
        }
        if (Float.floatToIntBits(this.getHealth()) != Float.floatToIntBits(other.getHealth())) {
            return false;
        }
        if (Float.floatToIntBits(this.getMaxHealth()) != Float.floatToIntBits(other.getMaxHealth())) {
            return false;
        }
        if (Float.floatToIntBits(this.getFoodLevel()) != Float.floatToIntBits(other.getFoodLevel())) {
            return false;
        }
        if (Float.floatToIntBits(this.getSaturationLevel()) != Float.floatToIntBits(other.getSaturationLevel())) {
            return false;
        }
        if (this.hasLocalId() != other.hasLocalId()) {
            return false;
        }
        if (this.hasLocalId() && !this.getLocalId().equals(other.getLocalId())) {
            return false;
        }
        return this.getUnknownFields().equals(other.getUnknownFields());
    }

    @Override
    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + ScreenshotMessage.getDescriptor().hashCode();
        if (this.hasAuthor()) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getAuthor().hashCode();
        }
        if (this.getStatesCount() > 0) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.states_.hashCode();
        }
        if (this.getPlayersCount() > 0) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getPlayersList().hashCode();
        }
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getDimension().hashCode();
        hash = 37 * hash + 5;
        hash = 53 * hash + this.getBiome().hashCode();
        hash = 37 * hash + 6;
        hash = 53 * hash + Float.floatToIntBits(this.getYaw());
        hash = 37 * hash + 7;
        hash = 53 * hash + Float.floatToIntBits(this.getPitch());
        if (this.hasPos()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getPos().hashCode();
        }
        if (this.hasSize()) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getSize().hashCode();
        }
        hash = 37 * hash + 10;
        hash = 53 * hash + this.perspective_;
        hash = 37 * hash + 11;
        hash = 53 * hash + Internal.hashBoolean(this.getHasHud());
        hash = 37 * hash + 12;
        hash = 53 * hash + Internal.hashLong(this.getDayTime());
        hash = 37 * hash + 13;
        hash = 53 * hash + this.weather_;
        hash = 37 * hash + 14;
        hash = 53 * hash + Float.floatToIntBits(this.getHealth());
        hash = 37 * hash + 15;
        hash = 53 * hash + Float.floatToIntBits(this.getMaxHealth());
        hash = 37 * hash + 16;
        hash = 53 * hash + Float.floatToIntBits(this.getFoodLevel());
        hash = 37 * hash + 17;
        hash = 53 * hash + Float.floatToIntBits(this.getSaturationLevel());
        if (this.hasLocalId()) {
            hash = 37 * hash + 18;
            hash = 53 * hash + this.getLocalId().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static ScreenshotMessage parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static ScreenshotMessage parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static ScreenshotMessage parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static ScreenshotMessage parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static ScreenshotMessage parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static ScreenshotMessage parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static ScreenshotMessage parseFrom(InputStream input) throws IOException {
        return GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static ScreenshotMessage parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessage.parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static ScreenshotMessage parseDelimitedFrom(InputStream input) throws IOException {
        return GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static ScreenshotMessage parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessage.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }

    public static ScreenshotMessage parseFrom(CodedInputStream input) throws IOException {
        return GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static ScreenshotMessage parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessage.parseWithIOException(PARSER, input, extensionRegistry);
    }

    @Override
    public Builder newBuilderForType() {
        return ScreenshotMessage.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ScreenshotMessage prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @Override
    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @Override
    protected Builder newBuilderForType(AbstractMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static ScreenshotMessage getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<ScreenshotMessage> parser() {
        return PARSER;
    }

    public Parser<ScreenshotMessage> getParserForType() {
        return PARSER;
    }

    @Override
    public ScreenshotMessage getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    static /* synthetic */ Internal.IntList access$300() {
        return ScreenshotMessage.emptyIntList();
    }

    static {
        RuntimeVersion.validateProtobufGencodeVersion(RuntimeVersion.RuntimeDomain.PUBLIC, 4, 30, 2, "", ScreenshotMessage.class.getName());
        states_converter_ = new Internal.IntListAdapter.IntConverter<PlayerState>(){

            @Override
            public PlayerState convert(int from) {
                PlayerState result2 = PlayerState.forNumber(from);
                return result2 == null ? PlayerState.UNRECOGNIZED : result2;
            }
        };
        DEFAULT_INSTANCE = new ScreenshotMessage();
        PARSER = new AbstractParser<ScreenshotMessage>(){

            @Override
            public ScreenshotMessage parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = ScreenshotMessage.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage(builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };
    }

    public static final class Builder
    extends GeneratedMessage.Builder<Builder>
    implements ScreenshotMessageOrBuilder {
        private int bitField0_;
        private UuidAndUsername author_;
        private SingleFieldBuilder<UuidAndUsername, UuidAndUsername.Builder, UuidAndUsernameOrBuilder> authorBuilder_;
        private Internal.IntList states_ = ScreenshotMessage.access$300();
        private List<ScreenshotPlayer> players_ = Collections.emptyList();
        private RepeatedFieldBuilder<ScreenshotPlayer, ScreenshotPlayer.Builder, ScreenshotPlayerOrBuilder> playersBuilder_;
        private Object dimension_ = "";
        private Object biome_ = "";
        private float yaw_;
        private float pitch_;
        private Vector3f pos_;
        private SingleFieldBuilder<Vector3f, Vector3f.Builder, Vector3fOrBuilder> posBuilder_;
        private Dimensions size_;
        private SingleFieldBuilder<Dimensions, Dimensions.Builder, DimensionsOrBuilder> sizeBuilder_;
        private int perspective_ = 0;
        private boolean hasHud_;
        private long dayTime_;
        private int weather_ = 0;
        private float health_;
        private float maxHealth_;
        private float foodLevel_;
        private float saturationLevel_;
        private Uuid localId_;
        private SingleFieldBuilder<Uuid, Uuid.Builder, UuidOrBuilder> localIdBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return CommonProto.internal_static_lunarclient_websocket_screenshot_v1_ScreenshotMessage_descriptor;
        }

        @Override
        protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
            return CommonProto.internal_static_lunarclient_websocket_screenshot_v1_ScreenshotMessage_fieldAccessorTable.ensureFieldAccessorsInitialized(ScreenshotMessage.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(AbstractMessage.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.internalGetAuthorFieldBuilder();
                this.internalGetPlayersFieldBuilder();
                this.internalGetPosFieldBuilder();
                this.internalGetSizeFieldBuilder();
                this.internalGetLocalIdFieldBuilder();
            }
        }

        @Override
        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.author_ = null;
            if (this.authorBuilder_ != null) {
                this.authorBuilder_.dispose();
                this.authorBuilder_ = null;
            }
            this.states_ = ScreenshotMessage.emptyIntList();
            this.bitField0_ &= 0xFFFFFFFD;
            if (this.playersBuilder_ == null) {
                this.players_ = Collections.emptyList();
            } else {
                this.players_ = null;
                this.playersBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFB;
            this.dimension_ = "";
            this.biome_ = "";
            this.yaw_ = 0.0f;
            this.pitch_ = 0.0f;
            this.pos_ = null;
            if (this.posBuilder_ != null) {
                this.posBuilder_.dispose();
                this.posBuilder_ = null;
            }
            this.size_ = null;
            if (this.sizeBuilder_ != null) {
                this.sizeBuilder_.dispose();
                this.sizeBuilder_ = null;
            }
            this.perspective_ = 0;
            this.hasHud_ = false;
            this.dayTime_ = 0L;
            this.weather_ = 0;
            this.health_ = 0.0f;
            this.maxHealth_ = 0.0f;
            this.foodLevel_ = 0.0f;
            this.saturationLevel_ = 0.0f;
            this.localId_ = null;
            if (this.localIdBuilder_ != null) {
                this.localIdBuilder_.dispose();
                this.localIdBuilder_ = null;
            }
            return this;
        }

        @Override
        public Descriptors.Descriptor getDescriptorForType() {
            return CommonProto.internal_static_lunarclient_websocket_screenshot_v1_ScreenshotMessage_descriptor;
        }

        @Override
        public ScreenshotMessage getDefaultInstanceForType() {
            return ScreenshotMessage.getDefaultInstance();
        }

        @Override
        public ScreenshotMessage build() {
            ScreenshotMessage result2 = this.buildPartial();
            if (!result2.isInitialized()) {
                throw Builder.newUninitializedMessageException(result2);
            }
            return result2;
        }

        @Override
        public ScreenshotMessage buildPartial() {
            ScreenshotMessage result2 = new ScreenshotMessage(this);
            this.buildPartialRepeatedFields(result2);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result2);
            }
            this.onBuilt();
            return result2;
        }

        private void buildPartialRepeatedFields(ScreenshotMessage result2) {
            if ((this.bitField0_ & 2) != 0) {
                this.states_.makeImmutable();
                this.bitField0_ &= 0xFFFFFFFD;
            }
            result2.states_ = this.states_;
            if (this.playersBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0) {
                    this.players_ = Collections.unmodifiableList(this.players_);
                    this.bitField0_ &= 0xFFFFFFFB;
                }
                result2.players_ = this.players_;
            } else {
                result2.players_ = this.playersBuilder_.build();
            }
        }

        private void buildPartial0(ScreenshotMessage result2) {
            int from_bitField0_ = this.bitField0_;
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 1) != 0) {
                result2.author_ = this.authorBuilder_ == null ? this.author_ : this.authorBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 8) != 0) {
                result2.dimension_ = this.dimension_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result2.biome_ = this.biome_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result2.yaw_ = this.yaw_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result2.pitch_ = this.pitch_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result2.pos_ = this.posBuilder_ == null ? this.pos_ : this.posBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result2.size_ = this.sizeBuilder_ == null ? this.size_ : this.sizeBuilder_.build();
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result2.perspective_ = this.perspective_;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result2.hasHud_ = this.hasHud_;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result2.dayTime_ = this.dayTime_;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result2.weather_ = this.weather_;
            }
            if ((from_bitField0_ & 0x2000) != 0) {
                result2.health_ = this.health_;
            }
            if ((from_bitField0_ & 0x4000) != 0) {
                result2.maxHealth_ = this.maxHealth_;
            }
            if ((from_bitField0_ & 0x8000) != 0) {
                result2.foodLevel_ = this.foodLevel_;
            }
            if ((from_bitField0_ & 0x10000) != 0) {
                result2.saturationLevel_ = this.saturationLevel_;
            }
            if ((from_bitField0_ & 0x20000) != 0) {
                result2.localId_ = this.localIdBuilder_ == null ? this.localId_ : this.localIdBuilder_.build();
                to_bitField0_ |= 8;
            }
            result2.bitField0_ |= to_bitField0_;
        }

        @Override
        public Builder mergeFrom(Message other) {
            if (other instanceof ScreenshotMessage) {
                return this.mergeFrom((ScreenshotMessage)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(ScreenshotMessage other) {
            if (other == ScreenshotMessage.getDefaultInstance()) {
                return this;
            }
            if (other.hasAuthor()) {
                this.mergeAuthor(other.getAuthor());
            }
            if (!other.states_.isEmpty()) {
                if (this.states_.isEmpty()) {
                    this.states_ = other.states_;
                    this.bitField0_ &= 0xFFFFFFFD;
                } else {
                    this.ensureStatesIsMutable();
                    this.states_.addAll(other.states_);
                }
                this.onChanged();
            }
            if (this.playersBuilder_ == null) {
                if (!other.players_.isEmpty()) {
                    if (this.players_.isEmpty()) {
                        this.players_ = other.players_;
                        this.bitField0_ &= 0xFFFFFFFB;
                    } else {
                        this.ensurePlayersIsMutable();
                        this.players_.addAll(other.players_);
                    }
                    this.onChanged();
                }
            } else if (!other.players_.isEmpty()) {
                if (this.playersBuilder_.isEmpty()) {
                    this.playersBuilder_.dispose();
                    this.playersBuilder_ = null;
                    this.players_ = other.players_;
                    this.bitField0_ &= 0xFFFFFFFB;
                    this.playersBuilder_ = alwaysUseFieldBuilders ? this.internalGetPlayersFieldBuilder() : null;
                } else {
                    this.playersBuilder_.addAllMessages(other.players_);
                }
            }
            if (!other.getDimension().isEmpty()) {
                this.dimension_ = other.dimension_;
                this.bitField0_ |= 8;
                this.onChanged();
            }
            if (!other.getBiome().isEmpty()) {
                this.biome_ = other.biome_;
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            if (Float.floatToRawIntBits(other.getYaw()) != 0) {
                this.setYaw(other.getYaw());
            }
            if (Float.floatToRawIntBits(other.getPitch()) != 0) {
                this.setPitch(other.getPitch());
            }
            if (other.hasPos()) {
                this.mergePos(other.getPos());
            }
            if (other.hasSize()) {
                this.mergeSize(other.getSize());
            }
            if (other.perspective_ != 0) {
                this.setPerspectiveValue(other.getPerspectiveValue());
            }
            if (other.getHasHud()) {
                this.setHasHud(other.getHasHud());
            }
            if (other.getDayTime() != 0L) {
                this.setDayTime(other.getDayTime());
            }
            if (other.weather_ != 0) {
                this.setWeatherValue(other.getWeatherValue());
            }
            if (Float.floatToRawIntBits(other.getHealth()) != 0) {
                this.setHealth(other.getHealth());
            }
            if (Float.floatToRawIntBits(other.getMaxHealth()) != 0) {
                this.setMaxHealth(other.getMaxHealth());
            }
            if (Float.floatToRawIntBits(other.getFoodLevel()) != 0) {
                this.setFoodLevel(other.getFoodLevel());
            }
            if (Float.floatToRawIntBits(other.getSaturationLevel()) != 0) {
                this.setSaturationLevel(other.getSaturationLevel());
            }
            if (other.hasLocalId()) {
                this.mergeLocalId(other.getLocalId());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        @Override
        public final boolean isInitialized() {
            return true;
        }

        @Override
        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block27: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block27;
                        }
                        case 10: {
                            input.readMessage(this.internalGetAuthorFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 1;
                            continue block27;
                        }
                        case 16: {
                            int tmpRaw = input.readEnum();
                            this.ensureStatesIsMutable();
                            this.states_.addInt(tmpRaw);
                            continue block27;
                        }
                        case 18: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int tmpRaw = input.readEnum();
                                this.ensureStatesIsMutable();
                                this.states_.addInt(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block27;
                        }
                        case 26: {
                            ScreenshotPlayer m = input.readMessage(ScreenshotPlayer.parser(), extensionRegistry);
                            if (this.playersBuilder_ == null) {
                                this.ensurePlayersIsMutable();
                                this.players_.add(m);
                                continue block27;
                            }
                            this.playersBuilder_.addMessage(m);
                            continue block27;
                        }
                        case 34: {
                            this.dimension_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 8;
                            continue block27;
                        }
                        case 42: {
                            this.biome_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x10;
                            continue block27;
                        }
                        case 53: {
                            this.yaw_ = input.readFloat();
                            this.bitField0_ |= 0x20;
                            continue block27;
                        }
                        case 61: {
                            this.pitch_ = input.readFloat();
                            this.bitField0_ |= 0x40;
                            continue block27;
                        }
                        case 66: {
                            input.readMessage(this.internalGetPosFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x80;
                            continue block27;
                        }
                        case 74: {
                            input.readMessage(this.internalGetSizeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x100;
                            continue block27;
                        }
                        case 80: {
                            this.perspective_ = input.readEnum();
                            this.bitField0_ |= 0x200;
                            continue block27;
                        }
                        case 88: {
                            this.hasHud_ = input.readBool();
                            this.bitField0_ |= 0x400;
                            continue block27;
                        }
                        case 96: {
                            this.dayTime_ = input.readInt64();
                            this.bitField0_ |= 0x800;
                            continue block27;
                        }
                        case 104: {
                            this.weather_ = input.readEnum();
                            this.bitField0_ |= 0x1000;
                            continue block27;
                        }
                        case 117: {
                            this.health_ = input.readFloat();
                            this.bitField0_ |= 0x2000;
                            continue block27;
                        }
                        case 125: {
                            this.maxHealth_ = input.readFloat();
                            this.bitField0_ |= 0x4000;
                            continue block27;
                        }
                        case 133: {
                            this.foodLevel_ = input.readFloat();
                            this.bitField0_ |= 0x8000;
                            continue block27;
                        }
                        case 141: {
                            this.saturationLevel_ = input.readFloat();
                            this.bitField0_ |= 0x10000;
                            continue block27;
                        }
                        case 146: {
                            input.readMessage(this.internalGetLocalIdFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x20000;
                            continue block27;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasAuthor() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public UuidAndUsername getAuthor() {
            if (this.authorBuilder_ == null) {
                return this.author_ == null ? UuidAndUsername.getDefaultInstance() : this.author_;
            }
            return this.authorBuilder_.getMessage();
        }

        public Builder setAuthor(UuidAndUsername value) {
            if (this.authorBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.author_ = value;
            } else {
                this.authorBuilder_.setMessage(value);
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder setAuthor(UuidAndUsername.Builder builderForValue) {
            if (this.authorBuilder_ == null) {
                this.author_ = builderForValue.build();
            } else {
                this.authorBuilder_.setMessage(builderForValue.build());
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder mergeAuthor(UuidAndUsername value) {
            if (this.authorBuilder_ == null) {
                if ((this.bitField0_ & 1) != 0 && this.author_ != null && this.author_ != UuidAndUsername.getDefaultInstance()) {
                    this.getAuthorBuilder().mergeFrom(value);
                } else {
                    this.author_ = value;
                }
            } else {
                this.authorBuilder_.mergeFrom(value);
            }
            if (this.author_ != null) {
                this.bitField0_ |= 1;
                this.onChanged();
            }
            return this;
        }

        public Builder clearAuthor() {
            this.bitField0_ &= 0xFFFFFFFE;
            this.author_ = null;
            if (this.authorBuilder_ != null) {
                this.authorBuilder_.dispose();
                this.authorBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public UuidAndUsername.Builder getAuthorBuilder() {
            this.bitField0_ |= 1;
            this.onChanged();
            return this.internalGetAuthorFieldBuilder().getBuilder();
        }

        @Override
        public UuidAndUsernameOrBuilder getAuthorOrBuilder() {
            if (this.authorBuilder_ != null) {
                return this.authorBuilder_.getMessageOrBuilder();
            }
            return this.author_ == null ? UuidAndUsername.getDefaultInstance() : this.author_;
        }

        private SingleFieldBuilder<UuidAndUsername, UuidAndUsername.Builder, UuidAndUsernameOrBuilder> internalGetAuthorFieldBuilder() {
            if (this.authorBuilder_ == null) {
                this.authorBuilder_ = new SingleFieldBuilder(this.getAuthor(), this.getParentForChildren(), this.isClean());
                this.author_ = null;
            }
            return this.authorBuilder_;
        }

        private void ensureStatesIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.states_ = (Internal.IntList)ScreenshotMessage.makeMutableCopy(this.states_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<PlayerState> getStatesList() {
            return new Internal.IntListAdapter<PlayerState>(this.states_, states_converter_);
        }

        @Override
        public int getStatesCount() {
            return this.states_.size();
        }

        @Override
        public PlayerState getStates(int index) {
            return states_converter_.convert(this.states_.getInt(index));
        }

        public Builder setStates(int index, PlayerState value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureStatesIsMutable();
            this.states_.setInt(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addStates(PlayerState value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureStatesIsMutable();
            this.states_.addInt(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllStates(Iterable<? extends PlayerState> values2) {
            this.ensureStatesIsMutable();
            for (PlayerState playerState : values2) {
                this.states_.addInt(playerState.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearStates() {
            this.states_ = ScreenshotMessage.emptyIntList();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getStatesValueList() {
            return Collections.unmodifiableList(this.states_);
        }

        @Override
        public int getStatesValue(int index) {
            return this.states_.getInt(index);
        }

        public Builder setStatesValue(int index, int value) {
            this.ensureStatesIsMutable();
            this.states_.setInt(index, value);
            this.onChanged();
            return this;
        }

        public Builder addStatesValue(int value) {
            this.ensureStatesIsMutable();
            this.states_.addInt(value);
            this.onChanged();
            return this;
        }

        public Builder addAllStatesValue(Iterable<Integer> values2) {
            this.ensureStatesIsMutable();
            for (int value : values2) {
                this.states_.addInt(value);
            }
            this.onChanged();
            return this;
        }

        private void ensurePlayersIsMutable() {
            if ((this.bitField0_ & 4) == 0) {
                this.players_ = new ArrayList<ScreenshotPlayer>(this.players_);
                this.bitField0_ |= 4;
            }
        }

        @Override
        public List<ScreenshotPlayer> getPlayersList() {
            if (this.playersBuilder_ == null) {
                return Collections.unmodifiableList(this.players_);
            }
            return this.playersBuilder_.getMessageList();
        }

        @Override
        public int getPlayersCount() {
            if (this.playersBuilder_ == null) {
                return this.players_.size();
            }
            return this.playersBuilder_.getCount();
        }

        @Override
        public ScreenshotPlayer getPlayers(int index) {
            if (this.playersBuilder_ == null) {
                return this.players_.get(index);
            }
            return this.playersBuilder_.getMessage(index);
        }

        public Builder setPlayers(int index, ScreenshotPlayer value) {
            if (this.playersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePlayersIsMutable();
                this.players_.set(index, value);
                this.onChanged();
            } else {
                this.playersBuilder_.setMessage(index, value);
            }
            return this;
        }

        public Builder setPlayers(int index, ScreenshotPlayer.Builder builderForValue) {
            if (this.playersBuilder_ == null) {
                this.ensurePlayersIsMutable();
                this.players_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.playersBuilder_.setMessage(index, builderForValue.build());
            }
            return this;
        }

        public Builder addPlayers(ScreenshotPlayer value) {
            if (this.playersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePlayersIsMutable();
                this.players_.add(value);
                this.onChanged();
            } else {
                this.playersBuilder_.addMessage(value);
            }
            return this;
        }

        public Builder addPlayers(int index, ScreenshotPlayer value) {
            if (this.playersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePlayersIsMutable();
                this.players_.add(index, value);
                this.onChanged();
            } else {
                this.playersBuilder_.addMessage(index, value);
            }
            return this;
        }

        public Builder addPlayers(ScreenshotPlayer.Builder builderForValue) {
            if (this.playersBuilder_ == null) {
                this.ensurePlayersIsMutable();
                this.players_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.playersBuilder_.addMessage(builderForValue.build());
            }
            return this;
        }

        public Builder addPlayers(int index, ScreenshotPlayer.Builder builderForValue) {
            if (this.playersBuilder_ == null) {
                this.ensurePlayersIsMutable();
                this.players_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.playersBuilder_.addMessage(index, builderForValue.build());
            }
            return this;
        }

        public Builder addAllPlayers(Iterable<? extends ScreenshotPlayer> values2) {
            if (this.playersBuilder_ == null) {
                this.ensurePlayersIsMutable();
                AbstractMessageLite.Builder.addAll(values2, this.players_);
                this.onChanged();
            } else {
                this.playersBuilder_.addAllMessages(values2);
            }
            return this;
        }

        public Builder clearPlayers() {
            if (this.playersBuilder_ == null) {
                this.players_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFB;
                this.onChanged();
            } else {
                this.playersBuilder_.clear();
            }
            return this;
        }

        public Builder removePlayers(int index) {
            if (this.playersBuilder_ == null) {
                this.ensurePlayersIsMutable();
                this.players_.remove(index);
                this.onChanged();
            } else {
                this.playersBuilder_.remove(index);
            }
            return this;
        }

        public ScreenshotPlayer.Builder getPlayersBuilder(int index) {
            return this.internalGetPlayersFieldBuilder().getBuilder(index);
        }

        @Override
        public ScreenshotPlayerOrBuilder getPlayersOrBuilder(int index) {
            if (this.playersBuilder_ == null) {
                return this.players_.get(index);
            }
            return this.playersBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends ScreenshotPlayerOrBuilder> getPlayersOrBuilderList() {
            if (this.playersBuilder_ != null) {
                return this.playersBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.players_);
        }

        public ScreenshotPlayer.Builder addPlayersBuilder() {
            return this.internalGetPlayersFieldBuilder().addBuilder(ScreenshotPlayer.getDefaultInstance());
        }

        public ScreenshotPlayer.Builder addPlayersBuilder(int index) {
            return this.internalGetPlayersFieldBuilder().addBuilder(index, ScreenshotPlayer.getDefaultInstance());
        }

        public List<ScreenshotPlayer.Builder> getPlayersBuilderList() {
            return this.internalGetPlayersFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilder<ScreenshotPlayer, ScreenshotPlayer.Builder, ScreenshotPlayerOrBuilder> internalGetPlayersFieldBuilder() {
            if (this.playersBuilder_ == null) {
                this.playersBuilder_ = new RepeatedFieldBuilder(this.players_, (this.bitField0_ & 4) != 0, this.getParentForChildren(), this.isClean());
                this.players_ = null;
            }
            return this.playersBuilder_;
        }

        @Override
        public String getDimension() {
            Object ref = this.dimension_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.dimension_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDimensionBytes() {
            Object ref = this.dimension_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.dimension_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDimension(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.dimension_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearDimension() {
            this.dimension_ = ScreenshotMessage.getDefaultInstance().getDimension();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder setDimensionBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ScreenshotMessage.checkByteStringIsUtf8(value);
            this.dimension_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public String getBiome() {
            Object ref = this.biome_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.biome_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getBiomeBytes() {
            Object ref = this.biome_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.biome_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setBiome(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.biome_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearBiome() {
            this.biome_ = ScreenshotMessage.getDefaultInstance().getBiome();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder setBiomeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ScreenshotMessage.checkByteStringIsUtf8(value);
            this.biome_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public float getYaw() {
            return this.yaw_;
        }

        public Builder setYaw(float value) {
            this.yaw_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearYaw() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.yaw_ = 0.0f;
            this.onChanged();
            return this;
        }

        @Override
        public float getPitch() {
            return this.pitch_;
        }

        public Builder setPitch(float value) {
            this.pitch_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearPitch() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.pitch_ = 0.0f;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasPos() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public Vector3f getPos() {
            if (this.posBuilder_ == null) {
                return this.pos_ == null ? Vector3f.getDefaultInstance() : this.pos_;
            }
            return this.posBuilder_.getMessage();
        }

        public Builder setPos(Vector3f value) {
            if (this.posBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.pos_ = value;
            } else {
                this.posBuilder_.setMessage(value);
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder setPos(Vector3f.Builder builderForValue) {
            if (this.posBuilder_ == null) {
                this.pos_ = builderForValue.build();
            } else {
                this.posBuilder_.setMessage(builderForValue.build());
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder mergePos(Vector3f value) {
            if (this.posBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0 && this.pos_ != null && this.pos_ != Vector3f.getDefaultInstance()) {
                    this.getPosBuilder().mergeFrom(value);
                } else {
                    this.pos_ = value;
                }
            } else {
                this.posBuilder_.mergeFrom(value);
            }
            if (this.pos_ != null) {
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            return this;
        }

        public Builder clearPos() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.pos_ = null;
            if (this.posBuilder_ != null) {
                this.posBuilder_.dispose();
                this.posBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Vector3f.Builder getPosBuilder() {
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this.internalGetPosFieldBuilder().getBuilder();
        }

        @Override
        public Vector3fOrBuilder getPosOrBuilder() {
            if (this.posBuilder_ != null) {
                return this.posBuilder_.getMessageOrBuilder();
            }
            return this.pos_ == null ? Vector3f.getDefaultInstance() : this.pos_;
        }

        private SingleFieldBuilder<Vector3f, Vector3f.Builder, Vector3fOrBuilder> internalGetPosFieldBuilder() {
            if (this.posBuilder_ == null) {
                this.posBuilder_ = new SingleFieldBuilder(this.getPos(), this.getParentForChildren(), this.isClean());
                this.pos_ = null;
            }
            return this.posBuilder_;
        }

        @Override
        public boolean hasSize() {
            return (this.bitField0_ & 0x100) != 0;
        }

        @Override
        public Dimensions getSize() {
            if (this.sizeBuilder_ == null) {
                return this.size_ == null ? Dimensions.getDefaultInstance() : this.size_;
            }
            return this.sizeBuilder_.getMessage();
        }

        public Builder setSize(Dimensions value) {
            if (this.sizeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.size_ = value;
            } else {
                this.sizeBuilder_.setMessage(value);
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder setSize(Dimensions.Builder builderForValue) {
            if (this.sizeBuilder_ == null) {
                this.size_ = builderForValue.build();
            } else {
                this.sizeBuilder_.setMessage(builderForValue.build());
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder mergeSize(Dimensions value) {
            if (this.sizeBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0 && this.size_ != null && this.size_ != Dimensions.getDefaultInstance()) {
                    this.getSizeBuilder().mergeFrom(value);
                } else {
                    this.size_ = value;
                }
            } else {
                this.sizeBuilder_.mergeFrom(value);
            }
            if (this.size_ != null) {
                this.bitField0_ |= 0x100;
                this.onChanged();
            }
            return this;
        }

        public Builder clearSize() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.size_ = null;
            if (this.sizeBuilder_ != null) {
                this.sizeBuilder_.dispose();
                this.sizeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Dimensions.Builder getSizeBuilder() {
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this.internalGetSizeFieldBuilder().getBuilder();
        }

        @Override
        public DimensionsOrBuilder getSizeOrBuilder() {
            if (this.sizeBuilder_ != null) {
                return this.sizeBuilder_.getMessageOrBuilder();
            }
            return this.size_ == null ? Dimensions.getDefaultInstance() : this.size_;
        }

        private SingleFieldBuilder<Dimensions, Dimensions.Builder, DimensionsOrBuilder> internalGetSizeFieldBuilder() {
            if (this.sizeBuilder_ == null) {
                this.sizeBuilder_ = new SingleFieldBuilder(this.getSize(), this.getParentForChildren(), this.isClean());
                this.size_ = null;
            }
            return this.sizeBuilder_;
        }

        @Override
        public int getPerspectiveValue() {
            return this.perspective_;
        }

        public Builder setPerspectiveValue(int value) {
            this.perspective_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        @Override
        public Perspective getPerspective() {
            Perspective result2 = Perspective.forNumber(this.perspective_);
            return result2 == null ? Perspective.UNRECOGNIZED : result2;
        }

        public Builder setPerspective(Perspective value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x200;
            this.perspective_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearPerspective() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.perspective_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getHasHud() {
            return this.hasHud_;
        }

        public Builder setHasHud(boolean value) {
            this.hasHud_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder clearHasHud() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.hasHud_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public long getDayTime() {
            return this.dayTime_;
        }

        public Builder setDayTime(long value) {
            this.dayTime_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder clearDayTime() {
            this.bitField0_ &= 0xFFFFF7FF;
            this.dayTime_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public int getWeatherValue() {
            return this.weather_;
        }

        public Builder setWeatherValue(int value) {
            this.weather_ = value;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        @Override
        public Weather getWeather() {
            Weather result2 = Weather.forNumber(this.weather_);
            return result2 == null ? Weather.UNRECOGNIZED : result2;
        }

        public Builder setWeather(Weather value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x1000;
            this.weather_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearWeather() {
            this.bitField0_ &= 0xFFFFEFFF;
            this.weather_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public float getHealth() {
            return this.health_;
        }

        public Builder setHealth(float value) {
            this.health_ = value;
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder clearHealth() {
            this.bitField0_ &= 0xFFFFDFFF;
            this.health_ = 0.0f;
            this.onChanged();
            return this;
        }

        @Override
        public float getMaxHealth() {
            return this.maxHealth_;
        }

        public Builder setMaxHealth(float value) {
            this.maxHealth_ = value;
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        public Builder clearMaxHealth() {
            this.bitField0_ &= 0xFFFFBFFF;
            this.maxHealth_ = 0.0f;
            this.onChanged();
            return this;
        }

        @Override
        public float getFoodLevel() {
            return this.foodLevel_;
        }

        public Builder setFoodLevel(float value) {
            this.foodLevel_ = value;
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        public Builder clearFoodLevel() {
            this.bitField0_ &= 0xFFFF7FFF;
            this.foodLevel_ = 0.0f;
            this.onChanged();
            return this;
        }

        @Override
        public float getSaturationLevel() {
            return this.saturationLevel_;
        }

        public Builder setSaturationLevel(float value) {
            this.saturationLevel_ = value;
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        public Builder clearSaturationLevel() {
            this.bitField0_ &= 0xFFFEFFFF;
            this.saturationLevel_ = 0.0f;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasLocalId() {
            return (this.bitField0_ & 0x20000) != 0;
        }

        @Override
        public Uuid getLocalId() {
            if (this.localIdBuilder_ == null) {
                return this.localId_ == null ? Uuid.getDefaultInstance() : this.localId_;
            }
            return this.localIdBuilder_.getMessage();
        }

        public Builder setLocalId(Uuid value) {
            if (this.localIdBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.localId_ = value;
            } else {
                this.localIdBuilder_.setMessage(value);
            }
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        public Builder setLocalId(Uuid.Builder builderForValue) {
            if (this.localIdBuilder_ == null) {
                this.localId_ = builderForValue.build();
            } else {
                this.localIdBuilder_.setMessage(builderForValue.build());
            }
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        public Builder mergeLocalId(Uuid value) {
            if (this.localIdBuilder_ == null) {
                if ((this.bitField0_ & 0x20000) != 0 && this.localId_ != null && this.localId_ != Uuid.getDefaultInstance()) {
                    this.getLocalIdBuilder().mergeFrom(value);
                } else {
                    this.localId_ = value;
                }
            } else {
                this.localIdBuilder_.mergeFrom(value);
            }
            if (this.localId_ != null) {
                this.bitField0_ |= 0x20000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearLocalId() {
            this.bitField0_ &= 0xFFFDFFFF;
            this.localId_ = null;
            if (this.localIdBuilder_ != null) {
                this.localIdBuilder_.dispose();
                this.localIdBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Uuid.Builder getLocalIdBuilder() {
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this.internalGetLocalIdFieldBuilder().getBuilder();
        }

        @Override
        public UuidOrBuilder getLocalIdOrBuilder() {
            if (this.localIdBuilder_ != null) {
                return this.localIdBuilder_.getMessageOrBuilder();
            }
            return this.localId_ == null ? Uuid.getDefaultInstance() : this.localId_;
        }

        private SingleFieldBuilder<Uuid, Uuid.Builder, UuidOrBuilder> internalGetLocalIdFieldBuilder() {
            if (this.localIdBuilder_ == null) {
                this.localIdBuilder_ = new SingleFieldBuilder(this.getLocalId(), this.getParentForChildren(), this.isClean());
                this.localId_ = null;
            }
            return this.localIdBuilder_;
        }
    }
}

