/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.websocket.chat.v2;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilder;
import com.google.protobuf.RuntimeVersion;
import com.google.protobuf.SingleFieldBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.lunarclient.common.v1.UuidAndUsername;
import com.lunarclient.common.v1.UuidAndUsernameOrBuilder;
import com.lunarclient.websocket.chat.v2.ChatMessage;
import com.lunarclient.websocket.chat.v2.ChatMessageOrBuilder;
import com.lunarclient.websocket.chat.v2.ChatOrBuilder;
import com.lunarclient.websocket.chat.v2.ChatRef;
import com.lunarclient.websocket.chat.v2.ChatRefOrBuilder;
import com.lunarclient.websocket.chat.v2.ChatType;
import com.lunarclient.websocket.chat.v2.CommonProto;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Chat
extends GeneratedMessage
implements ChatOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int CHAT_ID_FIELD_NUMBER = 1;
    private ChatRef chatId_;
    public static final int PARTICIPANTS_FIELD_NUMBER = 2;
    private List<UuidAndUsername> participants_;
    public static final int TYPE_FIELD_NUMBER = 3;
    private int type_ = 0;
    public static final int RECENT_MESSAGES_FIELD_NUMBER = 4;
    private List<ChatMessage> recentMessages_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final Chat DEFAULT_INSTANCE;
    private static final Parser<Chat> PARSER;

    private Chat(GeneratedMessage.Builder<?> builder) {
        super(builder);
    }

    private Chat() {
        this.participants_ = Collections.emptyList();
        this.type_ = 0;
        this.recentMessages_ = Collections.emptyList();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return CommonProto.internal_static_lunarclient_websocket_chat_v2_Chat_descriptor;
    }

    @Override
    protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
        return CommonProto.internal_static_lunarclient_websocket_chat_v2_Chat_fieldAccessorTable.ensureFieldAccessorsInitialized(Chat.class, Builder.class);
    }

    @Override
    public boolean hasChatId() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public ChatRef getChatId() {
        return this.chatId_ == null ? ChatRef.getDefaultInstance() : this.chatId_;
    }

    @Override
    public ChatRefOrBuilder getChatIdOrBuilder() {
        return this.chatId_ == null ? ChatRef.getDefaultInstance() : this.chatId_;
    }

    @Override
    public List<UuidAndUsername> getParticipantsList() {
        return this.participants_;
    }

    @Override
    public List<? extends UuidAndUsernameOrBuilder> getParticipantsOrBuilderList() {
        return this.participants_;
    }

    @Override
    public int getParticipantsCount() {
        return this.participants_.size();
    }

    @Override
    public UuidAndUsername getParticipants(int index) {
        return this.participants_.get(index);
    }

    @Override
    public UuidAndUsernameOrBuilder getParticipantsOrBuilder(int index) {
        return this.participants_.get(index);
    }

    @Override
    public int getTypeValue() {
        return this.type_;
    }

    @Override
    public ChatType getType() {
        ChatType result2 = ChatType.forNumber(this.type_);
        return result2 == null ? ChatType.UNRECOGNIZED : result2;
    }

    @Override
    public List<ChatMessage> getRecentMessagesList() {
        return this.recentMessages_;
    }

    @Override
    public List<? extends ChatMessageOrBuilder> getRecentMessagesOrBuilderList() {
        return this.recentMessages_;
    }

    @Override
    public int getRecentMessagesCount() {
        return this.recentMessages_.size();
    }

    @Override
    public ChatMessage getRecentMessages(int index) {
        return this.recentMessages_.get(index);
    }

    @Override
    public ChatMessageOrBuilder getRecentMessagesOrBuilder(int index) {
        return this.recentMessages_.get(index);
    }

    @Override
    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    @Override
    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(1, this.getChatId());
        }
        for (i = 0; i < this.participants_.size(); ++i) {
            output.writeMessage(2, this.participants_.get(i));
        }
        if (this.type_ != ChatType.CHAT_TYPE_UNSPECIFIED.getNumber()) {
            output.writeEnum(3, this.type_);
        }
        for (i = 0; i < this.recentMessages_.size(); ++i) {
            output.writeMessage(4, this.recentMessages_.get(i));
        }
        this.getUnknownFields().writeTo(output);
    }

    @Override
    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize(1, this.getChatId());
        }
        for (i = 0; i < this.participants_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize(2, this.participants_.get(i));
        }
        if (this.type_ != ChatType.CHAT_TYPE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize(3, this.type_);
        }
        for (i = 0; i < this.recentMessages_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize(4, this.recentMessages_.get(i));
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Chat)) {
            return super.equals(obj);
        }
        Chat other = (Chat)obj;
        if (this.hasChatId() != other.hasChatId()) {
            return false;
        }
        if (this.hasChatId() && !this.getChatId().equals(other.getChatId())) {
            return false;
        }
        if (!this.getParticipantsList().equals(other.getParticipantsList())) {
            return false;
        }
        if (this.type_ != other.type_) {
            return false;
        }
        if (!this.getRecentMessagesList().equals(other.getRecentMessagesList())) {
            return false;
        }
        return this.getUnknownFields().equals(other.getUnknownFields());
    }

    @Override
    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Chat.getDescriptor().hashCode();
        if (this.hasChatId()) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getChatId().hashCode();
        }
        if (this.getParticipantsCount() > 0) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getParticipantsList().hashCode();
        }
        hash = 37 * hash + 3;
        hash = 53 * hash + this.type_;
        if (this.getRecentMessagesCount() > 0) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getRecentMessagesList().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static Chat parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static Chat parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static Chat parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static Chat parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static Chat parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static Chat parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static Chat parseFrom(InputStream input) throws IOException {
        return GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static Chat parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessage.parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static Chat parseDelimitedFrom(InputStream input) throws IOException {
        return GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static Chat parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessage.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }

    public static Chat parseFrom(CodedInputStream input) throws IOException {
        return GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static Chat parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessage.parseWithIOException(PARSER, input, extensionRegistry);
    }

    @Override
    public Builder newBuilderForType() {
        return Chat.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Chat prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @Override
    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @Override
    protected Builder newBuilderForType(AbstractMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Chat getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Chat> parser() {
        return PARSER;
    }

    public Parser<Chat> getParserForType() {
        return PARSER;
    }

    @Override
    public Chat getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    static {
        RuntimeVersion.validateProtobufGencodeVersion(RuntimeVersion.RuntimeDomain.PUBLIC, 4, 30, 2, "", Chat.class.getName());
        DEFAULT_INSTANCE = new Chat();
        PARSER = new AbstractParser<Chat>(){

            @Override
            public Chat parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = Chat.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage(builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };
    }

    public static final class Builder
    extends GeneratedMessage.Builder<Builder>
    implements ChatOrBuilder {
        private int bitField0_;
        private ChatRef chatId_;
        private SingleFieldBuilder<ChatRef, ChatRef.Builder, ChatRefOrBuilder> chatIdBuilder_;
        private List<UuidAndUsername> participants_ = Collections.emptyList();
        private RepeatedFieldBuilder<UuidAndUsername, UuidAndUsername.Builder, UuidAndUsernameOrBuilder> participantsBuilder_;
        private int type_ = 0;
        private List<ChatMessage> recentMessages_ = Collections.emptyList();
        private RepeatedFieldBuilder<ChatMessage, ChatMessage.Builder, ChatMessageOrBuilder> recentMessagesBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return CommonProto.internal_static_lunarclient_websocket_chat_v2_Chat_descriptor;
        }

        @Override
        protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
            return CommonProto.internal_static_lunarclient_websocket_chat_v2_Chat_fieldAccessorTable.ensureFieldAccessorsInitialized(Chat.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(AbstractMessage.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.internalGetChatIdFieldBuilder();
                this.internalGetParticipantsFieldBuilder();
                this.internalGetRecentMessagesFieldBuilder();
            }
        }

        @Override
        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.chatId_ = null;
            if (this.chatIdBuilder_ != null) {
                this.chatIdBuilder_.dispose();
                this.chatIdBuilder_ = null;
            }
            if (this.participantsBuilder_ == null) {
                this.participants_ = Collections.emptyList();
            } else {
                this.participants_ = null;
                this.participantsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFD;
            this.type_ = 0;
            if (this.recentMessagesBuilder_ == null) {
                this.recentMessages_ = Collections.emptyList();
            } else {
                this.recentMessages_ = null;
                this.recentMessagesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFF7;
            return this;
        }

        @Override
        public Descriptors.Descriptor getDescriptorForType() {
            return CommonProto.internal_static_lunarclient_websocket_chat_v2_Chat_descriptor;
        }

        @Override
        public Chat getDefaultInstanceForType() {
            return Chat.getDefaultInstance();
        }

        @Override
        public Chat build() {
            Chat result2 = this.buildPartial();
            if (!result2.isInitialized()) {
                throw Builder.newUninitializedMessageException(result2);
            }
            return result2;
        }

        @Override
        public Chat buildPartial() {
            Chat result2 = new Chat(this);
            this.buildPartialRepeatedFields(result2);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result2);
            }
            this.onBuilt();
            return result2;
        }

        private void buildPartialRepeatedFields(Chat result2) {
            if (this.participantsBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0) {
                    this.participants_ = Collections.unmodifiableList(this.participants_);
                    this.bitField0_ &= 0xFFFFFFFD;
                }
                result2.participants_ = this.participants_;
            } else {
                result2.participants_ = this.participantsBuilder_.build();
            }
            if (this.recentMessagesBuilder_ == null) {
                if ((this.bitField0_ & 8) != 0) {
                    this.recentMessages_ = Collections.unmodifiableList(this.recentMessages_);
                    this.bitField0_ &= 0xFFFFFFF7;
                }
                result2.recentMessages_ = this.recentMessages_;
            } else {
                result2.recentMessages_ = this.recentMessagesBuilder_.build();
            }
        }

        private void buildPartial0(Chat result2) {
            int from_bitField0_ = this.bitField0_;
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 1) != 0) {
                result2.chatId_ = this.chatIdBuilder_ == null ? this.chatId_ : this.chatIdBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 4) != 0) {
                result2.type_ = this.type_;
            }
            result2.bitField0_ |= to_bitField0_;
        }

        @Override
        public Builder mergeFrom(Message other) {
            if (other instanceof Chat) {
                return this.mergeFrom((Chat)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Chat other) {
            if (other == Chat.getDefaultInstance()) {
                return this;
            }
            if (other.hasChatId()) {
                this.mergeChatId(other.getChatId());
            }
            if (this.participantsBuilder_ == null) {
                if (!other.participants_.isEmpty()) {
                    if (this.participants_.isEmpty()) {
                        this.participants_ = other.participants_;
                        this.bitField0_ &= 0xFFFFFFFD;
                    } else {
                        this.ensureParticipantsIsMutable();
                        this.participants_.addAll(other.participants_);
                    }
                    this.onChanged();
                }
            } else if (!other.participants_.isEmpty()) {
                if (this.participantsBuilder_.isEmpty()) {
                    this.participantsBuilder_.dispose();
                    this.participantsBuilder_ = null;
                    this.participants_ = other.participants_;
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.participantsBuilder_ = alwaysUseFieldBuilders ? this.internalGetParticipantsFieldBuilder() : null;
                } else {
                    this.participantsBuilder_.addAllMessages(other.participants_);
                }
            }
            if (other.type_ != 0) {
                this.setTypeValue(other.getTypeValue());
            }
            if (this.recentMessagesBuilder_ == null) {
                if (!other.recentMessages_.isEmpty()) {
                    if (this.recentMessages_.isEmpty()) {
                        this.recentMessages_ = other.recentMessages_;
                        this.bitField0_ &= 0xFFFFFFF7;
                    } else {
                        this.ensureRecentMessagesIsMutable();
                        this.recentMessages_.addAll(other.recentMessages_);
                    }
                    this.onChanged();
                }
            } else if (!other.recentMessages_.isEmpty()) {
                if (this.recentMessagesBuilder_.isEmpty()) {
                    this.recentMessagesBuilder_.dispose();
                    this.recentMessagesBuilder_ = null;
                    this.recentMessages_ = other.recentMessages_;
                    this.bitField0_ &= 0xFFFFFFF7;
                    this.recentMessagesBuilder_ = alwaysUseFieldBuilders ? this.internalGetRecentMessagesFieldBuilder() : null;
                } else {
                    this.recentMessagesBuilder_.addAllMessages(other.recentMessages_);
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        @Override
        public final boolean isInitialized() {
            return true;
        }

        @Override
        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block12: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block12;
                        }
                        case 10: {
                            input.readMessage(this.internalGetChatIdFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 1;
                            continue block12;
                        }
                        case 18: {
                            GeneratedMessage m = input.readMessage(UuidAndUsername.parser(), extensionRegistry);
                            if (this.participantsBuilder_ == null) {
                                this.ensureParticipantsIsMutable();
                                this.participants_.add((UuidAndUsername)m);
                                continue block12;
                            }
                            this.participantsBuilder_.addMessage((UuidAndUsername)m);
                            continue block12;
                        }
                        case 24: {
                            this.type_ = input.readEnum();
                            this.bitField0_ |= 4;
                            continue block12;
                        }
                        case 34: {
                            GeneratedMessage m = input.readMessage(ChatMessage.parser(), extensionRegistry);
                            if (this.recentMessagesBuilder_ == null) {
                                this.ensureRecentMessagesIsMutable();
                                this.recentMessages_.add((ChatMessage)m);
                                continue block12;
                            }
                            this.recentMessagesBuilder_.addMessage((ChatMessage)m);
                            continue block12;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasChatId() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public ChatRef getChatId() {
            if (this.chatIdBuilder_ == null) {
                return this.chatId_ == null ? ChatRef.getDefaultInstance() : this.chatId_;
            }
            return this.chatIdBuilder_.getMessage();
        }

        public Builder setChatId(ChatRef value) {
            if (this.chatIdBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.chatId_ = value;
            } else {
                this.chatIdBuilder_.setMessage(value);
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder setChatId(ChatRef.Builder builderForValue) {
            if (this.chatIdBuilder_ == null) {
                this.chatId_ = builderForValue.build();
            } else {
                this.chatIdBuilder_.setMessage(builderForValue.build());
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder mergeChatId(ChatRef value) {
            if (this.chatIdBuilder_ == null) {
                if ((this.bitField0_ & 1) != 0 && this.chatId_ != null && this.chatId_ != ChatRef.getDefaultInstance()) {
                    this.getChatIdBuilder().mergeFrom(value);
                } else {
                    this.chatId_ = value;
                }
            } else {
                this.chatIdBuilder_.mergeFrom(value);
            }
            if (this.chatId_ != null) {
                this.bitField0_ |= 1;
                this.onChanged();
            }
            return this;
        }

        public Builder clearChatId() {
            this.bitField0_ &= 0xFFFFFFFE;
            this.chatId_ = null;
            if (this.chatIdBuilder_ != null) {
                this.chatIdBuilder_.dispose();
                this.chatIdBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public ChatRef.Builder getChatIdBuilder() {
            this.bitField0_ |= 1;
            this.onChanged();
            return this.internalGetChatIdFieldBuilder().getBuilder();
        }

        @Override
        public ChatRefOrBuilder getChatIdOrBuilder() {
            if (this.chatIdBuilder_ != null) {
                return this.chatIdBuilder_.getMessageOrBuilder();
            }
            return this.chatId_ == null ? ChatRef.getDefaultInstance() : this.chatId_;
        }

        private SingleFieldBuilder<ChatRef, ChatRef.Builder, ChatRefOrBuilder> internalGetChatIdFieldBuilder() {
            if (this.chatIdBuilder_ == null) {
                this.chatIdBuilder_ = new SingleFieldBuilder(this.getChatId(), this.getParentForChildren(), this.isClean());
                this.chatId_ = null;
            }
            return this.chatIdBuilder_;
        }

        private void ensureParticipantsIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.participants_ = new ArrayList<UuidAndUsername>(this.participants_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<UuidAndUsername> getParticipantsList() {
            if (this.participantsBuilder_ == null) {
                return Collections.unmodifiableList(this.participants_);
            }
            return this.participantsBuilder_.getMessageList();
        }

        @Override
        public int getParticipantsCount() {
            if (this.participantsBuilder_ == null) {
                return this.participants_.size();
            }
            return this.participantsBuilder_.getCount();
        }

        @Override
        public UuidAndUsername getParticipants(int index) {
            if (this.participantsBuilder_ == null) {
                return this.participants_.get(index);
            }
            return this.participantsBuilder_.getMessage(index);
        }

        public Builder setParticipants(int index, UuidAndUsername value) {
            if (this.participantsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureParticipantsIsMutable();
                this.participants_.set(index, value);
                this.onChanged();
            } else {
                this.participantsBuilder_.setMessage(index, value);
            }
            return this;
        }

        public Builder setParticipants(int index, UuidAndUsername.Builder builderForValue) {
            if (this.participantsBuilder_ == null) {
                this.ensureParticipantsIsMutable();
                this.participants_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.participantsBuilder_.setMessage(index, builderForValue.build());
            }
            return this;
        }

        public Builder addParticipants(UuidAndUsername value) {
            if (this.participantsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureParticipantsIsMutable();
                this.participants_.add(value);
                this.onChanged();
            } else {
                this.participantsBuilder_.addMessage(value);
            }
            return this;
        }

        public Builder addParticipants(int index, UuidAndUsername value) {
            if (this.participantsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureParticipantsIsMutable();
                this.participants_.add(index, value);
                this.onChanged();
            } else {
                this.participantsBuilder_.addMessage(index, value);
            }
            return this;
        }

        public Builder addParticipants(UuidAndUsername.Builder builderForValue) {
            if (this.participantsBuilder_ == null) {
                this.ensureParticipantsIsMutable();
                this.participants_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.participantsBuilder_.addMessage(builderForValue.build());
            }
            return this;
        }

        public Builder addParticipants(int index, UuidAndUsername.Builder builderForValue) {
            if (this.participantsBuilder_ == null) {
                this.ensureParticipantsIsMutable();
                this.participants_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.participantsBuilder_.addMessage(index, builderForValue.build());
            }
            return this;
        }

        public Builder addAllParticipants(Iterable<? extends UuidAndUsername> values2) {
            if (this.participantsBuilder_ == null) {
                this.ensureParticipantsIsMutable();
                AbstractMessageLite.Builder.addAll(values2, this.participants_);
                this.onChanged();
            } else {
                this.participantsBuilder_.addAllMessages(values2);
            }
            return this;
        }

        public Builder clearParticipants() {
            if (this.participantsBuilder_ == null) {
                this.participants_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
            } else {
                this.participantsBuilder_.clear();
            }
            return this;
        }

        public Builder removeParticipants(int index) {
            if (this.participantsBuilder_ == null) {
                this.ensureParticipantsIsMutable();
                this.participants_.remove(index);
                this.onChanged();
            } else {
                this.participantsBuilder_.remove(index);
            }
            return this;
        }

        public UuidAndUsername.Builder getParticipantsBuilder(int index) {
            return this.internalGetParticipantsFieldBuilder().getBuilder(index);
        }

        @Override
        public UuidAndUsernameOrBuilder getParticipantsOrBuilder(int index) {
            if (this.participantsBuilder_ == null) {
                return this.participants_.get(index);
            }
            return this.participantsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends UuidAndUsernameOrBuilder> getParticipantsOrBuilderList() {
            if (this.participantsBuilder_ != null) {
                return this.participantsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.participants_);
        }

        public UuidAndUsername.Builder addParticipantsBuilder() {
            return this.internalGetParticipantsFieldBuilder().addBuilder(UuidAndUsername.getDefaultInstance());
        }

        public UuidAndUsername.Builder addParticipantsBuilder(int index) {
            return this.internalGetParticipantsFieldBuilder().addBuilder(index, UuidAndUsername.getDefaultInstance());
        }

        public List<UuidAndUsername.Builder> getParticipantsBuilderList() {
            return this.internalGetParticipantsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilder<UuidAndUsername, UuidAndUsername.Builder, UuidAndUsernameOrBuilder> internalGetParticipantsFieldBuilder() {
            if (this.participantsBuilder_ == null) {
                this.participantsBuilder_ = new RepeatedFieldBuilder(this.participants_, (this.bitField0_ & 2) != 0, this.getParentForChildren(), this.isClean());
                this.participants_ = null;
            }
            return this.participantsBuilder_;
        }

        @Override
        public int getTypeValue() {
            return this.type_;
        }

        public Builder setTypeValue(int value) {
            this.type_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public ChatType getType() {
            ChatType result2 = ChatType.forNumber(this.type_);
            return result2 == null ? ChatType.UNRECOGNIZED : result2;
        }

        public Builder setType(ChatType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 4;
            this.type_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearType() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.type_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureRecentMessagesIsMutable() {
            if ((this.bitField0_ & 8) == 0) {
                this.recentMessages_ = new ArrayList<ChatMessage>(this.recentMessages_);
                this.bitField0_ |= 8;
            }
        }

        @Override
        public List<ChatMessage> getRecentMessagesList() {
            if (this.recentMessagesBuilder_ == null) {
                return Collections.unmodifiableList(this.recentMessages_);
            }
            return this.recentMessagesBuilder_.getMessageList();
        }

        @Override
        public int getRecentMessagesCount() {
            if (this.recentMessagesBuilder_ == null) {
                return this.recentMessages_.size();
            }
            return this.recentMessagesBuilder_.getCount();
        }

        @Override
        public ChatMessage getRecentMessages(int index) {
            if (this.recentMessagesBuilder_ == null) {
                return this.recentMessages_.get(index);
            }
            return this.recentMessagesBuilder_.getMessage(index);
        }

        public Builder setRecentMessages(int index, ChatMessage value) {
            if (this.recentMessagesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRecentMessagesIsMutable();
                this.recentMessages_.set(index, value);
                this.onChanged();
            } else {
                this.recentMessagesBuilder_.setMessage(index, value);
            }
            return this;
        }

        public Builder setRecentMessages(int index, ChatMessage.Builder builderForValue) {
            if (this.recentMessagesBuilder_ == null) {
                this.ensureRecentMessagesIsMutable();
                this.recentMessages_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.recentMessagesBuilder_.setMessage(index, builderForValue.build());
            }
            return this;
        }

        public Builder addRecentMessages(ChatMessage value) {
            if (this.recentMessagesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRecentMessagesIsMutable();
                this.recentMessages_.add(value);
                this.onChanged();
            } else {
                this.recentMessagesBuilder_.addMessage(value);
            }
            return this;
        }

        public Builder addRecentMessages(int index, ChatMessage value) {
            if (this.recentMessagesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRecentMessagesIsMutable();
                this.recentMessages_.add(index, value);
                this.onChanged();
            } else {
                this.recentMessagesBuilder_.addMessage(index, value);
            }
            return this;
        }

        public Builder addRecentMessages(ChatMessage.Builder builderForValue) {
            if (this.recentMessagesBuilder_ == null) {
                this.ensureRecentMessagesIsMutable();
                this.recentMessages_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.recentMessagesBuilder_.addMessage(builderForValue.build());
            }
            return this;
        }

        public Builder addRecentMessages(int index, ChatMessage.Builder builderForValue) {
            if (this.recentMessagesBuilder_ == null) {
                this.ensureRecentMessagesIsMutable();
                this.recentMessages_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.recentMessagesBuilder_.addMessage(index, builderForValue.build());
            }
            return this;
        }

        public Builder addAllRecentMessages(Iterable<? extends ChatMessage> values2) {
            if (this.recentMessagesBuilder_ == null) {
                this.ensureRecentMessagesIsMutable();
                AbstractMessageLite.Builder.addAll(values2, this.recentMessages_);
                this.onChanged();
            } else {
                this.recentMessagesBuilder_.addAllMessages(values2);
            }
            return this;
        }

        public Builder clearRecentMessages() {
            if (this.recentMessagesBuilder_ == null) {
                this.recentMessages_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFF7;
                this.onChanged();
            } else {
                this.recentMessagesBuilder_.clear();
            }
            return this;
        }

        public Builder removeRecentMessages(int index) {
            if (this.recentMessagesBuilder_ == null) {
                this.ensureRecentMessagesIsMutable();
                this.recentMessages_.remove(index);
                this.onChanged();
            } else {
                this.recentMessagesBuilder_.remove(index);
            }
            return this;
        }

        public ChatMessage.Builder getRecentMessagesBuilder(int index) {
            return this.internalGetRecentMessagesFieldBuilder().getBuilder(index);
        }

        @Override
        public ChatMessageOrBuilder getRecentMessagesOrBuilder(int index) {
            if (this.recentMessagesBuilder_ == null) {
                return this.recentMessages_.get(index);
            }
            return this.recentMessagesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends ChatMessageOrBuilder> getRecentMessagesOrBuilderList() {
            if (this.recentMessagesBuilder_ != null) {
                return this.recentMessagesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.recentMessages_);
        }

        public ChatMessage.Builder addRecentMessagesBuilder() {
            return this.internalGetRecentMessagesFieldBuilder().addBuilder(ChatMessage.getDefaultInstance());
        }

        public ChatMessage.Builder addRecentMessagesBuilder(int index) {
            return this.internalGetRecentMessagesFieldBuilder().addBuilder(index, ChatMessage.getDefaultInstance());
        }

        public List<ChatMessage.Builder> getRecentMessagesBuilderList() {
            return this.internalGetRecentMessagesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilder<ChatMessage, ChatMessage.Builder, ChatMessageOrBuilder> internalGetRecentMessagesFieldBuilder() {
            if (this.recentMessagesBuilder_ == null) {
                this.recentMessagesBuilder_ = new RepeatedFieldBuilder(this.recentMessages_, (this.bitField0_ & 8) != 0, this.getParentForChildren(), this.isClean());
                this.recentMessages_ = null;
            }
            return this.recentMessagesBuilder_;
        }
    }
}

