/*
 * Decompiled with CFR 0.152.
 */
package co.gongzh.procbridge;

import co.gongzh.procbridge.IDelegate;
import co.gongzh.procbridge.Protocol;
import co.gongzh.procbridge.ServerException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lco/gongzh/procbridge/Server;", "", "port", "", "delegate", "Lco/gongzh/procbridge/IDelegate;", "<init>", "(ILco/gongzh/procbridge/IDelegate;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "serverSocket", "Ljava/net/ServerSocket;", "value", "", "isStarted", "()Z", "logger", "Ljava/io/PrintStream;", "getLogger", "()Ljava/io/PrintStream;", "setLogger", "(Ljava/io/PrintStream;)V", "start", "", "stop", "Connection", "celestial"})
@SourceDebugExtension(value={"SMAP\nServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Server.kt\nco/gongzh/procbridge/Server\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1#2:105\n*E\n"})
public final class Server {
    private final int port;
    @NotNull
    private final IDelegate delegate;
    @Nullable
    private ExecutorService executor;
    @Nullable
    private ServerSocket serverSocket;
    private boolean isStarted;
    @Nullable
    private PrintStream logger;

    public Server(int port, @NotNull IDelegate delegate) {
        Intrinsics.checkNotNullParameter(delegate, "delegate");
        this.port = port;
        this.delegate = delegate;
        this.logger = System.err;
    }

    public final synchronized boolean isStarted() {
        return this.isStarted;
    }

    @Nullable
    public final PrintStream getLogger() {
        return this.logger;
    }

    public final void setLogger(@Nullable PrintStream printStream) {
        this.logger = printStream;
    }

    public final synchronized void start() {
        ExecutorService executor;
        if (!(!this.isStarted)) {
            boolean $i$a$-check-Server$start$22 = false;
            String $i$a$-check-Server$start$22 = "server already started";
            throw new IllegalStateException($i$a$-check-Server$start$22.toString());
        }
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(this.port);
        }
        catch (IOException e) {
            throw new ServerException(e);
        }
        this.serverSocket = serverSocket;
        this.executor = executor = Executors.newCachedThreadPool();
        executor.execute(() -> Server.start$lambda$2(serverSocket, this, executor));
        this.isStarted = true;
    }

    public final synchronized void stop() {
        boolean bl = this.isStarted;
        if (!bl) {
            boolean bl2 = false;
            String string = "server does not started";
            throw new IllegalStateException(string.toString());
        }
        ExecutorService executorService = this.executor;
        Intrinsics.checkNotNull(executorService);
        executorService.shutdown();
        this.executor = null;
        try {
            ServerSocket serverSocket = this.serverSocket;
            Intrinsics.checkNotNull(serverSocket);
            serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.serverSocket = null;
        this.isStarted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void start$lambda$2(ServerSocket $serverSocket, Server this$0, ExecutorService $executor) {
        while (true) {
            try {
                Socket socket = $serverSocket.accept();
                Intrinsics.checkNotNull(socket);
                Connection conn = this$0.new Connection(socket, this$0.delegate);
                Server server = this$0;
                synchronized (server) {
                    boolean bl = false;
                    if (!this$0.isStarted) {
                        return;
                    }
                    $executor.execute(conn);
                    Unit unit = Unit.INSTANCE;
                }
            }
            catch (IOException ignored) {
                return;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lco/gongzh/procbridge/Server$Connection;", "Ljava/lang/Runnable;", "socket", "Ljava/net/Socket;", "delegate", "Lco/gongzh/procbridge/IDelegate;", "<init>", "(Lco/gongzh/procbridge/Server;Ljava/net/Socket;Lco/gongzh/procbridge/IDelegate;)V", "run", "", "celestial"})
    public final class Connection
    implements Runnable {
        @NotNull
        private final Socket socket;
        @NotNull
        private final IDelegate delegate;

        public Connection(@NotNull Socket socket, IDelegate delegate) {
            Intrinsics.checkNotNullParameter(socket, "socket");
            Intrinsics.checkNotNullParameter(delegate, "delegate");
            this.socket = socket;
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block17: {
                try {
                    Closeable closeable = this.socket.getOutputStream();
                    Throwable throwable = null;
                    try {
                        OutputStream os = (OutputStream)closeable;
                        boolean bl = false;
                        Closeable closeable2 = this.socket.getInputStream();
                        Throwable throwable2 = null;
                        try {
                            InputStream is = (InputStream)closeable2;
                            boolean bl2 = false;
                            Intrinsics.checkNotNull(is);
                            Map.Entry<String, Object> req = Protocol.INSTANCE.readRequest(is);
                            String method = req.getKey();
                            Object payload = req.getValue();
                            Object result2 = null;
                            Exception exception = null;
                            try {
                                result2 = this.delegate.handleRequest(method, payload);
                            }
                            catch (Exception ex) {
                                exception = ex;
                            }
                            if (exception != null) {
                                Intrinsics.checkNotNull(os);
                                Protocol.INSTANCE.writeBadResponse(os, exception.getMessage());
                            } else {
                                Intrinsics.checkNotNull(os);
                                Protocol.INSTANCE.writeGoodResponse(os, result2);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally(closeable2, throwable2);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable, throwable);
                    }
                }
                catch (Exception ex) {
                    if (Server.this.getLogger() == null) break block17;
                    ex.printStackTrace(Server.this.getLogger());
                }
            }
        }
    }
}

