/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.digest;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.digest.DigestAlgorithm;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;

public class Digester
implements Serializable {
    private static final long serialVersionUID = 1L;
    private MessageDigest digest;
    protected byte[] salt;
    protected int saltPosition;
    protected int digestCount;

    public Digester(DigestAlgorithm algorithm) {
        this(algorithm.getValue());
    }

    public Digester(String algorithm) {
        this(algorithm, null);
    }

    public Digester(DigestAlgorithm algorithm, Provider provider) {
        this.init(algorithm.getValue(), provider);
    }

    public Digester(String algorithm, Provider provider) {
        this.init(algorithm, provider);
    }

    public Digester(MessageDigest messageDigest) {
        this.digest = messageDigest;
    }

    public Digester init(String algorithm, Provider provider) {
        if (null == provider) {
            this.digest = SecureUtil.createMessageDigest(algorithm);
        } else {
            try {
                this.digest = MessageDigest.getInstance(algorithm, provider);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CryptoException(e);
            }
        }
        return this;
    }

    public Digester setSalt(byte[] salt) {
        this.salt = salt;
        return this;
    }

    public Digester setSaltPosition(int saltPosition) {
        this.saltPosition = saltPosition;
        return this;
    }

    public Digester setDigestCount(int digestCount) {
        this.digestCount = digestCount;
        return this;
    }

    public Digester reset() {
        this.digest.reset();
        return this;
    }

    public byte[] digest(String data, String charsetName) {
        return this.digest(data, CharsetUtil.charset(charsetName));
    }

    public byte[] digest(String data, Charset charset) {
        return this.digest(StrUtil.bytes((CharSequence)data, charset));
    }

    public byte[] digest(String data) {
        return this.digest(data, CharsetUtil.CHARSET_UTF_8);
    }

    public String digestHex(String data, String charsetName) {
        return this.digestHex(data, CharsetUtil.charset(charsetName));
    }

    public String digestHex(String data, Charset charset) {
        return HexUtil.encodeHexStr(this.digest(data, charset));
    }

    public String digestHex(String data) {
        return this.digestHex(data, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digest(File file) throws CryptoException {
        BufferedInputStream in = null;
        try {
            in = FileUtil.getInputStream(file);
            byte[] byArray = this.digest(in);
            return byArray;
        }
        finally {
            IoUtil.close(in);
        }
    }

    public String digestHex(File file) {
        return HexUtil.encodeHexStr(this.digest(file));
    }

    public byte[] digest(byte[] data) {
        byte[] result2;
        if (this.saltPosition <= 0) {
            result2 = this.doDigest(this.salt, data);
        } else if (this.saltPosition >= data.length) {
            result2 = this.doDigest(data, this.salt);
        } else if (ArrayUtil.isNotEmpty(this.salt)) {
            this.digest.update(data, 0, this.saltPosition);
            this.digest.update(this.salt);
            this.digest.update(data, this.saltPosition, data.length - this.saltPosition);
            result2 = this.digest.digest();
        } else {
            result2 = this.doDigest(new byte[][]{data});
        }
        return this.resetAndRepeatDigest(result2);
    }

    public String digestHex(byte[] data) {
        return HexUtil.encodeHexStr(this.digest(data));
    }

    public byte[] digest(InputStream data) {
        return this.digest(data, 8192);
    }

    public String digestHex(InputStream data) {
        return HexUtil.encodeHexStr(this.digest(data));
    }

    public byte[] digest(InputStream data, int bufferLength) throws IORuntimeException {
        byte[] result2;
        if (bufferLength < 1) {
            bufferLength = 8192;
        }
        try {
            result2 = ArrayUtil.isEmpty(this.salt) ? this.digestWithoutSalt(data, bufferLength) : this.digestWithSalt(data, bufferLength);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return this.resetAndRepeatDigest(result2);
    }

    public String digestHex(InputStream data, int bufferLength) {
        return HexUtil.encodeHexStr(this.digest(data, bufferLength));
    }

    public MessageDigest getDigest() {
        return this.digest;
    }

    public int getDigestLength() {
        return this.digest.getDigestLength();
    }

    private byte[] digestWithoutSalt(InputStream data, int bufferLength) throws IOException {
        int read;
        byte[] buffer = new byte[bufferLength];
        while ((read = data.read(buffer, 0, bufferLength)) > -1) {
            this.digest.update(buffer, 0, read);
        }
        return this.digest.digest();
    }

    private byte[] digestWithSalt(InputStream data, int bufferLength) throws IOException {
        int read;
        if (this.saltPosition <= 0) {
            this.digest.update(this.salt);
        }
        byte[] buffer = new byte[bufferLength];
        int total = 0;
        while ((read = data.read(buffer, 0, bufferLength)) > -1) {
            if (this.saltPosition > 0 && (total += read) >= this.saltPosition) {
                if (total != this.saltPosition) {
                    this.digest.update(buffer, 0, total - this.saltPosition);
                }
                this.digest.update(this.salt);
                this.digest.update(buffer, total - this.saltPosition, read);
                continue;
            }
            this.digest.update(buffer, 0, read);
        }
        if (total < this.saltPosition) {
            this.digest.update(this.salt);
        }
        return this.digest.digest();
    }

    private byte[] doDigest(byte[] ... datas) {
        for (byte[] data : datas) {
            if (null == data) continue;
            this.digest.update(data);
        }
        return this.digest.digest();
    }

    private byte[] resetAndRepeatDigest(byte[] digestData) {
        int digestCount = Math.max(1, this.digestCount);
        this.reset();
        for (int i = 0; i < digestCount - 1; ++i) {
            digestData = this.doDigest(new byte[][]{digestData});
            this.reset();
        }
        return digestData;
    }
}

