/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Pid;
import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class RuntimeUtil {
    public static String execForStr(String ... cmds) throws IORuntimeException {
        return RuntimeUtil.execForStr(CharsetUtil.systemCharset(), cmds);
    }

    public static String execForStr(Charset charset, String ... cmds) throws IORuntimeException {
        return RuntimeUtil.getResult(RuntimeUtil.exec(cmds), charset);
    }

    public static List<String> execForLines(String ... cmds) throws IORuntimeException {
        return RuntimeUtil.execForLines(CharsetUtil.systemCharset(), cmds);
    }

    public static List<String> execForLines(Charset charset, String ... cmds) throws IORuntimeException {
        return RuntimeUtil.getResultLines(RuntimeUtil.exec(cmds), charset);
    }

    public static Process exec(String ... cmds) {
        Process process;
        try {
            process = new ProcessBuilder(RuntimeUtil.handleCmds(cmds)).redirectErrorStream(true).start();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return process;
    }

    public static Process exec(String[] envp, String ... cmds) {
        return RuntimeUtil.exec(envp, null, cmds);
    }

    public static Process exec(String[] envp, File dir, String ... cmds) {
        try {
            return Runtime.getRuntime().exec(RuntimeUtil.handleCmds(cmds), envp, dir);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static List<String> getResultLines(Process process) {
        return RuntimeUtil.getResultLines(process, CharsetUtil.systemCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getResultLines(Process process, Charset charset) {
        InputStream in = null;
        try {
            in = process.getInputStream();
            List list = IoUtil.readLines(in, charset, new ArrayList());
            return list;
        }
        finally {
            IoUtil.close(in);
            RuntimeUtil.destroy(process);
        }
    }

    public static String getResult(Process process) {
        return RuntimeUtil.getResult(process, CharsetUtil.systemCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResult(Process process, Charset charset) {
        InputStream in = null;
        try {
            in = process.getInputStream();
            String string = IoUtil.read(in, charset);
            return string;
        }
        finally {
            IoUtil.close(in);
            RuntimeUtil.destroy(process);
        }
    }

    public static String getErrorResult(Process process) {
        return RuntimeUtil.getErrorResult(process, CharsetUtil.systemCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getErrorResult(Process process, Charset charset) {
        InputStream in = null;
        try {
            in = process.getErrorStream();
            String string = IoUtil.read(in, charset);
            return string;
        }
        finally {
            IoUtil.close(in);
            RuntimeUtil.destroy(process);
        }
    }

    public static void destroy(Process process) {
        if (null != process) {
            process.destroy();
        }
    }

    public static void addShutdownHook(Runnable hook) {
        Runtime.getRuntime().addShutdownHook(hook instanceof Thread ? (Thread)hook : new Thread(hook));
    }

    public static int getProcessorCount() {
        int cpu = Runtime.getRuntime().availableProcessors();
        if (cpu <= 0) {
            cpu = 7;
        }
        return cpu;
    }

    public static long getFreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public static long getTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public static long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    public static long getUsableMemory() {
        return RuntimeUtil.getMaxMemory() - RuntimeUtil.getTotalMemory() + RuntimeUtil.getFreeMemory();
    }

    public static int getPid() throws UtilException {
        return Pid.INSTANCE.get();
    }

    private static String[] handleCmds(String ... cmds) {
        if (ArrayUtil.isEmpty(cmds)) {
            throw new NullPointerException("Command is empty !");
        }
        if (1 == cmds.length) {
            String cmd = cmds[0];
            if (StrUtil.isBlank(cmd)) {
                throw new NullPointerException("Command is blank !");
            }
            cmds = RuntimeUtil.cmdSplit(cmd);
        }
        return cmds;
    }

    private static String[] cmdSplit(String cmd) {
        ArrayList<String> cmds = new ArrayList<String>();
        int length = cmd.length();
        Stack<Character> stack = new Stack<Character>();
        boolean inWrap = false;
        StrBuilder cache2 = StrUtil.strBuilder();
        block4: for (int i = 0; i < length; ++i) {
            char c = cmd.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': {
                    if (inWrap) {
                        if (c == ((Character)stack.peek()).charValue()) {
                            stack.pop();
                            inWrap = false;
                        }
                        cache2.append(c);
                        continue block4;
                    }
                    stack.push(Character.valueOf(c));
                    cache2.append(c);
                    inWrap = true;
                    continue block4;
                }
                case ' ': {
                    if (inWrap) {
                        cache2.append(c);
                        continue block4;
                    }
                    cmds.add(cache2.toString());
                    cache2.reset();
                    continue block4;
                }
                default: {
                    cache2.append(c);
                }
            }
        }
        if (cache2.hasContent()) {
            cmds.add(cache2.toString());
        }
        return cmds.toArray(new String[0]);
    }
}

