/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.lang.DefaultSegment;
import cn.hutool.core.lang.Segment;

public class PageUtil {
    private static int firstPageNo = 0;

    public static int getFirstPageNo() {
        return firstPageNo;
    }

    public static synchronized void setFirstPageNo(int customFirstPageNo) {
        firstPageNo = customFirstPageNo;
    }

    public static void setOneAsFirstPageNo() {
        PageUtil.setFirstPageNo(1);
    }

    public static int getStart(int pageNo, int pageSize) {
        if (pageNo < firstPageNo) {
            pageNo = firstPageNo;
        }
        if (pageSize < 1) {
            pageSize = 0;
        }
        return (pageNo - firstPageNo) * pageSize;
    }

    public static int getEnd(int pageNo, int pageSize) {
        int start = PageUtil.getStart(pageNo, pageSize);
        return PageUtil.getEndByStart(start, pageSize);
    }

    public static int[] transToStartEnd(int pageNo, int pageSize) {
        int start = PageUtil.getStart(pageNo, pageSize);
        return new int[]{start, PageUtil.getEndByStart(start, pageSize)};
    }

    public static Segment<Integer> toSegment(int pageNo, int pageSize) {
        int[] startEnd = PageUtil.transToStartEnd(pageNo, pageSize);
        return new DefaultSegment<Integer>(startEnd[0], startEnd[1]);
    }

    public static int totalPage(int totalCount, int pageSize) {
        return PageUtil.totalPage((long)totalCount, pageSize);
    }

    public static int totalPage(long totalCount, int pageSize) {
        if (pageSize == 0) {
            return 0;
        }
        return Math.toIntExact(totalCount % (long)pageSize == 0L ? totalCount / (long)pageSize : totalCount / (long)pageSize + 1L);
    }

    public static int[] rainbow(int pageNo, int totalPage, int displayCount) {
        boolean isEven = (displayCount & 1) == 0;
        int left = displayCount >> 1;
        int right = displayCount >> 1;
        int length = displayCount;
        if (isEven) {
            ++right;
        }
        if (totalPage < displayCount) {
            length = totalPage;
        }
        int[] result2 = new int[length];
        if (totalPage >= displayCount) {
            if (pageNo <= left) {
                for (int i = 0; i < result2.length; ++i) {
                    result2[i] = i + 1;
                }
            } else if (pageNo > totalPage - right) {
                for (int i = 0; i < result2.length; ++i) {
                    result2[i] = i + totalPage - displayCount + 1;
                }
            } else {
                for (int i = 0; i < result2.length; ++i) {
                    result2[i] = i + pageNo - left + (isEven ? 1 : 0);
                }
            }
        } else {
            for (int i = 0; i < result2.length; ++i) {
                result2[i] = i + 1;
            }
        }
        return result2;
    }

    public static int[] rainbow(int currentPage, int pageCount) {
        return PageUtil.rainbow(currentPage, pageCount, 10);
    }

    private static int getEndByStart(int start, int pageSize) {
        if (pageSize < 1) {
            pageSize = 0;
        }
        return start + pageSize;
    }
}

