/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang.reflect;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.WeakConcurrentMap;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.TypeUtil;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

public class ActualTypeMapperPool {
    private static final WeakConcurrentMap<Type, Map<Type, Type>> CACHE = new WeakConcurrentMap();

    public static Map<Type, Type> get(Type type) {
        return CACHE.computeIfAbsent(type, key -> ActualTypeMapperPool.createTypeMap(type));
    }

    public static Map<String, Type> getStrKeyMap(Type type) {
        return Convert.toMap(String.class, Type.class, ActualTypeMapperPool.get(type));
    }

    public static Type getActualType(Type type, TypeVariable<?> typeVariable) {
        Map<Type, Type> typeTypeMap = ActualTypeMapperPool.get(type);
        Type result2 = typeTypeMap.get(typeVariable);
        while (result2 instanceof TypeVariable) {
            result2 = typeTypeMap.get(result2);
        }
        return result2;
    }

    public static Type getActualType(Type type, GenericArrayType genericArrayType) {
        Map<Type, Type> typeTypeMap = ActualTypeMapperPool.get(type);
        Class<?> actualType = typeTypeMap.get(genericArrayType);
        if (actualType == null) {
            Type componentType = typeTypeMap.get(genericArrayType.getGenericComponentType());
            if (!(componentType instanceof Class)) {
                return null;
            }
            actualType = ArrayUtil.getArrayType((Class)componentType);
            typeTypeMap.put(genericArrayType, actualType);
        }
        return actualType;
    }

    public static Type[] getActualTypes(Type type, Type ... typeVariables) {
        Type[] result2 = new Type[typeVariables.length];
        for (int i = 0; i < typeVariables.length; ++i) {
            result2[i] = typeVariables[i] instanceof TypeVariable ? ActualTypeMapperPool.getActualType(type, (TypeVariable)typeVariables[i]) : typeVariables[i];
        }
        return result2;
    }

    private static Map<Type, Type> createTypeMap(Type type) {
        ParameterizedType parameterizedType;
        HashMap<Type, Type> typeMap = new HashMap<Type, Type>();
        while (null != type && null != (parameterizedType = TypeUtil.toParameterizedType(type))) {
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            Class rawType = (Class)parameterizedType.getRawType();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < typeParameters.length; ++i) {
                Type value = typeArguments[i];
                if (value instanceof TypeVariable) continue;
                typeMap.put(typeParameters[i], value);
            }
            type = rawType;
        }
        return typeMap;
    }
}

