/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.RandomUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ThreadLocalRandom;

public class WeightListRandom<E>
implements Serializable {
    private static final long serialVersionUID = 6902006276975764032L;
    private final ArrayList<EWeight<E>> randomPool;

    public WeightListRandom() {
        this.randomPool = new ArrayList();
    }

    public WeightListRandom(int poolSize) {
        this.randomPool = new ArrayList(poolSize);
    }

    public void add(E e, double weight) {
        Assert.isTrue(weight > 0.0, "\u6743\u91cd\u5fc5\u987b\u5927\u4e8e0\uff01", new Object[0]);
        this.randomPool.add(new EWeight<E>(e, this.sumWeight() + weight));
    }

    public boolean remove(E e) {
        boolean removed = false;
        double weight = 0.0;
        int i = 0;
        Iterator<EWeight<E>> iterator2 = this.randomPool.iterator();
        while (iterator2.hasNext()) {
            EWeight<E> ew = iterator2.next();
            if (!removed && ew.e.equals(e)) {
                iterator2.remove();
                weight = ew.sumWeight - (i == 0 ? 0.0 : this.randomPool.get((int)(i - 1)).sumWeight);
                removed = true;
            }
            if (removed) {
                ew.sumWeight -= weight;
            }
            ++i;
        }
        return removed;
    }

    public E next() {
        this.checkEmptyPool();
        if (this.randomPool.size() == 1) {
            return this.randomPool.get((int)0).e;
        }
        ThreadLocalRandom random = RandomUtil.getRandom();
        double randVal = random.nextDouble() * this.sumWeight();
        return this.binarySearch(randVal);
    }

    public E randomByWeight(double weight) {
        Assert.isTrue(weight >= this.sumWeight(), "\u6743\u91cd\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u603b\u6743\u91cd\uff01", new Object[0]);
        ThreadLocalRandom random = RandomUtil.getRandom();
        double randVal = random.nextDouble() * this.sumWeight();
        if (randVal > this.sumWeight()) {
            return null;
        }
        return this.binarySearch(randVal);
    }

    public boolean isEmpty() {
        return this.randomPool.isEmpty();
    }

    private E binarySearch(double key) {
        int low = 0;
        int high = this.randomPool.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            double midVal = this.randomPool.get((int)mid).sumWeight;
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return this.randomPool.get((int)mid).e;
        }
        return this.randomPool.get((int)low).e;
    }

    private double sumWeight() {
        if (this.randomPool.isEmpty()) {
            return 0.0;
        }
        return this.randomPool.get((int)(this.randomPool.size() - 1)).sumWeight;
    }

    private void checkEmptyPool() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("\u968f\u673a\u6c60\u4e3a\u7a7a\uff01");
        }
    }

    private static class EWeight<E> {
        final E e;
        double sumWeight;

        public EWeight(E e, double sumWeight) {
            this.e = e;
            this.sumWeight = sumWeight;
        }
    }
}

