/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.date.SystemClock;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.lang.id.IdConstants;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.util.Date;

public class Snowflake
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static long DEFAULT_TWEPOCH = 1288834974657L;
    public static long DEFAULT_TIME_OFFSET = 2000L;
    private static final long WORKER_ID_BITS = 5L;
    public static final long MAX_WORKER_ID = 31L;
    private static final long DATA_CENTER_ID_BITS = 5L;
    public static final long MAX_DATA_CENTER_ID = 31L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long WORKER_ID_SHIFT = 12L;
    private static final long DATA_CENTER_ID_SHIFT = 17L;
    private static final long TIMESTAMP_LEFT_SHIFT = 22L;
    private static final long SEQUENCE_MASK = 4095L;
    private final long twepoch;
    private final long workerId;
    private final long dataCenterId;
    private final boolean useSystemClock;
    private final long timeOffset;
    private final long randomSequenceLimit;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public Snowflake() {
        this(IdConstants.DEFAULT_WORKER_ID);
    }

    public Snowflake(long workerId) {
        this(workerId, IdConstants.DEFAULT_DATACENTER_ID);
    }

    public Snowflake(long workerId, long dataCenterId) {
        this(workerId, dataCenterId, false);
    }

    public Snowflake(long workerId, long dataCenterId, boolean isUseSystemClock) {
        this(null, workerId, dataCenterId, isUseSystemClock);
    }

    public Snowflake(Date epochDate, long workerId, long dataCenterId, boolean isUseSystemClock) {
        this(epochDate, workerId, dataCenterId, isUseSystemClock, DEFAULT_TIME_OFFSET);
    }

    public Snowflake(Date epochDate, long workerId, long dataCenterId, boolean isUseSystemClock, long timeOffset) {
        this(epochDate, workerId, dataCenterId, isUseSystemClock, timeOffset, 0L);
    }

    public Snowflake(Date epochDate, long workerId, long dataCenterId, boolean isUseSystemClock, long timeOffset, long randomSequenceLimit) {
        this.twepoch = null != epochDate ? epochDate.getTime() : DEFAULT_TWEPOCH;
        this.workerId = Assert.checkBetween(workerId, 0L, 31L);
        this.dataCenterId = Assert.checkBetween(dataCenterId, 0L, 31L);
        this.useSystemClock = isUseSystemClock;
        this.timeOffset = timeOffset;
        this.randomSequenceLimit = Assert.checkBetween(randomSequenceLimit, 0L, 4095L);
    }

    public long getWorkerId(long id) {
        return id >> 12 & 0x1FL;
    }

    public long getDataCenterId(long id) {
        return id >> 17 & 0x1FL;
    }

    public long getGenerateDateTime(long id) {
        return (id >> 22 & 0x1FFFFFFFFFFL) + this.twepoch;
    }

    public Pair<Long, Long> getIdScopeByTimestamp(long timestampStart, long timestampEnd) {
        return this.getIdScopeByTimestamp(timestampStart, timestampEnd, true);
    }

    public Pair<Long, Long> getIdScopeByTimestamp(long timestampStart, long timestampEnd, boolean ignoreCenterAndWorker) {
        long startTimeMinId = timestampStart - this.twepoch << 22;
        long endTimeMinId = timestampEnd - this.twepoch << 22;
        if (ignoreCenterAndWorker) {
            long endId = endTimeMinId | 0x3FFFFFL;
            return Pair.of(startTimeMinId, endId);
        }
        long startId = startTimeMinId | this.dataCenterId << 17 | this.workerId << 12;
        long endId = endTimeMinId | this.dataCenterId << 17 | this.workerId << 12 | 0xFFFL;
        return Pair.of(startId, endId);
    }

    public synchronized long nextId() {
        long timestamp = this.genTime();
        if (timestamp < this.lastTimestamp) {
            if (this.lastTimestamp - timestamp < this.timeOffset) {
                timestamp = this.lastTimestamp;
            } else {
                throw new IllegalStateException(StrUtil.format("Clock moved backwards. Refusing to generate id for {}ms", this.lastTimestamp - timestamp));
            }
        }
        if (timestamp == this.lastTimestamp) {
            long sequence2 = this.sequence + 1L & 0xFFFL;
            if (sequence2 == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
            this.sequence = sequence2;
        } else {
            this.sequence = this.randomSequenceLimit > 1L ? RandomUtil.randomLong(this.randomSequenceLimit) : 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - this.twepoch << 22 | this.dataCenterId << 17 | this.workerId << 12 | this.sequence;
    }

    public String nextIdStr() {
        return Long.toString(this.nextId());
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.genTime();
        while (timestamp == lastTimestamp) {
            timestamp = this.genTime();
        }
        if (timestamp < lastTimestamp) {
            throw new IllegalStateException(StrUtil.format("Clock moved backwards. Refusing to generate id for {}ms", lastTimestamp - timestamp));
        }
        return timestamp;
    }

    private long genTime() {
        return this.useSystemClock ? SystemClock.now() : System.currentTimeMillis();
    }
}

