/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.compiler;

import cn.hutool.core.compiler.JavaSourceFileObject;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.util.ZipUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipFile;
import javax.tools.JavaFileObject;

public class JavaFileObjectUtil {
    public static List<JavaFileObject> getJavaFileObjects(File file) {
        ArrayList<JavaFileObject> result2 = new ArrayList<JavaFileObject>();
        String fileName = file.getName();
        if (JavaFileObjectUtil.isJavaFile(fileName)) {
            result2.add(new JavaSourceFileObject(file.toURI()));
        } else if (JavaFileObjectUtil.isJarOrZipFile(fileName)) {
            result2.addAll(JavaFileObjectUtil.getJavaFileObjectByZipOrJarFile(file));
        }
        return result2;
    }

    public static boolean isJarOrZipFile(String fileName) {
        return FileNameUtil.isType(fileName, "jar", "zip");
    }

    public static boolean isJavaFile(String fileName) {
        return FileNameUtil.isType(fileName, "java");
    }

    private static List<JavaFileObject> getJavaFileObjectByZipOrJarFile(File file) {
        ArrayList<JavaFileObject> collection = new ArrayList<JavaFileObject>();
        ZipFile zipFile = ZipUtil.toZipFile(file, null);
        ZipUtil.read(zipFile, zipEntry -> {
            String name = zipEntry.getName();
            if (JavaFileObjectUtil.isJavaFile(name)) {
                collection.add(new JavaSourceFileObject(name, ZipUtil.getStream(zipFile, zipEntry)));
            }
        });
        return collection;
    }
}

