/*
 * Decompiled with CFR 0.152.
 */
package org.cubewhy.celestial.gui.pages;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.cubewhy.celestial.CelestialKt;
import org.cubewhy.celestial.event.EventTarget;
import org.cubewhy.celestial.event.impl.APIReadyEvent;
import org.cubewhy.celestial.game.RemoteAddon;
import org.cubewhy.celestial.game.addon.JavaAgent;
import org.cubewhy.celestial.game.addon.LunarCNMod;
import org.cubewhy.celestial.game.addon.WeaveMod;
import org.cubewhy.celestial.gui.dialogs.AddonInfoDialog;
import org.cubewhy.celestial.gui.layouts.VerticalFlowLayout;
import org.cubewhy.celestial.utils.GuiUtilsKt;
import org.cubewhy.celestial.utils.TextUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\b\u0010\n\u001a\u00020\u0007H\u0002J\b\u0010\u000b\u001a\u00020\u0007H\u0002J\b\u0010\f\u001a\u00020\u0007H\u0002J \u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/cubewhy/celestial/gui/pages/GuiPlugins;", "Ljavax/swing/JPanel;", "<init>", "()V", "tab", "Ljavax/swing/JTabbedPane;", "onAPIReady", "", "e", "Lorg/cubewhy/celestial/event/impl/APIReadyEvent;", "initGui", "refresh", "addTabs", "addPlugin", "panel", "addon", "Lorg/cubewhy/celestial/game/RemoteAddon;", "folder", "Ljava/io/File;", "getInfoButton", "Ljavax/swing/JButton;", "file", "Companion", "celestial"})
public final class GuiPlugins
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JTabbedPane tab;
    @NotNull
    private static final Logger log;

    public GuiPlugins() {
        this.setBorder(new TitledBorder(null, CelestialKt.getT().getString("gui.plugins.title"), 0, 0, null, Color.orange));
        this.setLayout(new BoxLayout(this, 1));
        this.tab = new JTabbedPane();
    }

    @EventTarget
    public final void onAPIReady(@NotNull APIReadyEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        this.removeAll();
        this.initGui();
    }

    private final void initGui() {
        this.add(this.tab);
        this.addTabs();
        JButton btnRefresh = new JButton(CelestialKt.getT().getString("gui.plugins.refresh"));
        btnRefresh.addActionListener(arg_0 -> GuiPlugins.initGui$lambda$0(this, arg_0));
        this.add(this.tab);
        this.add(btnRefresh);
    }

    private final void refresh() {
        this.tab.removeAll();
        this.addTabs();
    }

    private final void addTabs() {
        List<RemoteAddon> addons = CelestialKt.getLunarApiClient().getPlugins();
        if (addons == null) {
            this.add(new JLabel(CelestialKt.getT().getString("gui.plugins.unsupported")));
            return;
        }
        JPanel panelWeave = new JPanel();
        panelWeave.setLayout(new VerticalFlowLayout(0, 0, 0, 0, 0, 0, false, false, 255, null));
        JPanel panelAgents = new JPanel();
        panelAgents.setLayout(new VerticalFlowLayout(0, 0, 0, 0, 0, 0, false, false, 255, null));
        JPanel panelCN = new JPanel();
        panelCN.setLayout(new VerticalFlowLayout(0, 0, 0, 0, 0, 0, false, false, 255, null));
        this.tab.addTab("Weave", GuiUtilsKt.withScroller$default(panelWeave, 0, 0, 3, null));
        this.tab.addTab("Agents", GuiUtilsKt.withScroller$default(panelAgents, 0, 0, 3, null));
        this.tab.addTab("LunarCN", GuiUtilsKt.withScroller$default(panelCN, 0, 0, 3, null));
        block5: for (RemoteAddon addon : addons) {
            switch (WhenMappings.$EnumSwitchMapping$0[addon.getCategory().ordinal()]) {
                case 1: {
                    this.addPlugin(panelWeave, addon, WeaveMod.Companion.getModFolder());
                    continue block5;
                }
                case 2: {
                    this.addPlugin(panelAgents, addon, JavaAgent.Companion.getJavaAgentFolder());
                    continue block5;
                }
                case 3: {
                    this.addPlugin(panelCN, addon, LunarCNMod.Companion.getModFolder());
                    continue block5;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void addPlugin(JPanel panel, RemoteAddon addon, File folder) {
        JPanel p = new JPanel();
        p.setLayout(new GridLayout());
        p.add(new JLabel(addon.getName()));
        File file = new File(folder, addon.getName());
        p.add(this.getInfoButton(addon, file));
        panel.add(p);
    }

    private final JButton getInfoButton(RemoteAddon addon, File file) {
        Object[] objectArray = new Object[]{file.getName()};
        JButton btn = new JButton(TextUtilsKt.format(CelestialKt.getT(), "gui.plugins.info", objectArray));
        btn.addActionListener(arg_0 -> GuiPlugins.getInfoButton$lambda$1(addon, file, arg_0));
        return btn;
    }

    private static final void initGui$lambda$0(GuiPlugins this$0, ActionEvent it) {
        this$0.refresh();
    }

    private static final void getInfoButton$lambda$1(RemoteAddon $addon, File $file, ActionEvent it) {
        log.info("Open plugin info dialog for " + $addon.getName());
        new AddonInfoDialog($addon, $file).setVisible(true);
    }

    static {
        Logger logger = LoggerFactory.getLogger(GuiPlugins.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        log = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/cubewhy/celestial/gui/pages/GuiPlugins$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "celestial"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RemoteAddon.Category.values().length];
            try {
                nArray[RemoteAddon.Category.WEAVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RemoteAddon.Category.AGENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RemoteAddon.Category.CN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

