/*
 * Decompiled with CFR 0.152.
 */
package org.cubewhy.celestial.gui.pages;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.cubewhy.celestial.CelestialKt;
import org.cubewhy.celestial.entities.LunarAccount;
import org.cubewhy.celestial.game.AccountManager;
import org.cubewhy.celestial.gui.elements.PlaceholderTextField;
import org.cubewhy.celestial.gui.pages.LunarAccountState;
import org.cubewhy.celestial.utils.TextUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0001H\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/cubewhy/celestial/gui/pages/AccountManagerPanel;", "Ljavax/swing/JPanel;", "<init>", "()V", "tab", "Ljavax/swing/JTabbedPane;", "accountList", "Ljavax/swing/DefaultListModel;", "Lorg/cubewhy/celestial/gui/pages/LunarAccountState;", "init", "", "makeOfflineAccountPanel", "accountPanel", "addAccount", "", "username", "", "uuid", "Ljava/util/UUID;", "addAccountToUi", "account", "Lorg/cubewhy/celestial/entities/LunarAccount;", "isActive", "celestial"})
@SourceDebugExtension(value={"SMAP\nAccountManagerPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccountManagerPanel.kt\norg/cubewhy/celestial/gui/pages/AccountManagerPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,179:1\n1869#2,2:180\n188#3,3:182\n*S KotlinDebug\n*F\n+ 1 AccountManagerPanel.kt\norg/cubewhy/celestial/gui/pages/AccountManagerPanel\n*L\n60#1:180,2\n143#1:182,3\n*E\n"})
public final class AccountManagerPanel
extends JPanel {
    @NotNull
    private final JTabbedPane tab;
    @NotNull
    private final DefaultListModel<LunarAccountState> accountList = new DefaultListModel();

    public AccountManagerPanel() {
        this.setName("account-manager");
        this.setBorder(new TitledBorder(null, CelestialKt.getT().getString("gui.account-manager.title"), 0, 0, null, Color.orange));
        this.tab = new JTabbedPane();
        this.setLayout(new BoxLayout(this, 1));
        this.init();
    }

    private final void init() {
        this.add(this.tab);
        JPanel accountPanel = new JPanel();
        accountPanel.setLayout(new BorderLayout());
        this.tab.addTab("Accounts", accountPanel);
        Iterable $this$forEach$iv = AccountManager.INSTANCE.getAccountConfig().getAccounts().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LunarAccount account = (LunarAccount)element$iv;
            boolean bl = false;
            this.addAccountToUi(account, Intrinsics.areEqual(AccountManager.INSTANCE.getAccountConfig().getActiveAccountLocalId(), account.getLocalId()));
        }
        accountPanel.add((Component)new JList(this.accountList), "Center");
        this.makeOfflineAccountPanel(accountPanel);
    }

    private final void makeOfflineAccountPanel(JPanel accountPanel) {
        JPanel jPanel;
        JPanel $this$makeOfflineAccountPanel_u24lambda_u241 = jPanel = new JPanel(new GridBagLayout());
        boolean bl = false;
        $this$makeOfflineAccountPanel_u24lambda_u241.setBorder(new TitledBorder(null, "Offline Account", 0, 0, null, Color.ORANGE));
        JPanel createOfflineAccountPanel = jPanel;
        Insets pad = new Insets(6, 8, 6, 8);
        JLabel usernameLabel = new JLabel("Username:");
        JTextField usernameField = new JTextField(20);
        JLabel uuidLabel = new JLabel("UUID:");
        PlaceholderTextField uuidField = new PlaceholderTextField(20);
        uuidField.setPlaceholder("<auto generated>");
        JButton btnCreateOfflineAccount = new JButton("Add Account");
        createOfflineAccountPanel.add((Component)usernameLabel, AccountManagerPanel.makeOfflineAccountPanel$gbc$default(pad, 0, 0, 0.0, 0.0, 0, 0, 0, 248, null));
        createOfflineAccountPanel.add((Component)usernameField, AccountManagerPanel.makeOfflineAccountPanel$gbc$default(pad, 1, 0, 1.0, 0.0, 2, 0, 0, 208, null));
        createOfflineAccountPanel.add((Component)uuidLabel, AccountManagerPanel.makeOfflineAccountPanel$gbc$default(pad, 0, 1, 0.0, 0.0, 0, 0, 0, 248, null));
        createOfflineAccountPanel.add((Component)uuidField, AccountManagerPanel.makeOfflineAccountPanel$gbc$default(pad, 1, 1, 1.0, 0.0, 2, 0, 0, 208, null));
        createOfflineAccountPanel.add((Component)btnCreateOfflineAccount, AccountManagerPanel.makeOfflineAccountPanel$gbc$default(pad, 0, 2, 0.0, 0.0, 0, 13, 2, 56, null));
        createOfflineAccountPanel.add((Component)new JLabel("Note: You must add the browser debugger agent to use offline accounts"), AccountManagerPanel.makeOfflineAccountPanel$gbc$default(pad, 0, 2, 0.0, 0.0, 0, 17, 2, 56, null));
        btnCreateOfflineAccount.addActionListener(arg_0 -> AccountManagerPanel.makeOfflineAccountPanel$lambda$4(usernameField, this, uuidField, arg_0));
        accountPanel.add((Component)createOfflineAccountPanel, "North");
    }

    private final boolean addAccount(String username, UUID uuid) {
        LunarAccount account = AccountManager.INSTANCE.addOfflineAccount(username, uuid);
        this.accountList.addElement(new LunarAccountState(account, false));
        return true;
    }

    private final void addAccountToUi(LunarAccount account, boolean isActive) {
        this.accountList.addElement(new LunarAccountState(account, isActive));
    }

    private static final GridBagConstraints makeOfflineAccountPanel$gbc(Insets pad, int x, int y, double wx, double wy, int fill, int anchor, int gw) {
        GridBagConstraints gridBagConstraints;
        GridBagConstraints $this$makeOfflineAccountPanel_u24gbc_u24lambda_u242 = gridBagConstraints = new GridBagConstraints();
        boolean bl = false;
        $this$makeOfflineAccountPanel_u24gbc_u24lambda_u242.gridx = x;
        $this$makeOfflineAccountPanel_u24gbc_u24lambda_u242.gridy = y;
        $this$makeOfflineAccountPanel_u24gbc_u24lambda_u242.weightx = wx;
        $this$makeOfflineAccountPanel_u24gbc_u24lambda_u242.weighty = wy;
        $this$makeOfflineAccountPanel_u24gbc_u24lambda_u242.fill = fill;
        $this$makeOfflineAccountPanel_u24gbc_u24lambda_u242.anchor = anchor;
        $this$makeOfflineAccountPanel_u24gbc_u24lambda_u242.gridwidth = gw;
        $this$makeOfflineAccountPanel_u24gbc_u24lambda_u242.insets = pad;
        return gridBagConstraints;
    }

    static /* synthetic */ GridBagConstraints makeOfflineAccountPanel$gbc$default(Insets insets, int n, int n2, double d, double d2, int n3, int n4, int n5, int n6, Object object) {
        if ((n6 & 8) != 0) {
            d = 0.0;
        }
        if ((n6 & 0x10) != 0) {
            d2 = 0.0;
        }
        if ((n6 & 0x20) != 0) {
            n3 = 0;
        }
        if ((n6 & 0x40) != 0) {
            n4 = 17;
        }
        if ((n6 & 0x80) != 0) {
            n5 = 1;
        }
        return AccountManagerPanel.makeOfflineAccountPanel$gbc(insets, n, n2, d, d2, n3, n4, n5);
    }

    private static final void makeOfflineAccountPanel$lambda$4(JTextField $usernameField, AccountManagerPanel this$0, PlaceholderTextField $uuidField, ActionEvent it) {
        boolean bl;
        UUID uuid;
        String username;
        block8: {
            username = $usernameField.getText();
            Intrinsics.checkNotNull(username);
            if (((CharSequence)username).length() == 0) {
                JOptionPane.showMessageDialog(this$0, "Username cannot be empty", "Error", 0);
                return;
            }
            UUID uUID = TextUtilsKt.safeConvertStringToUuid($uuidField.getText());
            if (uUID == null) {
                CharSequence charSequence = $uuidField.getText();
                uUID = charSequence == null || charSequence.length() == 0 ? UUID.randomUUID() : null;
            }
            if ((uuid = uUID) == null) {
                JOptionPane.showMessageDialog(this$0, "Bad UUID format", "Error", 0);
                return;
            }
            Map<String, LunarAccount> $this$any$iv = AccountManager.INSTANCE.getAccountConfig().getAccounts();
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<String, LunarAccount>> iterator2 = $this$any$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<String, LunarAccount> element$iv;
                    Map.Entry<String, LunarAccount> it2 = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (!(StringsKt.contentEquals(it2.getValue().getUsername(), username, true) || Intrinsics.areEqual(it2.getValue().getMinecraftProfile().getId(), uuid.toString()))) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            JOptionPane.showMessageDialog(this$0, "Account with same username or uuid already exist", "Error", 0);
            return;
        }
        if (this$0.addAccount(username, uuid)) {
            $usernameField.setText("");
            $uuidField.setText("");
        }
    }
}

