/*
 * Decompiled with CFR 0.152.
 */
package org.cubewhy.celestial.gui.layouts;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0007\u0018\u0000 12\u00020\u00012\u00020\u0002:\u00011BW\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u0012\b\b\u0002\u0010\b\u001a\u00020\u0004\u0012\b\b\u0002\u0010\t\u001a\u00020\u0004\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eB\u0019\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0004\u0012\u0006\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u0011J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020 H\u0016J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 H\u0016JD\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00042\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001b0+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001b0+H\u0002J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001b0+2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0016\u0010.\u001a\u00020\u00042\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001b0+H\u0002J\u0016\u0010/\u001a\u00020\u00042\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001b0+H\u0002J\b\u00100\u001a\u00020\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/cubewhy/celestial/gui/layouts/VerticalFlowLayout;", "Ljava/awt/LayoutManager;", "Ljava/io/Serializable;", "hAlign", "", "vAlign", "hPadding", "vPadding", "hGap", "vGap", "fill", "", "wrap", "<init>", "(IIIIIIZZ)V", "padding", "gap", "(II)V", "getVGap", "()I", "setVGap", "(I)V", "addLayoutComponent", "", "name", "", "comp", "Ljava/awt/Component;", "removeLayoutComponent", "preferredLayoutSize", "Ljava/awt/Dimension;", "container", "Ljava/awt/Container;", "minimumLayoutSize", "parent", "layoutContainer", "batch", "insets", "Ljava/awt/Insets;", "availableWidth", "availableHeight", "xBase", "list", "", "components", "getVisibleComponents", "getPreferredWidth", "getPreferredHeight", "toString", "Companion", "celestial"})
public final class VerticalFlowLayout
implements LayoutManager,
Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int hAlign;
    private int vAlign;
    private int hPadding;
    private int vPadding;
    private int hGap;
    private int vGap;
    private final boolean fill;
    private final boolean wrap;
    private static final long serialVersionUID = 1L;
    public static final int CENTER = 0;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;

    public VerticalFlowLayout(int hAlign, int vAlign, int hPadding, int vPadding, int hGap, int vGap, boolean fill, boolean wrap) {
        this.hAlign = hAlign;
        this.vAlign = vAlign;
        this.hPadding = hPadding;
        this.vPadding = vPadding;
        this.hGap = hGap;
        this.vGap = vGap;
        this.fill = fill;
        this.wrap = wrap;
    }

    public /* synthetic */ VerticalFlowLayout(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, int n7, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n7 & 1) != 0) {
            n = 3;
        }
        if ((n7 & 2) != 0) {
            n2 = 1;
        }
        if ((n7 & 4) != 0) {
            n3 = 5;
        }
        if ((n7 & 8) != 0) {
            n4 = 5;
        }
        if ((n7 & 0x10) != 0) {
            n5 = 5;
        }
        if ((n7 & 0x20) != 0) {
            n6 = 5;
        }
        if ((n7 & 0x40) != 0) {
            bl = true;
        }
        if ((n7 & 0x80) != 0) {
            bl2 = false;
        }
        this(n, n2, n3, n4, n5, n6, bl, bl2);
    }

    public final int getVGap() {
        return this.vGap;
    }

    public final void setVGap(int n) {
        this.vGap = n;
    }

    public VerticalFlowLayout(int padding, int gap) {
        this(3, 1, padding, padding, gap, gap, true, false);
    }

    @Override
    public void addLayoutComponent(@NotNull String name, @NotNull Component comp) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(comp, "comp");
    }

    @Override
    public void removeLayoutComponent(@NotNull Component comp) {
        Intrinsics.checkNotNullParameter(comp, "comp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container container) {
        Intrinsics.checkNotNullParameter(container, "container");
        Object object = container.getTreeLock();
        Intrinsics.checkNotNullExpressionValue(object, "getTreeLock(...)");
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            int width = 0;
            int height = 0;
            List<Component> components = this.getVisibleComponents(container);
            for (Component component : components) {
                Dimension dimension = component.getPreferredSize();
                width = (int)Math.max((double)width, (double)dimension.width);
                height += dimension.height;
            }
            if (!((Collection)components).isEmpty()) {
                height += this.vGap * (components.size() - 1);
            }
            Insets insets = container.getInsets();
            width += insets.left + insets.right;
            height += insets.top + insets.bottom;
            if (!((Collection)components).isEmpty()) {
                width += this.hPadding * 2;
                height += this.vPadding * 2;
            }
            Dimension dimension = new Dimension(width, height);
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Dimension minimumLayoutSize(@NotNull Container parent) {
        Intrinsics.checkNotNullParameter(parent, "parent");
        Object object = parent.getTreeLock();
        Intrinsics.checkNotNullExpressionValue(object, "getTreeLock(...)");
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            int width = 0;
            int height = 0;
            List<Component> components = this.getVisibleComponents(parent);
            for (Component component : components) {
                Dimension dimension = component.getMinimumSize();
                width = (int)Math.max((double)width, (double)dimension.width);
                height += dimension.height;
            }
            if (!((Collection)components).isEmpty()) {
                height += this.vGap * (components.size() - 1);
            }
            Insets insets = parent.getInsets();
            width += insets.left + insets.right;
            height += insets.top + insets.bottom;
            if (!((Collection)components).isEmpty()) {
                width += this.hPadding * 2;
                height += this.vPadding * 2;
            }
            Dimension dimension = new Dimension(width, height);
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(@NotNull Container container) {
        Intrinsics.checkNotNullParameter(container, "container");
        Object object = container.getTreeLock();
        Intrinsics.checkNotNullExpressionValue(object, "getTreeLock(...)");
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            Dimension size = container.getSize();
            Insets insets = container.getInsets();
            int availableWidth = size.width - insets.left - insets.right - this.hPadding * 2;
            int availableHeight = size.height - insets.top - insets.bottom - this.vPadding * 2;
            List<Component> components = this.getVisibleComponents(container);
            int xBase = insets.left + this.hPadding;
            List list = new LinkedList();
            for (Component component : components) {
                list.add(component);
                if (!this.wrap || list.size() <= 1 || availableHeight + this.vPadding >= this.getPreferredHeight(list)) continue;
                list.remove(component);
                Intrinsics.checkNotNull(insets);
                this.batch(insets, availableWidth, availableHeight, xBase, list, components);
                xBase += this.hGap + this.getPreferredWidth(list);
                list.clear();
                list.add(component);
            }
            if (!((Collection)list).isEmpty()) {
                Intrinsics.checkNotNull(insets);
                this.batch(insets, availableWidth, availableHeight, xBase, list, components);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void batch(Insets insets, int availableWidth, int availableHeight, int xBase, List<? extends Component> list, List<? extends Component> components) {
        int preferredWidth = this.getPreferredWidth(list);
        int preferredHeight = this.getPreferredHeight(list);
        int y = switch (this.vAlign) {
            case 1 -> insets.top + this.vPadding;
            case 0 -> (availableHeight - preferredHeight) / 2 + insets.top + this.vPadding;
            case 2 -> availableHeight - preferredHeight + insets.top + this.vPadding;
            default -> insets.top + this.vPadding;
        };
        int n = ((Collection)list).size();
        for (int i = 0; i < n; ++i) {
            int n2;
            Component item = list.get(i);
            if (this.fill) {
                n2 = xBase;
            } else {
                switch (this.hAlign) {
                    case 3: {
                        n2 = xBase;
                        break;
                    }
                    case 0: {
                        n2 = xBase + (preferredWidth - item.getPreferredSize().width) / 2;
                        break;
                    }
                    case 4: {
                        n2 = xBase + preferredWidth - item.getPreferredSize().width;
                        break;
                    }
                    default: {
                        n2 = xBase;
                    }
                }
            }
            int x = n2;
            int width = 0;
            if (this.fill) {
                int n3 = width = this.wrap ? preferredWidth : availableWidth;
                if (list.size() == components.size()) {
                    width = availableWidth;
                }
            } else {
                width = item.getPreferredSize().width;
            }
            if (i != 0) {
                y += this.vGap;
            }
            item.setBounds(x, y, width, item.getPreferredSize().height);
            y += item.getHeight();
        }
    }

    private final List<Component> getVisibleComponents(Container container) {
        List list = new ArrayList();
        Iterator<Component> iterator2 = ArrayIteratorKt.iterator(container.getComponents());
        while (iterator2.hasNext()) {
            Component component = iterator2.next();
            if (!component.isVisible()) continue;
            Intrinsics.checkNotNull(component);
            list.add(component);
        }
        return list;
    }

    private final int getPreferredWidth(List<? extends Component> components) {
        int width = 0;
        for (Component component : components) {
            width = (int)Math.max((double)width, (double)component.getPreferredSize().width);
        }
        return width;
    }

    private final int getPreferredHeight(List<? extends Component> components) {
        int height = 0;
        for (Component component : components) {
            height += component.getPreferredSize().height;
        }
        if (!((Collection)components).isEmpty()) {
            height += this.vGap * (components.size() - 1);
        }
        return height;
    }

    @NotNull
    public String toString() {
        return "VerticalFlowLayout{hAlign=" + this.hAlign + ", vAlign=" + this.vAlign + ", hPadding=" + this.hPadding + ", vPadding=" + this.vPadding + ", hGap=" + this.hGap + ", vGap=" + this.vGap + ", fill=" + this.fill + ", wrap=" + this.wrap + "}";
    }

    public VerticalFlowLayout() {
        this(0, 0, 0, 0, 0, 0, false, false, 255, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/cubewhy/celestial/gui/layouts/VerticalFlowLayout$Companion;", "", "<init>", "()V", "serialVersionUID", "", "CENTER", "", "TOP", "BOTTOM", "LEFT", "RIGHT", "celestial"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

