/*
 * Decompiled with CFR 0.152.
 */
package org.cubewhy.celestial.gui.elements;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.cubewhy.celestial.CelestialKt;
import org.cubewhy.celestial.event.EventManager;
import org.cubewhy.celestial.event.EventTarget;
import org.cubewhy.celestial.event.impl.GameStartEvent;
import org.cubewhy.celestial.event.impl.GameTerminateEvent;
import org.cubewhy.celestial.event.impl.UpdateStatusTextEvent;
import org.cubewhy.celestial.utils.GuiUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u001dH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R(\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u000b\u001a\u0004\u0018\u00010\u0011@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001e"}, d2={"Lorg/cubewhy/celestial/gui/elements/StatusBar;", "Ljavax/swing/JPanel;", "<init>", "()V", "label", "Ljavax/swing/JLabel;", "pidLabel", "autoClearTimer", "Ljavax/swing/Timer;", "clear", "", "value", "", "isRunningGame", "()Z", "setRunningGame", "(Z)V", "", "text", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "onGameStart", "e", "Lorg/cubewhy/celestial/event/impl/GameStartEvent;", "onGameTerminate", "Lorg/cubewhy/celestial/event/impl/GameTerminateEvent;", "onUpdateStatusText", "Lorg/cubewhy/celestial/event/impl/UpdateStatusTextEvent;", "celestial"})
public final class StatusBar
extends JPanel {
    @NotNull
    private final JLabel label = new JLabel();
    @NotNull
    private final JLabel pidLabel = GuiUtilsKt.toJLabel("game-pid");
    @NotNull
    private final Timer autoClearTimer = new Timer(10000, arg_0 -> StatusBar.autoClearTimer$lambda$0(this, arg_0));
    private boolean isRunningGame;
    @Nullable
    private String text;

    public StatusBar() {
        EventManager.INSTANCE.register(this);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.label, "West");
        JPanel otherComponents = new JPanel();
        otherComponents.add(this.pidLabel);
        this.pidLabel.setVisible(false);
        this.add((Component)otherComponents, "East");
    }

    private final void clear() {
        this.label.setText("");
    }

    public final boolean isRunningGame() {
        return this.isRunningGame;
    }

    public final void setRunningGame(boolean value) {
        this.pidLabel.setText((String)(value ? "PID " + CelestialKt.getGamePid() : "NOT RUNNING"));
        this.pidLabel.setVisible(value);
        this.isRunningGame = value;
    }

    @Nullable
    public final String getText() {
        return this.text;
    }

    public final void setText(@Nullable String value) {
        String string = this.label.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        if (((CharSequence)string).length() > 0) {
            this.autoClearTimer.stop();
        }
        this.label.setText(value);
        CharSequence charSequence = value;
        if (!(charSequence == null || charSequence.length() == 0)) {
            this.autoClearTimer.start();
        }
    }

    @EventTarget
    public final void onGameStart(@NotNull GameStartEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        CelestialKt.getGamePid().set(e.getPid());
        this.setRunningGame(true);
    }

    @EventTarget
    public final void onGameTerminate(@NotNull GameTerminateEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        CelestialKt.getGamePid().set(0L);
        this.setRunningGame(false);
    }

    @EventTarget
    public final void onUpdateStatusText(@NotNull UpdateStatusTextEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        String string = this.label.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        if (((CharSequence)string).length() > 0 && this.autoClearTimer.isRunning()) {
            this.autoClearTimer.stop();
        }
        this.label.setText(e.getText());
        if (((CharSequence)e.getText()).length() > 0) {
            this.autoClearTimer.start();
        }
    }

    private static final void autoClearTimer$lambda$0(StatusBar this$0, ActionEvent it) {
        this$0.clear();
    }
}

