/*
 * Decompiled with CFR 0.152.
 */
package org.cubewhy.celestial.gui.elements;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.cubewhy.celestial.utils.GuiUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00028\u00000\nj\b\u0012\u0004\u0012\u00028\u0000`\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/cubewhy/celestial/gui/elements/SearchableList;", "T", "Ljavax/swing/JPanel;", "model", "Ljavax/swing/DefaultListModel;", "baseList", "Ljavax/swing/JList;", "<init>", "(Ljavax/swing/DefaultListModel;Ljavax/swing/JList;)V", "list", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "isInternalChange", "", "search", "", "text", "", "celestial"})
@SourceDebugExtension(value={"SMAP\nSearchableList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchableList.kt\norg/cubewhy/celestial/gui/elements/SearchableList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,104:1\n1869#2,2:105\n32#3,2:107\n*S KotlinDebug\n*F\n+ 1 SearchableList.kt\norg/cubewhy/celestial/gui/elements/SearchableList\n*L\n96#1:105,2\n57#1:107,2\n*E\n"})
public final class SearchableList<T>
extends JPanel {
    @NotNull
    private final DefaultListModel<T> model;
    @NotNull
    private ArrayList<T> list;
    private boolean isInternalChange;

    public SearchableList(@NotNull DefaultListModel<T> model, @NotNull JList<T> baseList) {
        Intrinsics.checkNotNullParameter(model, "model");
        Intrinsics.checkNotNullParameter(baseList, "baseList");
        this.model = model;
        this.list = new ArrayList();
        this.setLayout(new BorderLayout(0, 0));
        JTextField searchBar = new JTextField("Search");
        searchBar.setForeground(Color.GRAY);
        searchBar.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                Intrinsics.checkNotNullParameter(e, "e");
                JTextField source2 = (JTextField)GuiUtilsKt.source(e);
                if (Intrinsics.areEqual(source2.getText(), "Search")) {
                    source2.setText("");
                }
                source2.setForeground(null);
            }

            @Override
            public void focusLost(FocusEvent e) {
                Intrinsics.checkNotNullParameter(e, "e");
                JTextField source2 = (JTextField)GuiUtilsKt.source(e);
                String string = source2.getText();
                Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
                if (((CharSequence)string).length() == 0) {
                    source2.setText("Search");
                    source2.setForeground(Color.GRAY);
                }
            }
        });
        searchBar.addActionListener(arg_0 -> SearchableList._init_$lambda$0(this, arg_0));
        this.add((Component)searchBar, "North");
        baseList.addPropertyChangeListener(arg_0 -> SearchableList._init_$lambda$2(this, arg_0));
        this.model.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                SearchableList._init_$refresh(this);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                SearchableList._init_$refresh(this);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                SearchableList._init_$refresh(this);
            }
        });
        SearchableList._init_$refresh(this);
        this.add(GuiUtilsKt.withScroller$default(baseList, 0, 0, 3, null));
    }

    private final void search(String text) {
        this.isInternalChange = true;
        if (StringsKt.isBlank(text)) {
            this.model.removeAllElements();
            this.model.addAll((Collection)this.list);
            this.isInternalChange = false;
            return;
        }
        this.model.removeAllElements();
        Iterable $this$forEach$iv = this.list;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator2.next();
            boolean bl = false;
            if (!StringsKt.contains((CharSequence)String.valueOf(it), text, true)) continue;
            this.model.addElement(it);
        }
        this.isInternalChange = false;
    }

    private static final void _init_$lambda$0(SearchableList this$0, ActionEvent it) {
        Intrinsics.checkNotNull(it);
        String string = ((JTextField)GuiUtilsKt.source(it)).getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        this$0.search(string);
    }

    private static final <T> void _init_$refresh(SearchableList<T> this$0) {
        if (this$0.isInternalChange) {
            return;
        }
        this$0.list = new ArrayList();
        Iterator<T> iterator2 = this$0.model.elements().asIterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "asIterator(...)");
        Iterator<T> $this$forEach$iv = iterator2;
        boolean $i$f$forEach = false;
        Iterator<T> iterator3 = $this$forEach$iv;
        while (iterator3.hasNext()) {
            T element$iv;
            T it = element$iv = iterator3.next();
            boolean bl = false;
            this$0.list.add(it);
        }
    }

    private static final void _init_$lambda$2(SearchableList this$0, PropertyChangeEvent it) {
        SearchableList._init_$refresh(this$0);
    }
}

