/*
 * Decompiled with CFR 0.152.
 */
package org.cubewhy.celestial.gui;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0086\u0081\u0002\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0014B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0015"}, d2={"Lorg/cubewhy/celestial/gui/Language;", "", "view", "", "code", "locale", "Ljava/util/Locale;", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/util/Locale;)V", "getView", "()Ljava/lang/String;", "getCode", "getLocale", "()Ljava/util/Locale;", "ENGLISH", "SPANISH", "CHINESE", "JAPANESE", "KOREAN", "toString", "Companion", "celestial"})
public final class Language
extends Enum<Language> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String view;
    @NotNull
    private final String code;
    @NotNull
    private final Locale locale;
    public static final /* enum */ Language ENGLISH;
    public static final /* enum */ Language SPANISH;
    public static final /* enum */ Language CHINESE;
    public static final /* enum */ Language JAPANESE;
    public static final /* enum */ Language KOREAN;
    private static final /* synthetic */ Language[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private Language(String view, String code, Locale locale) {
        this.view = view;
        this.code = code;
        this.locale = locale;
    }

    @NotNull
    public final String getView() {
        return this.view;
    }

    @NotNull
    public final String getCode() {
        return this.code;
    }

    @NotNull
    public final Locale getLocale() {
        return this.locale;
    }

    @NotNull
    public String toString() {
        return this.view + "/" + this.code;
    }

    public static Language[] values() {
        return (Language[])$VALUES.clone();
    }

    public static Language valueOf(String value) {
        return Enum.valueOf(Language.class, value);
    }

    @NotNull
    public static EnumEntries<Language> getEntries() {
        return $ENTRIES;
    }

    static {
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue(locale, "ENGLISH");
        ENGLISH = new Language("English", "en", locale);
        SPANISH = new Language("Spanish", "es", new Locale("es"));
        Locale locale2 = Locale.CHINESE;
        Intrinsics.checkNotNullExpressionValue(locale2, "CHINESE");
        CHINESE = new Language("\u7b80\u4f53\u4e2d\u6587", "zh", locale2);
        Locale locale3 = Locale.JAPANESE;
        Intrinsics.checkNotNullExpressionValue(locale3, "JAPANESE");
        JAPANESE = new Language("\u65e5\u672c\u8a9e", "ja", locale3);
        Locale locale4 = Locale.KOREAN;
        Intrinsics.checkNotNullExpressionValue(locale4, "KOREAN");
        KOREAN = new Language("\ud55c\uad6d\uc778", "ko", locale4);
        $VALUES = languageArray = new Language[]{Language.ENGLISH, Language.SPANISH, Language.CHINESE, Language.JAPANESE, Language.KOREAN};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"Lorg/cubewhy/celestial/gui/Language$Companion;", "", "<init>", "()V", "findByCode", "Lorg/cubewhy/celestial/gui/Language;", "code", "", "findByView", "view", "celestial"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Language findByCode(@NotNull String code) {
            Intrinsics.checkNotNullParameter(code, "code");
            for (Language value : Language.getEntries()) {
                if (!Intrinsics.areEqual(value.getCode(), code)) continue;
                return value;
            }
            return null;
        }

        @Nullable
        public final Language findByView(@NotNull String view) {
            Intrinsics.checkNotNullParameter(view, "view");
            for (Language value : Language.getEntries()) {
                if (!Intrinsics.areEqual(value.getView(), view)) continue;
                return value;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

