/*
 * Decompiled with CFR 0.152.
 */
package org.cubewhy.celestial.game;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import java.io.File;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import org.cubewhy.celestial.CelestialKt;
import org.cubewhy.celestial.entities.LunarAccount;
import org.cubewhy.celestial.entities.LunarAccountConfig;
import org.cubewhy.celestial.entities.LunarMinecraftProfile;
import org.cubewhy.celestial.utils.TextUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/cubewhy/celestial/game/AccountManager;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "accountsFile", "Ljava/io/File;", "getAccountsFile", "()Ljava/io/File;", "accountConfig", "Lorg/cubewhy/celestial/entities/LunarAccountConfig;", "getAccountConfig", "()Lorg/cubewhy/celestial/entities/LunarAccountConfig;", "accountConfig$delegate", "Lkotlin/Lazy;", "addOfflineAccount", "Lorg/cubewhy/celestial/entities/LunarAccount;", "username", "", "uuid", "Ljava/util/UUID;", "fixBrokenOfflineAccounts", "", "celestial"})
@SourceDebugExtension(value={"SMAP\nAccountManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccountManager.kt\norg/cubewhy/celestial/game/AccountManager\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,117:1\n205#2:118\n205#2:119\n*S KotlinDebug\n*F\n+ 1 AccountManager.kt\norg/cubewhy/celestial/game/AccountManager\n*L\n72#1:118\n114#1:119\n*E\n"})
public final class AccountManager {
    @NotNull
    public static final AccountManager INSTANCE = new AccountManager();
    @NotNull
    private static final Logger log;
    @NotNull
    private static final File accountsFile;
    @NotNull
    private static final Lazy accountConfig$delegate;

    private AccountManager() {
    }

    @NotNull
    public final File getAccountsFile() {
        return accountsFile;
    }

    @NotNull
    public final LunarAccountConfig getAccountConfig() {
        Lazy lazy = accountConfig$delegate;
        return (LunarAccountConfig)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LunarAccount addOfflineAccount(@NotNull String username, @NotNull UUID uuid) {
        void this_$iv;
        Intrinsics.checkNotNullParameter(username, "username");
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String localId = StringsKt.replace$default(string, "-", "", false, 4, null);
        String remoteId = TextUtilsKt.randomDigitString(16);
        Algorithm algorithm = Algorithm.HMAC384("celestial");
        Object[] objectArray = new String[]{"multiplayer", "twofactorauth", "msamigration_stage4", "orders_2022"};
        JWTCreator.Builder builder = JWT.create().withClaim("xuid", remoteId).withClaim("agg", "Adult").withClaim("auth", "XBOX").withClaim("ns", "default").withClaim("flags", CollectionsKt.listOf(objectArray)).withClaim("profiles", MapsKt.mapOf(TuplesKt.to("mc", uuid.toString()))).withClaim("platform", "PC_LAUNCHER");
        objectArray = new Pair[]{TuplesKt.to("type", "mc"), TuplesKt.to("id", uuid.toString()), TuplesKt.to("name", username)};
        JWTCreator.Builder jwt = builder.withClaim("pfd", CollectionsKt.listOf(MapsKt.mapOf(objectArray)));
        String fakeAccessToken = jwt.sign(algorithm);
        String string2 = Instant.now().plus(10L, ChronoUnit.DAYS).toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        Object object = string2;
        String string3 = uuid.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        LunarMinecraftProfile lunarMinecraftProfile = new LunarMinecraftProfile(StringsKt.replace$default(string3, "-", "", false, 4, null), username);
        LunarAccount account = new LunarAccount(fakeAccessToken, (String)object, false, false, false, false, null, localId, "OFFLINE_ALT", lunarMinecraftProfile, remoteId, null, username, 2172, null);
        this.getAccountConfig().getAccounts().put(localId, account);
        object = CelestialKt.getJSON();
        LunarAccountConfig value$iv = this.getAccountConfig();
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        FilesKt.writeText$default(accountsFile, this_$iv.encodeToString((SerializationStrategy)LunarAccountConfig.Companion.serializer(), value$iv), null, 2, null);
        return account;
    }

    /*
     * WARNING - void declaration
     */
    public final void fixBrokenOfflineAccounts() {
        boolean hasModify = false;
        for (Map.Entry<String, LunarAccount> entry : this.getAccountConfig().getAccounts().entrySet()) {
            String key = entry.getKey();
            LunarAccount value = entry.getValue();
            int remoteId = Random.Default.nextInt(1000, 1000000);
            Algorithm algorithm = Algorithm.HMAC384("celestial");
            String jwt = JWT.create().withClaim("xuid", remoteId).sign(algorithm);
            if (value.getAccessToken() == null || value.getRefreshToken() == null) {
                value.setAccessToken(jwt);
                value.setRefreshToken("OFFLINE_ALT");
                value.setRemoteId(String.valueOf(remoteId));
                String string = Instant.now().plus(10L, ChronoUnit.DAYS).toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                value.setAccessTokenExpiresAt(string);
                this.getAccountConfig().getAccounts().put(key, value);
                hasModify = true;
                log.info("Fixed broken offline account " + value.getUsername() + " (" + value.getMinecraftProfile().getId() + ")");
            }
            try {
                Instant instant = Instant.parse(value.getAccessTokenExpiresAt());
                if (!instant.isBefore(Instant.now())) continue;
                String string = Instant.now().plus(10L, ChronoUnit.DAYS).toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                value.setAccessTokenExpiresAt(string);
                this.getAccountConfig().getAccounts().put(key, value);
                hasModify = true;
            }
            catch (RuntimeException runtimeException) {
                String string = Instant.now().plus(10L, ChronoUnit.DAYS).toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                value.setAccessTokenExpiresAt(string);
                this.getAccountConfig().getAccounts().put(key, value);
                hasModify = true;
            }
        }
        if (hasModify) {
            void this_$iv;
            Json json = CelestialKt.getJSON();
            LunarAccountConfig value$iv = this.getAccountConfig();
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            FilesKt.writeText$default(accountsFile, this_$iv.encodeToString((SerializationStrategy)LunarAccountConfig.Companion.serializer(), value$iv), null, 2, null);
        }
    }

    private static final LunarAccountConfig accountConfig_delegate$lambda$0() {
        if (!accountsFile.exists()) {
            return new LunarAccountConfig(null, null, 3, null);
        }
        String content = FilesKt.readText$default(accountsFile, null, 1, null);
        return (LunarAccountConfig)CelestialKt.getJSON().decodeFromString((DeserializationStrategy)LunarAccountConfig.Companion.serializer(), content);
    }

    static {
        Logger logger = LoggerFactory.getLogger(AccountManager.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        log = logger;
        accountsFile = new File(System.getProperty("user.home"), ".lunarclient/settings/game/accounts.json");
        accountConfig$delegate = LazyKt.lazy(AccountManager::accountConfig_delegate$lambda$0);
    }
}

