/*
 * Decompiled with CFR 0.152.
 */
package org.cubewhy.celestial.event;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import org.cubewhy.celestial.event.Event;
import org.cubewhy.celestial.event.EventData;
import org.cubewhy.celestial.event.EventPriority;
import org.cubewhy.celestial.event.EventTarget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00070\u0006H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0010\u0010\r\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00070\u0006H\u0002J,\u0010\u0012\u001a\u0016\u0012\u0004\u0012\u00020\t\u0018\u00010\bj\n\u0012\u0004\u0012\u00020\t\u0018\u0001`\n2\u0010\u0010\r\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00070\u0006J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J \u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00012\u0010\u0010\r\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00070\u0006J\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0001J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001J \u0010\u0017\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00012\u0010\u0010\r\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00070\u0006J\u000e\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0001R8\u0010\u0004\u001a,\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00070\u0006\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t\u0018\u00010\bj\n\u0012\u0004\u0012\u00020\t\u0018\u0001`\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/cubewhy/celestial/event/EventManager;", "", "<init>", "()V", "REGISTRY_MAP", "", "Ljava/lang/Class;", "Lorg/cubewhy/celestial/event/Event;", "Ljava/util/ArrayList;", "Lorg/cubewhy/celestial/event/EventData;", "Lkotlin/collections/ArrayList;", "sortListValue", "", "clazz", "isMethodBad", "", "method", "Ljava/lang/reflect/Method;", "get", "cleanMap", "removeOnlyEmptyValues", "unregister", "o", "register", "celestial"})
public final class EventManager {
    @NotNull
    public static final EventManager INSTANCE = new EventManager();
    @NotNull
    private static final Map<Class<? extends Event>, ArrayList<EventData>> REGISTRY_MAP = new HashMap();

    private EventManager() {
    }

    private final void sortListValue(Class<? extends Event> clazz) {
        ArrayList<EventData> flexibleArray = new ArrayList<EventData>();
        for (byte b : EventPriority.INSTANCE.getValueArray()) {
            Iterator<EventData> iterator2;
            ArrayList<EventData> arrayList = REGISTRY_MAP.get(clazz);
            Intrinsics.checkNotNull(arrayList);
            Intrinsics.checkNotNullExpressionValue(arrayList.iterator(), "iterator(...)");
            while (iterator2.hasNext()) {
                EventData methodData;
                Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
                if (methodData.getPriority() != b) continue;
                flexibleArray.add(methodData);
            }
        }
        REGISTRY_MAP.put(clazz, flexibleArray);
    }

    private final boolean isMethodBad(Method method) {
        return method.getParameterTypes().length != 1 || !method.isAnnotationPresent(EventTarget.class);
    }

    private final boolean isMethodBad(Method method, Class<? extends Event> clazz) {
        return this.isMethodBad(method) || Intrinsics.areEqual(method.getParameterTypes()[0], clazz);
    }

    @Nullable
    public final ArrayList<EventData> get(@NotNull Class<? extends Event> clazz) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        return REGISTRY_MAP.get(clazz);
    }

    private final void cleanMap(boolean removeOnlyEmptyValues) {
        Iterator<Map.Entry<Class<? extends Event>, ArrayList<EventData>>> iterator2 = REGISTRY_MAP.entrySet().iterator();
        while (iterator2.hasNext()) {
            if (removeOnlyEmptyValues) {
                ArrayList<EventData> arrayList = iterator2.next().getValue();
                Intrinsics.checkNotNull(arrayList);
                if (!arrayList.isEmpty()) continue;
            }
            iterator2.remove();
        }
    }

    public final void unregister(@NotNull Object o, @NotNull Class<? extends Event> clazz) {
        Intrinsics.checkNotNullParameter(o, "o");
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        if (REGISTRY_MAP.containsKey(clazz)) {
            ArrayList<EventData> arrayList = REGISTRY_MAP.get(clazz);
            Intrinsics.checkNotNull(arrayList);
            Iterator<EventData> iterator2 = arrayList.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
            Iterator<EventData> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                EventData methodData;
                Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
                if (!Intrinsics.areEqual(methodData.getSource(), o)) continue;
                ArrayList<EventData> arrayList2 = REGISTRY_MAP.get(clazz);
                Intrinsics.checkNotNull(arrayList2);
                arrayList2.remove(methodData);
            }
        }
        this.cleanMap(true);
    }

    public final void unregister(@NotNull Object o) {
        Intrinsics.checkNotNullParameter(o, "o");
        Iterator<ArrayList<EventData>> iterator2 = REGISTRY_MAP.values().iterator();
        while (iterator2.hasNext()) {
            ArrayList<EventData> flexibleArray;
            ArrayList<EventData> arrayList = flexibleArray = iterator2.next();
            Intrinsics.checkNotNull(arrayList);
            int n = ((Collection)arrayList).size() + -1;
            if (0 > n) continue;
            do {
                int i;
                if (!Intrinsics.areEqual(flexibleArray.get(i = n--).getSource(), o)) continue;
                flexibleArray.remove(i);
            } while (0 <= n);
        }
        this.cleanMap(true);
    }

    public final void register(@NotNull Method method, @Nullable Object o) {
        Intrinsics.checkNotNullParameter(method, "method");
        Class<?> clazz = method.getParameterTypes()[0];
        Object object = o;
        Intrinsics.checkNotNull(object);
        EventData methodData = new EventData(object, method, method.getAnnotation(EventTarget.class).value());
        if (!methodData.getTarget().isAccessible()) {
            methodData.getTarget().setAccessible(true);
        }
        if (REGISTRY_MAP.containsKey(clazz)) {
            ArrayList<EventData> arrayList = REGISTRY_MAP.get(clazz);
            Intrinsics.checkNotNull(arrayList);
            if (!arrayList.contains(methodData)) {
                ArrayList<EventData> arrayList2 = REGISTRY_MAP.get(clazz);
                Intrinsics.checkNotNull(arrayList2);
                arrayList2.add(methodData);
                Intrinsics.checkNotNull(clazz, "null cannot be cast to non-null type java.lang.Class<out org.cubewhy.celestial.event.Event?>");
                this.sortListValue(clazz);
            }
        } else {
            Intrinsics.checkNotNull(clazz, "null cannot be cast to non-null type java.lang.Class<out org.cubewhy.celestial.event.Event?>");
            REGISTRY_MAP.put(clazz, new ArrayList<EventData>(methodData){
                {
                    this.add($methodData);
                }
            });
        }
    }

    public final void register(@NotNull Object o, @NotNull Class<? extends Event> clazz) {
        Intrinsics.checkNotNullParameter(o, "o");
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        Iterator<Method> iterator2 = ArrayIteratorKt.iterator(o.getClass().getMethods());
        while (iterator2.hasNext()) {
            Method method = iterator2.next();
            Intrinsics.checkNotNull(method);
            if (this.isMethodBad(method, clazz)) continue;
            this.register(method, o);
        }
    }

    public final void register(@NotNull Object o) {
        Intrinsics.checkNotNullParameter(o, "o");
        Iterator<Method> iterator2 = ArrayIteratorKt.iterator(o.getClass().getMethods());
        while (iterator2.hasNext()) {
            Method method = iterator2.next();
            Intrinsics.checkNotNull(method);
            if (this.isMethodBad(method)) continue;
            this.register(method, o);
        }
    }
}

