/*
 * Decompiled with CFR 0.152.
 */
package org.cubewhy.celestial;

import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import org.apache.commons.io.FileUtils;
import org.cubewhy.celestial.CelestialKt;
import org.cubewhy.celestial.Wrapper;
import org.cubewhy.celestial.event.EventManager;
import org.cubewhy.celestial.event.impl.GameStartEvent;
import org.cubewhy.celestial.event.impl.GameTerminateEvent;
import org.cubewhy.celestial.game.GameProperties;
import org.cubewhy.celestial.game.GameWebsocketServer;
import org.cubewhy.celestial.game.LaunchCommand;
import org.cubewhy.celestial.game.LaunchCommandJson;
import org.cubewhy.celestial.game.addon.JavaAgent;
import org.cubewhy.celestial.gui.elements.GuiVersionListKt;
import org.cubewhy.celestial.utils.FileUtilsKt;
import org.cubewhy.celestial.utils.GitUtils;
import org.cubewhy.celestial.utils.OSEnum;
import org.cubewhy.celestial.utils.SystemUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0006\u0010\u0005\u001a\u00020\u0006\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0002\u001a\u0006\u0010\n\u001a\u00020\u0004\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b\u001a\u0006\u0010\u000e\u001a\u00020\f\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "main", "", "generateScripts", "", "complete", "Lorg/cubewhy/celestial/game/LaunchCommand;", "Lorg/cubewhy/celestial/game/LaunchCommandJson;", "completeSession", "launch", "Ljava/lang/Process;", "cmd", "launchPrevious", "celestial"})
@SourceDebugExtension(value={"SMAP\nWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Wrapper.kt\norg/cubewhy/celestial/WrapperKt\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,214:1\n222#2:215\n222#2:234\n1563#3:216\n1634#3,3:217\n1563#3:220\n1634#3,3:221\n1563#3:224\n1634#3,3:225\n1563#3:228\n1634#3,3:229\n1869#3,2:232\n*S KotlinDebug\n*F\n+ 1 Wrapper.kt\norg/cubewhy/celestial/WrapperKt\n*L\n65#1:215\n212#1:234\n97#1:216\n97#1:217,3\n124#1:220\n124#1:221,3\n128#1:224\n128#1:225,3\n129#1:228\n129#1:229,3\n165#1:232,2\n*E\n"})
public final class WrapperKt {
    private static Logger log = LoggerFactory.getLogger(Wrapper.class);

    /*
     * WARNING - void declaration
     */
    public static final void main() {
        void this_$iv;
        EventManager.INSTANCE.register(Wrapper.INSTANCE);
        log.info("Powered by Celestial");
        log.info("https://lunarclient.top");
        log.info("Celestial is running on Java: " + System.getProperty("java.version") + " JVM: " + System.getProperty("java.vm.version") + "(" + System.getProperty("java.vendor") + ") Arch: " + System.getProperty("os.arch"));
        log.info("Celestial v" + GitUtils.INSTANCE.getBuildVersion() + " build by " + GitUtils.INSTANCE.getBuildUser());
        log.info("Git remote: " + GitUtils.INSTANCE.getRemote() + " (" + GitUtils.INSTANCE.getBranch() + ")");
        String jsonPath = System.getProperty("celestial.json");
        Object object = jsonPath;
        if (object == null || (object = FileUtilsKt.toFile((String)object)) == null) {
            object = CelestialKt.getLaunchJson();
        }
        Object commandFile = object;
        log.info("Launching via " + (File)commandFile);
        Json json = CelestialKt.getJSON();
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
        String string$iv = FilesKt.readText((File)commandFile, charset);
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        LaunchCommandJson launchCommandJson = (LaunchCommandJson)this_$iv.decodeFromString((DeserializationStrategy)LaunchCommandJson.Companion.serializer(), string$iv);
        LaunchCommand command2 = WrapperKt.complete(launchCommandJson);
        int code = WrapperKt.launch(command2).waitFor();
        log.info("Game terminated (code=" + code + ")");
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String generateScripts() {
        void $this$mapTo$iv$iv;
        StringBuilder sb = new StringBuilder();
        String classpath = System.getProperty("java.class.path");
        StringBuilder stringBuilder = OSEnum.Companion.getCurrent() == OSEnum.Windows ? sb.append("@echo off\n").append("@rem This script was generated by Celestial Launcher v" + GitUtils.INSTANCE.getBuildVersion() + "\n").append("@rem Powered by Celestial https://lunarclient.top\n").append("@rem View the real commandline in " + CelestialKt.getLaunchJson().getName() + "\n") : sb.append("# This script was generated by Celestial Launcher v" + GitUtils.INSTANCE.getBuildVersion() + "\n").append("# Powered by Celestial https://lunarclient.top\n").append("# View the real commandline in " + CelestialKt.getLaunchJson().getName() + "\n");
        List command2 = new ArrayList();
        String string = SystemUtilsKt.getCurrentJavaExec().getPath();
        Intrinsics.checkNotNullExpressionValue(string, "getPath(...)");
        command2.add(string);
        command2.add("-cp");
        String splitChar = OSEnum.Windows.isCurrent() ? ";" : ":";
        Intrinsics.checkNotNull(classpath);
        String[] stringArray = new String[]{splitChar};
        command2.add(CollectionsKt.joinToString$default(StringsKt.split$default((CharSequence)classpath, stringArray, false, 0, 6, null), splitChar, null, null, 0, null, WrapperKt::generateScripts$lambda$0, 30, null));
        command2.add("-Dcelestial.json=" + CelestialKt.getLaunchJson().getPath());
        command2.add(Wrapper.class.getCanonicalName() + "Kt");
        Iterable $this$map$iv = command2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(sb.append((String)(StringsKt.contains$default((CharSequence)it, " ", false, 2, null) ? "\"" + (String)it + "\"" : it)).append(" "));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        String string3 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        return string3;
    }

    private static final LaunchCommand complete(LaunchCommandJson $this$complete) {
        Collection<File> collection;
        Collection<File> collection2;
        String it;
        Collection<File> collection3;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        List<JavaAgent> javaAgents = JavaAgent.Companion.findEnabled();
        if (CelestialKt.getConfig().getAddon().getWeave().getState()) {
            log.info("Weave is enabled!");
            javaAgents.add(new JavaAgent(CelestialKt.getConfig().getAddon().getWeave().getInstallationDir(), null, false, 2, null));
        }
        if (CelestialKt.getConfig().getAddon().getLunarcn().getState()) {
            log.info("LunarCN is enabled!");
            log.warn("LunarCN Loader is deprecated.");
            javaAgents.add(new JavaAgent(CelestialKt.getConfig().getAddon().getLunarcn().getInstallationDir(), null, false, 6, null));
        }
        if (CelestialKt.getConfig().getAddon().getLcqt().getState()) {
            log.info("LunarQT is enabled!");
            javaAgents.add(new JavaAgent(CelestialKt.getConfig().getAddon().getLcqt().getInstallationDir(), null, false, 6, null));
        }
        log.info("Found " + ((Collection)javaAgents).size() + " javaagents");
        Iterable iterable = $this$complete.getNatives();
        String string = $this$complete.getMainClass();
        String string2 = $this$complete.getWrapper();
        File file = FileUtilsKt.toFile($this$complete.getJre());
        File file2 = FileUtilsKt.toFile($this$complete.getInstallation());
        boolean $i$f$map = false;
        void var4_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string3 = (String)item$iv$iv;
            collection3 = destination$iv$iv;
            boolean bl = false;
            collection3.add(new File(it));
        }
        collection3 = (List)destination$iv$iv;
        $this$map$iv = $this$complete.getClasspath();
        List<JavaAgent> list = javaAgents;
        List<String> list2 = $this$complete.getProgramArgs();
        List<String> list3 = $this$complete.getVmArgs();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(FileUtilsKt.toFile(it));
        }
        collection2 = (List)destination$iv$iv;
        $this$map$iv = $this$complete.getIchorpath();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FileUtilsKt.toFile(it));
        }
        collection = (List)destination$iv$iv;
        GameProperties gameProperties = new GameProperties(CelestialKt.getConfig().getGame().getResize().getWidth(), CelestialKt.getConfig().getGame().getResize().getHeight(), new File(CelestialKt.getConfig().getGame().getGameDir()));
        String string4 = $this$complete.getGameVersion();
        int n = $this$complete.getIpcPort();
        Collection<File> collection4 = collection;
        Collection<File> collection5 = collection2;
        List<JavaAgent> list4 = list;
        List<String> list5 = list2;
        List<String> list6 = list3;
        Collection<File> collection6 = collection3;
        String string5 = string;
        String string6 = string2;
        File file3 = file;
        File file4 = file2;
        return new LaunchCommand(file4, file3, string6, string5, (List<? extends File>)collection6, list6, list5, list4, (List<? extends File>)collection5, (List<? extends File>)collection4, n, string4, gameProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void completeSession() {
        if (!CelestialKt.getSessionFile().exists()) {
            log.info("Completing session.json to fix the network error for LunarClient");
            byte[] json = null;
            Object object = FileUtilsKt.getInputStream("/game/session.json");
            Object object2 = null;
            try {
                InputStream stream = (InputStream)object;
                boolean bl = false;
                InputStream inputStream2 = stream;
                json = (byte[])(inputStream2 != null ? inputStream2.readAllBytes() : null);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            File file = CelestialKt.getSessionFile();
            Intrinsics.checkNotNull(json);
            object = json;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
            object2 = charset;
            FileUtils.writeStringToFile(file, JsonParser.parseString(new String((byte[])object, (Charset)object2)).toString(), StandardCharsets.UTF_8);
        }
    }

    @NotNull
    public static final Process launch(@NotNull LaunchCommand cmd) {
        Intrinsics.checkNotNullParameter(cmd, "cmd");
        log.info("Patching network disable...");
        WrapperKt.completeSession();
        log.info("Unzipping natives");
        try {
            Iterable $this$forEach$iv = cmd.getNatives();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                GuiVersionListKt.unzipNatives(it, cmd.getInstallation());
            }
        }
        catch (Exception e) {
            log.error("Failed to unzip natives. Does the game running?");
            log.error(ExceptionsKt.stackTraceToString(e));
        }
        log.info("Starting websocket server...");
        GameWebsocketServer server = cmd.startWebsocketServer();
        if (server == null) {
            log.info("The websocket server was disabled.");
        }
        log.info("Generating command...");
        Thread.sleep(1000L);
        GameWebsocketServer gameWebsocketServer = server;
        List<String> commandList = cmd.generateCommand(gameWebsocketServer != null ? gameWebsocketServer.getPort() : -1);
        log.debug(CollectionsKt.joinToString$default(commandList, " ", null, null, 0, null, null, 62, null));
        log.info("Executing command...");
        ProcessBuilder pb = new ProcessBuilder(commandList).redirectErrorStream(true).directory(cmd.getInstallation());
        Process process = pb.start();
        long pid = process.pid();
        new Thread(() -> WrapperKt.launch$lambda$10(process)).start();
        Thread.sleep(3000L);
        log.info("Game is running! (PID: " + pid + ")");
        new GameStartEvent(pid).call();
        process.onExit().thenAccept(arg_0 -> WrapperKt.launch$lambda$12(arg_0 -> WrapperKt.launch$lambda$11(server, arg_0), arg_0));
        Intrinsics.checkNotNull(process);
        return process;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Process launchPrevious() {
        void this_$iv;
        Json json = CelestialKt.getJSON();
        File file = CelestialKt.getLaunchJson();
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
        String string$iv = FilesKt.readText(file, charset);
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        LaunchCommandJson launchCommandJson = (LaunchCommandJson)this_$iv.decodeFromString((DeserializationStrategy)LaunchCommandJson.Companion.serializer(), string$iv);
        return WrapperKt.launch(WrapperKt.complete(launchCommandJson));
    }

    public static /* synthetic */ void main(String[] args) {
        WrapperKt.main();
    }

    private static final CharSequence generateScripts$lambda$0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String string = new File(it).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue(string, "getAbsolutePath(...)");
        return string;
    }

    private static final Unit launch$lambda$10$lambda$9$lambda$7(String line) {
        log.info(line);
        return Unit.INSTANCE;
    }

    private static final void launch$lambda$10$lambda$9$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void launch$lambda$10(Process $process) {
        Closeable closeable = new BufferedReader(new InputStreamReader($process.getInputStream()));
        Throwable throwable = null;
        try {
            BufferedReader reader = (BufferedReader)closeable;
            boolean bl = false;
            reader.lines().forEach(arg_0 -> WrapperKt.launch$lambda$10$lambda$9$lambda$8(WrapperKt::launch$lambda$10$lambda$9$lambda$7, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    private static final Unit launch$lambda$11(GameWebsocketServer $server, Process it) {
        block0: {
            new GameTerminateEvent(it.exitValue()).call();
            GameWebsocketServer gameWebsocketServer = $server;
            if (gameWebsocketServer == null) break block0;
            gameWebsocketServer.stop();
        }
        return Unit.INSTANCE;
    }

    private static final void launch$lambda$12(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Logger access$getLog$p() {
        return log;
    }
}

