/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.relocate.spongepowered.tools.obfuscation;

import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import net.weavemc.relocate.spongepowered.asm.mixin.Implements;
import net.weavemc.relocate.spongepowered.asm.mixin.Overwrite;
import net.weavemc.relocate.spongepowered.asm.mixin.Shadow;
import net.weavemc.relocate.spongepowered.asm.mixin.gen.Accessor;
import net.weavemc.relocate.spongepowered.asm.mixin.gen.Invoker;
import net.weavemc.relocate.spongepowered.tools.obfuscation.MixinObfuscationProcessor;
import net.weavemc.relocate.spongepowered.tools.obfuscation.interfaces.IMessagerEx;
import net.weavemc.relocate.spongepowered.tools.obfuscation.mirror.AnnotationHandle;
import net.weavemc.relocate.spongepowered.tools.obfuscation.mirror.TypeUtils;

@SupportedAnnotationTypes(value={"org.spongepowered.asm.mixin.Mixin", "org.spongepowered.asm.mixin.Shadow", "org.spongepowered.asm.mixin.Overwrite", "org.spongepowered.asm.mixin.gen.Accessor", "org.spongepowered.asm.mixin.Implements"})
public class MixinObfuscationProcessorTargets
extends MixinObfuscationProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.postProcess(roundEnv);
            return true;
        }
        this.processMixins(roundEnv);
        this.processShadows(roundEnv);
        this.processOverwrites(roundEnv);
        this.processAccessors(roundEnv);
        this.processInvokers(roundEnv);
        this.processImplements(roundEnv);
        this.postProcess(roundEnv);
        return true;
    }

    @Override
    protected void postProcess(RoundEnvironment roundEnv) {
        super.postProcess(roundEnv);
        try {
            this.mixins.writeReferences();
            this.mixins.writeMappings();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void processShadows(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Shadow.class)) {
            Element parent = element.getEnclosingElement();
            if (!(parent instanceof TypeElement)) {
                this.mixins.printMessage(IMessagerEx.MessageType.ERROR, (CharSequence)("Unexpected parent with type " + TypeUtils.getElementType(parent)), element);
                continue;
            }
            AnnotationHandle shadow = AnnotationHandle.of(element, Shadow.class);
            if (element.getKind() == ElementKind.FIELD) {
                this.mixins.registerShadow((TypeElement)parent, (VariableElement)element, shadow);
                continue;
            }
            if (element.getKind() == ElementKind.METHOD) {
                this.mixins.registerShadow((TypeElement)parent, (ExecutableElement)element, shadow);
                continue;
            }
            this.mixins.printMessage(IMessagerEx.MessageType.SHADOW_ON_INVALID_ELEMENT, (CharSequence)"Element is not a method or field", element);
        }
    }

    private void processOverwrites(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Overwrite.class)) {
            Element parent = element.getEnclosingElement();
            if (!(parent instanceof TypeElement)) {
                this.mixins.printMessage(IMessagerEx.MessageType.ERROR, (CharSequence)("Unexpected parent with type " + TypeUtils.getElementType(parent)), element);
                continue;
            }
            if (element.getKind() == ElementKind.METHOD) {
                this.mixins.registerOverwrite((TypeElement)parent, (ExecutableElement)element);
                continue;
            }
            this.mixins.printMessage(IMessagerEx.MessageType.OVERWRITE_ON_NON_METHOD_ELEMENT, (CharSequence)"Element is not a method", element);
        }
    }

    private void processAccessors(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Accessor.class)) {
            Element parent = element.getEnclosingElement();
            if (!(parent instanceof TypeElement)) {
                this.mixins.printMessage(IMessagerEx.MessageType.ERROR, (CharSequence)("Unexpected parent with type " + TypeUtils.getElementType(parent)), element);
                continue;
            }
            if (element.getKind() == ElementKind.METHOD) {
                this.mixins.registerAccessor((TypeElement)parent, (ExecutableElement)element);
                continue;
            }
            this.mixins.printMessage(IMessagerEx.MessageType.ACCESSOR_ON_NON_METHOD_ELEMENT, (CharSequence)"Element is not a method", element);
        }
    }

    private void processInvokers(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Invoker.class)) {
            Element parent = element.getEnclosingElement();
            if (!(parent instanceof TypeElement)) {
                this.mixins.printMessage(IMessagerEx.MessageType.ERROR, (CharSequence)("Unexpected parent with type " + TypeUtils.getElementType(parent)), element);
                continue;
            }
            if (element.getKind() == ElementKind.METHOD) {
                this.mixins.registerInvoker((TypeElement)parent, (ExecutableElement)element);
                continue;
            }
            this.mixins.printMessage(IMessagerEx.MessageType.ACCESSOR_ON_NON_METHOD_ELEMENT, (CharSequence)"Element is not a method", element);
        }
    }

    private void processImplements(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Implements.class)) {
            if (element.getKind() == ElementKind.CLASS || element.getKind() == ElementKind.INTERFACE) {
                AnnotationHandle implementsAnnotation = AnnotationHandle.of(element, Implements.class);
                this.mixins.registerSoftImplements((TypeElement)element, implementsAnnotation);
                continue;
            }
            this.mixins.printMessage(IMessagerEx.MessageType.SOFT_IMPLEMENTS_ON_INVALID_TYPE, (CharSequence)"Found an @Implements annotation on an element which is not a class or interface", element);
        }
    }
}

