/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.relocate.spongepowered.asm.util;

public abstract class ObfuscationUtil {
    private ObfuscationUtil() {
    }

    public static String mapDescriptor(String desc, IClassRemapper remapper2) {
        return ObfuscationUtil.remapDescriptor(desc, remapper2, false);
    }

    public static String unmapDescriptor(String desc, IClassRemapper remapper2) {
        return ObfuscationUtil.remapDescriptor(desc, remapper2, true);
    }

    private static String remapDescriptor(String desc, IClassRemapper remapper2, boolean unmap) {
        StringBuilder sb = new StringBuilder();
        StringBuilder token = null;
        for (int pos = 0; pos < desc.length(); ++pos) {
            char c = desc.charAt(pos);
            if (token != null) {
                if (c == ';') {
                    sb.append('L').append(ObfuscationUtil.remap(token.toString(), remapper2, unmap)).append(';');
                    token = null;
                    continue;
                }
                token.append(c);
                continue;
            }
            if (c == 'L') {
                token = new StringBuilder();
                continue;
            }
            sb.append(c);
        }
        if (token != null) {
            throw new IllegalArgumentException("Invalid descriptor '" + desc + "', missing ';'");
        }
        return sb.toString();
    }

    private static Object remap(String typeName, IClassRemapper remapper2, boolean unmap) {
        String result = unmap ? remapper2.unmap(typeName) : remapper2.map(typeName);
        return result != null ? result : typeName;
    }

    public static interface IClassRemapper {
        public String map(String var1);

        public String unmap(String var1);
    }
}

