/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.relocate.spongepowered.asm.mixin.transformer;

import java.util.HashMap;
import java.util.Map;
import net.weavemc.relocate.spongepowered.asm.mixin.throwables.MixinError;
import net.weavemc.relocate.spongepowered.asm.service.ISyntheticClassInfo;
import net.weavemc.relocate.spongepowered.asm.service.ISyntheticClassRegistry;

class SyntheticClassRegistry
implements ISyntheticClassRegistry {
    private final Map<String, ISyntheticClassInfo> classes = new HashMap<String, ISyntheticClassInfo>();

    SyntheticClassRegistry() {
    }

    @Override
    public ISyntheticClassInfo findSyntheticClass(String name) {
        if (name == null) {
            return null;
        }
        return this.classes.get(name.replace('.', '/'));
    }

    void registerSyntheticClass(ISyntheticClassInfo sci) {
        String name = sci.getName();
        ISyntheticClassInfo info = this.classes.get(name);
        if (info != null) {
            if (info == sci) {
                return;
            }
            throw new MixinError("Synthetic class with name " + name + " was already registered by " + info.getMixin() + ". Duplicate being registered by " + sci.getMixin());
        }
        this.classes.put(name, sci);
    }
}

