/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.relocate.spongepowered.asm.mixin.transformer;

import java.util.ArrayList;
import net.weavemc.relocate.asm.tree.ClassNode;
import net.weavemc.relocate.spongepowered.asm.mixin.transformer.MixinCoprocessor;
import net.weavemc.relocate.spongepowered.asm.util.perf.Profiler;

class MixinCoprocessors
extends ArrayList<MixinCoprocessor> {
    private static final long serialVersionUID = 1L;
    private final Profiler profiler = Profiler.getProfiler("mixin");

    MixinCoprocessors() {
    }

    MixinCoprocessor.ProcessResult process(String className, ClassNode classNode) {
        Profiler.Section timer = this.profiler.begin("coprocessor");
        MixinCoprocessor.ProcessResult result = MixinCoprocessor.ProcessResult.NONE;
        for (MixinCoprocessor coprocessor : this) {
            result = coprocessor.process(className, classNode).with(result);
        }
        timer.end();
        return result;
    }

    boolean postProcess(String className, ClassNode classNode) {
        Profiler.Section timer = this.profiler.begin("coprocessor");
        boolean transformed = false;
        for (MixinCoprocessor coprocessor : this) {
            transformed |= coprocessor.postProcess(className, classNode);
        }
        timer.end();
        return transformed;
    }
}

