/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.relocate.spongepowered.asm.mixin.transformer;

import java.util.HashSet;
import java.util.Set;
import net.weavemc.relocate.asm.tree.ClassNode;
import net.weavemc.relocate.asm.tree.FieldNode;
import net.weavemc.relocate.asm.tree.MethodNode;
import net.weavemc.relocate.spongepowered.asm.mixin.transformer.MixinCoprocessor;
import net.weavemc.relocate.spongepowered.asm.mixin.transformer.MixinInfo;

class MixinCoprocessorSyntheticInner
extends MixinCoprocessor {
    private final Set<String> syntheticInnerClasses = new HashSet<String>();

    MixinCoprocessorSyntheticInner() {
    }

    @Override
    String getName() {
        return "syntheticinner";
    }

    @Override
    public void onInit(MixinInfo mixin) {
        for (String innerClass : mixin.getSyntheticInnerClasses()) {
            this.registerSyntheticInner(innerClass.replace('/', '.'));
        }
    }

    void registerSyntheticInner(String className) {
        this.syntheticInnerClasses.add(className);
    }

    @Override
    MixinCoprocessor.ProcessResult process(String className, ClassNode classNode) {
        if (!this.syntheticInnerClasses.contains(className)) {
            return MixinCoprocessor.ProcessResult.NONE;
        }
        classNode.access |= 1;
        for (FieldNode field : classNode.fields) {
            if ((field.access & 6) != 0) continue;
            field.access |= 1;
        }
        for (MethodNode method : classNode.methods) {
            if ((method.access & 6) != 0) continue;
            method.access |= 1;
        }
        return MixinCoprocessor.ProcessResult.PASSTHROUGH_TRANSFORMED;
    }
}

