/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.relocate.spongepowered.asm.mixin.transformer;

import java.util.HashSet;
import java.util.Set;
import net.weavemc.relocate.asm.tree.ClassNode;
import net.weavemc.relocate.spongepowered.asm.mixin.transformer.MixinCoprocessor;
import net.weavemc.relocate.spongepowered.asm.mixin.transformer.MixinInfo;

class MixinCoprocessorPassthrough
extends MixinCoprocessor {
    private final Set<String> loadable = new HashSet<String>();

    MixinCoprocessorPassthrough() {
    }

    @Override
    String getName() {
        return "passthrough";
    }

    @Override
    public void onPrepare(MixinInfo mixin) {
        if (mixin.isLoadable()) {
            this.registerLoadable(mixin.getClassName());
        }
    }

    void registerLoadable(String className) {
        this.loadable.add(className);
    }

    @Override
    MixinCoprocessor.ProcessResult process(String className, ClassNode classNode) {
        return this.loadable.contains(className) ? MixinCoprocessor.ProcessResult.PASSTHROUGH_NONE : MixinCoprocessor.ProcessResult.NONE;
    }
}

