/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.relocate.spongepowered.asm.mixin.transformer;

import java.util.Map;
import net.weavemc.relocate.asm.tree.FieldNode;
import net.weavemc.relocate.asm.tree.MethodNode;
import net.weavemc.relocate.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import net.weavemc.relocate.spongepowered.asm.mixin.injection.throwables.InvalidInjectionException;
import net.weavemc.relocate.spongepowered.asm.mixin.refmap.IMixinContext;
import net.weavemc.relocate.spongepowered.asm.mixin.transformer.ClassInfo;
import net.weavemc.relocate.spongepowered.asm.mixin.transformer.MixinApplicatorStandard;
import net.weavemc.relocate.spongepowered.asm.mixin.transformer.MixinTargetContext;
import net.weavemc.relocate.spongepowered.asm.mixin.transformer.TargetClassContext;
import net.weavemc.relocate.spongepowered.asm.mixin.transformer.throwables.InvalidInterfaceMixinException;

class MixinApplicatorInterface
extends MixinApplicatorStandard {
    MixinApplicatorInterface(TargetClassContext context) {
        super(context);
    }

    @Override
    protected void applyInterfaces(MixinTargetContext mixin) {
        for (String interfaceName : mixin.getInterfaces()) {
            if (this.targetClass.name.equals(interfaceName) || this.targetClass.interfaces.contains(interfaceName)) continue;
            this.targetClass.interfaces.add(interfaceName);
            mixin.getTargetClassInfo().addInterface(interfaceName);
        }
    }

    @Override
    protected void applyFields(MixinTargetContext mixin) {
        for (Map.Entry<FieldNode, ClassInfo.Field> entry : mixin.getShadowFields()) {
            FieldNode shadow = entry.getKey();
            this.logger.error("Ignoring redundant @Shadow field {}:{} in {}", shadow.name, shadow.desc, mixin);
        }
        this.mergeNewFields(mixin);
    }

    @Override
    protected void applyInitialisers(MixinTargetContext mixin) {
    }

    @Override
    protected void prepareInjections(MixinTargetContext mixin) {
        for (MethodNode method : this.targetClass.methods) {
            try {
                InjectionInfo injectInfo = InjectionInfo.parse(mixin, method);
                if (injectInfo == null) continue;
                throw new InvalidInterfaceMixinException((IMixinContext)mixin, injectInfo + " is not supported on interface mixin method " + method.name);
            }
            catch (InvalidInjectionException ex) {
                String description = ex.getContext() != null ? ex.getContext().toString() : "Injection";
                throw new InvalidInterfaceMixinException((IMixinContext)mixin, description + " is not supported in interface mixin");
            }
        }
    }

    @Override
    protected void applyInjections(MixinTargetContext mixin) {
    }
}

