/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.relocate.spongepowered.asm.mixin.injection.struct;

import java.util.List;
import net.weavemc.relocate.asm.Type;
import net.weavemc.relocate.asm.tree.AnnotationNode;
import net.weavemc.relocate.asm.tree.MethodNode;
import net.weavemc.relocate.google.common.base.Strings;
import net.weavemc.relocate.google.common.collect.ImmutableList;
import net.weavemc.relocate.spongepowered.asm.mixin.injection.Constant;
import net.weavemc.relocate.spongepowered.asm.mixin.injection.ModifyConstant;
import net.weavemc.relocate.spongepowered.asm.mixin.injection.code.Injector;
import net.weavemc.relocate.spongepowered.asm.mixin.injection.invoke.ModifyConstantInjector;
import net.weavemc.relocate.spongepowered.asm.mixin.injection.points.BeforeConstant;
import net.weavemc.relocate.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import net.weavemc.relocate.spongepowered.asm.mixin.transformer.MixinTargetContext;

@InjectionInfo.AnnotationType(value=ModifyConstant.class)
@InjectionInfo.HandlerPrefix(value="constant")
public class ModifyConstantInjectionInfo
extends InjectionInfo {
    private static final String CONSTANT_ANNOTATION_CLASS = Constant.class.getName().replace('.', '/');

    public ModifyConstantInjectionInfo(MixinTargetContext mixin, MethodNode method, AnnotationNode annotation) {
        super(mixin, method, annotation, "constant");
    }

    @Override
    protected List<AnnotationNode> readInjectionPoints() {
        List<AnnotationNode> ats = super.readInjectionPoints();
        if (ats.isEmpty()) {
            AnnotationNode c = new AnnotationNode(CONSTANT_ANNOTATION_CLASS);
            c.visit("log", Boolean.TRUE);
            ats = ImmutableList.of(c);
        }
        return ats;
    }

    @Override
    protected void parseInjectionPoints(List<AnnotationNode> ats) {
        Type returnType = Type.getReturnType(this.method.desc);
        for (AnnotationNode at : ats) {
            this.injectionPoints.add(new BeforeConstant(this.getMixin(), at, returnType.getDescriptor()));
        }
    }

    @Override
    protected Injector parseInjector(AnnotationNode injectAnnotation) {
        return new ModifyConstantInjector(this);
    }

    @Override
    protected String getDescription() {
        return "Constant modifier method";
    }

    @Override
    public String getSliceId(String id) {
        return Strings.nullToEmpty(id);
    }
}

