/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.relocate.spongepowered.asm.mixin.injection.points;

import java.util.Collection;
import net.weavemc.relocate.asm.tree.AbstractInsnNode;
import net.weavemc.relocate.asm.tree.InsnList;
import net.weavemc.relocate.asm.tree.JumpInsnNode;
import net.weavemc.relocate.spongepowered.asm.mixin.injection.InjectionPoint;
import net.weavemc.relocate.spongepowered.asm.mixin.injection.struct.InjectionPointData;

@InjectionPoint.AtCode(value="JUMP")
public class JumpInsnPoint
extends InjectionPoint {
    private final int opCode;
    private final int ordinal;

    public JumpInsnPoint(InjectionPointData data) {
        this.opCode = data.getOpcode(-1, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 198, 199, -1);
        this.ordinal = data.getOrdinal();
    }

    @Override
    public boolean find(String desc, InsnList insns, Collection<AbstractInsnNode> nodes) {
        boolean found = false;
        int ordinal = 0;
        for (AbstractInsnNode insn : insns) {
            if (!(insn instanceof JumpInsnNode) || this.opCode != -1 && insn.getOpcode() != this.opCode) continue;
            if (this.ordinal == -1 || this.ordinal == ordinal) {
                nodes.add(insn);
                found = true;
            }
            ++ordinal;
        }
        return found;
    }
}

