/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.relocate.spongepowered.asm.mixin.injection.invoke;

import net.weavemc.relocate.asm.Type;
import net.weavemc.relocate.asm.tree.AbstractInsnNode;
import net.weavemc.relocate.asm.tree.InsnList;
import net.weavemc.relocate.asm.tree.InsnNode;
import net.weavemc.relocate.asm.tree.MethodInsnNode;
import net.weavemc.relocate.asm.tree.VarInsnNode;
import net.weavemc.relocate.spongepowered.asm.mixin.injection.InjectionPoint;
import net.weavemc.relocate.spongepowered.asm.mixin.injection.invoke.InvokeInjector;
import net.weavemc.relocate.spongepowered.asm.mixin.injection.invoke.arg.ArgsClassGenerator;
import net.weavemc.relocate.spongepowered.asm.mixin.injection.selectors.ISelectorContext;
import net.weavemc.relocate.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import net.weavemc.relocate.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import net.weavemc.relocate.spongepowered.asm.mixin.injection.struct.Target;
import net.weavemc.relocate.spongepowered.asm.mixin.injection.throwables.InvalidInjectionException;
import net.weavemc.relocate.spongepowered.asm.util.Bytecode;

public class ModifyArgsInjector
extends InvokeInjector {
    private final ArgsClassGenerator argsClassGenerator;

    public ModifyArgsInjector(InjectionInfo info) {
        super(info, "@ModifyArgs");
        this.argsClassGenerator = (ArgsClassGenerator)info.getMixin().getExtensions().getGenerator(ArgsClassGenerator.class);
    }

    @Override
    protected void checkTarget(Target target) {
        this.checkTargetModifiers(target, false);
    }

    @Override
    protected void inject(Target target, InjectionNodes.InjectionNode node2) {
        this.checkTargetForNode(target, node2, InjectionPoint.RestrictTargetLevel.ALLOW_ALL);
        super.inject(target, node2);
    }

    @Override
    protected void injectAtInvoke(Target target, InjectionNodes.InjectionNode node2) {
        MethodInsnNode targetMethod = (MethodInsnNode)node2.getCurrentTarget();
        Type[] args2 = Type.getArgumentTypes(targetMethod.desc);
        if (args2.length == 0) {
            throw new InvalidInjectionException((ISelectorContext)this.info, "@ModifyArgs injector " + this + " targets a method invocation " + targetMethod.name + targetMethod.desc + " with no arguments!");
        }
        String clArgs = this.argsClassGenerator.getArgsClass(targetMethod.desc, this.info.getMixin().getMixin()).getName();
        boolean withArgs = this.verifyTarget(target);
        InsnList insns = new InsnList();
        Target.Extension extraStack = target.extendStack().add(1);
        this.packArgs(insns, clArgs, targetMethod);
        if (withArgs) {
            extraStack.add(target.arguments);
            Bytecode.loadArgs(target.arguments, insns, target.isStatic ? 0 : 1);
        }
        this.invokeHandler(insns);
        this.unpackArgs(insns, clArgs, args2);
        extraStack.apply();
        target.insns.insertBefore((AbstractInsnNode)targetMethod, insns);
    }

    private boolean verifyTarget(Target target) {
        String shortDesc = String.format("(L%s;)V", ArgsClassGenerator.ARGS_REF);
        if (!this.methodNode.desc.equals(shortDesc)) {
            String targetDesc = Bytecode.changeDescriptorReturnType(target.method.desc, "V");
            String longDesc = String.format("(L%s;%s", ArgsClassGenerator.ARGS_REF, targetDesc.substring(1));
            if (this.methodNode.desc.equals(longDesc)) {
                return true;
            }
            throw new InvalidInjectionException((ISelectorContext)this.info, "@ModifyArgs injector " + this + " has an invalid signature " + this.methodNode.desc + ", expected " + shortDesc + " or " + longDesc);
        }
        return false;
    }

    private void packArgs(InsnList insns, String clArgs, MethodInsnNode targetMethod) {
        String factoryDesc = Bytecode.changeDescriptorReturnType(targetMethod.desc, "L" + clArgs + ";");
        insns.add(new MethodInsnNode(184, clArgs, "of", factoryDesc, false));
        insns.add(new InsnNode(89));
        if (!this.isStatic) {
            insns.add(new VarInsnNode(25, 0));
            insns.add(new InsnNode(95));
        }
    }

    private void unpackArgs(InsnList insns, String clArgs, Type[] args2) {
        for (int i = 0; i < args2.length; ++i) {
            if (i < args2.length - 1) {
                insns.add(new InsnNode(89));
            }
            insns.add(new MethodInsnNode(182, clArgs, "$" + i, "()" + args2[i].getDescriptor(), false));
            if (i >= args2.length - 1) continue;
            if (args2[i].getSize() == 1) {
                insns.add(new InsnNode(95));
                continue;
            }
            insns.add(new InsnNode(93));
            insns.add(new InsnNode(88));
        }
    }
}

