/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.relocate.spongepowered.asm.mixin.gen;

import net.weavemc.relocate.asm.Type;
import net.weavemc.relocate.asm.tree.InsnNode;
import net.weavemc.relocate.asm.tree.MethodInsnNode;
import net.weavemc.relocate.asm.tree.MethodNode;
import net.weavemc.relocate.asm.tree.VarInsnNode;
import net.weavemc.relocate.spongepowered.asm.mixin.gen.AccessorGenerator;
import net.weavemc.relocate.spongepowered.asm.mixin.gen.AccessorInfo;
import net.weavemc.relocate.spongepowered.asm.util.Bytecode;

public class AccessorGeneratorMethodProxy
extends AccessorGenerator {
    protected final MethodNode targetMethod;
    protected final Type[] argTypes;
    protected final Type returnType;

    public AccessorGeneratorMethodProxy(AccessorInfo info) {
        super(info, Bytecode.isStatic(info.getTargetMethod()));
        this.targetMethod = info.getTargetMethod();
        this.argTypes = info.getArgTypes();
        this.returnType = info.getReturnType();
        this.checkModifiers();
    }

    protected AccessorGeneratorMethodProxy(AccessorInfo info, boolean isStatic) {
        super(info, isStatic);
        this.targetMethod = info.getTargetMethod();
        this.argTypes = info.getArgTypes();
        this.returnType = info.getReturnType();
    }

    @Override
    public MethodNode generate() {
        int size = Bytecode.getArgsSize(this.argTypes) + this.returnType.getSize() + (this.targetIsStatic ? 0 : 1);
        MethodNode method = this.createMethod(size, size);
        if (!this.targetIsStatic) {
            method.instructions.add(new VarInsnNode(25, 0));
        }
        Bytecode.loadArgs(this.argTypes, method.instructions, this.info.isStatic ? 0 : 1);
        boolean isPrivate = Bytecode.hasFlag(this.targetMethod, 2);
        int opcode = this.targetIsStatic ? 184 : (isPrivate ? 183 : 182);
        method.instructions.add(new MethodInsnNode(opcode, this.info.getClassNode().name, this.targetMethod.name, this.targetMethod.desc, false));
        method.instructions.add(new InsnNode(this.returnType.getOpcode(172)));
        return method;
    }
}

